/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections.RCollectionTypeBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;

public final class RCollectionTypeImpl
extends RCollectionTypeBase {
    @NotNull
    private final List<RType> myItemTypes;

    public RCollectionTypeImpl(@NotNull RType baseType, @NotNull List<RType> itemTypes) {
        if (baseType == null) {
            RCollectionTypeImpl.$$$reportNull$$$0(0);
        }
        if (itemTypes == null) {
            RCollectionTypeImpl.$$$reportNull$$$0(1);
        }
        super(baseType);
        this.myItemTypes = List.copyOf(itemTypes);
    }

    @NotNull
    public RType getIndexType() {
        RType rType = RTypeUtil.union(this.myItemTypes);
        if (rType == null) {
            RCollectionTypeImpl.$$$reportNull$$$0(2);
        }
        return rType;
    }

    @NotNull
    public RType getEachType() {
        RType rType = RTypeUtil.union(this.myItemTypes);
        if (rType == null) {
            RCollectionTypeImpl.$$$reportNull$$$0(3);
        }
        return rType;
    }

    @NotNull
    public List<RType> getElementTypes() {
        List<RType> list = this.myItemTypes;
        if (list == null) {
            RCollectionTypeImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public String getName() {
        if (this.myItemTypes.size() > 1 && "Array".equals(this.myOriginalType.getName())) {
            return String.format("[%s]", StringUtil.join(this.myItemTypes, type -> (String)ObjectUtils.coalesce((Object)type.getName(), (Object)RBundle.message((String)"editor.expressionTypeProvider.untypedType")), (String)", "));
        }
        RType indexType = this.getIndexType();
        if (indexType == REmptyType.INSTANCE) {
            return this.myOriginalType.getName();
        }
        return String.format("%s<%s>", this.myOriginalType.getName(), indexType.getName());
    }

    @Nullable
    public String getPresentableName() {
        if (this.myItemTypes.size() > 1 && "Array".equals(this.myOriginalType.getName())) {
            return String.format("[%s]", StringUtil.join(this.myItemTypes, type -> (String)ObjectUtils.coalesce((Object)type.getPresentableName(), (Object)RBundle.message((String)"editor.expressionTypeProvider.untypedType")), (String)", "));
        }
        RType indexType = this.getIndexType();
        if (indexType == REmptyType.INSTANCE) {
            return this.myOriginalType.getPresentableName();
        }
        return String.format("%s<%s>", this.myOriginalType.getPresentableName(), indexType.getPresentableName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RCollectionTypeImpl type = (RCollectionTypeImpl)((Object)o);
        return Objects.equals(this.myItemTypes, type.myItemTypes);
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.myItemTypes.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemTypes";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/collections/RCollectionTypeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/collections/RCollectionTypeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEachType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

