/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.Stack;
import com.intellij.util.graph.Graph;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.TypeInferenceResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.TypeComputer;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.TypeInferenceContextService;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.InstructionGraphUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolNegExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.regexp.RRegexpLiteralImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;

public final class TypeInferenceContext
implements TypeInferenceContextService {
    private static final Logger LOG = Logger.getInstance(TypeInferenceContext.class);
    private static final int MAX_GRAPH_SIZE = 1000;
    private static final String NONAME_STRING = "(noname)";
    public final Cache<ControlFlowHolder, TypeInferenceResult> myControlFlowBasedTypesCache;
    public final ConcurrentMap<RExpression, RType> expressionsTypeCache;
    @NotNull
    private final TypeComputer myDefaultTypeComputer;
    @NotNull
    private final ThreadLocal<TypeComputer> myTypeComputer;
    @NotNull
    private final ThreadLocal<Statistics> myStatistics;

    public static TypeInferenceContext getInstance(@NotNull Project project) {
        TypeInferenceContextService service;
        if (project == null) {
            TypeInferenceContext.$$$reportNull$$$0(0);
        }
        if ((service = TypeInferenceContextService.getInstance((Project)project)) instanceof TypeInferenceContext) {
            TypeInferenceContext typeInferenceContext = (TypeInferenceContext)service;
            return typeInferenceContext;
        }
        throw new RuntimeException("TypeInferenceContextService is not TypeInferenceContext: " + String.valueOf(service));
    }

    public TypeInferenceContext(@NotNull Project project) {
        if (project == null) {
            TypeInferenceContext.$$$reportNull$$$0(1);
        }
        this.myControlFlowBasedTypesCache = Caffeine.newBuilder().maximumSize(10000L).build();
        this.expressionsTypeCache = CollectionFactory.createConcurrentWeakKeySoftValueMap();
        this.myDefaultTypeComputer = e -> this.getExpressionType(e);
        this.myTypeComputer = ThreadLocal.withInitial(() -> this.myDefaultTypeComputer);
        this.myStatistics = new ThreadLocal();
        project.getMessageBus().connect((Disposable)this).subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener(){

            public void beforePsiChanged(boolean isPhysical) {
                TypeInferenceContext.this.clear();
            }
        });
        LowMemoryWatcher.register(() -> this.clear(), (Disposable)this);
    }

    public void clear() {
        this.expressionsTypeCache.clear();
        this.myControlFlowBasedTypesCache.invalidateAll();
    }

    @NotNull
    public TypeInferenceResult getTypeInferenceResult(@NotNull ControlFlowHolder owner) {
        if (owner == null) {
            TypeInferenceContext.$$$reportNull$$$0(2);
        }
        TypeInferenceResult typeInferenceResult = this.getTypeInferenceResult(owner, null);
        if (typeInferenceResult == null) {
            TypeInferenceContext.$$$reportNull$$$0(3);
        }
        return typeInferenceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TypeInferenceResult getTypeInferenceResult(@NotNull ControlFlowHolder owner, @Nullable PsiElement expression) {
        if (owner == null) {
            TypeInferenceContext.$$$reportNull$$$0(4);
        }
        SlowOperations.assertSlowOperationsAreAllowed();
        if (this.myControlFlowBasedTypesCache.getIfPresent((Object)owner) != null) {
            TypeInferenceResult result;
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                ProgressIndicatorUtils.awaitWithCheckCanceled(() -> {
                    TypeInferenceResult result = (TypeInferenceResult)this.myControlFlowBasedTypesCache.getIfPresent((Object)owner);
                    if (result == null || result.isComplete() || expression != null && result.hasType(expression)) {
                        return true;
                    }
                    TimeoutUtil.sleep((long)20L);
                    return false;
                });
            }
            if ((result = (TypeInferenceResult)this.myControlFlowBasedTypesCache.getIfPresent((Object)owner)) != null && (result.isComplete() || expression != null && result.hasType(expression))) {
                TypeInferenceResult typeInferenceResult = result;
                if (typeInferenceResult == null) {
                    TypeInferenceContext.$$$reportNull$$$0(5);
                }
                return typeInferenceResult;
            }
        }
        TypeComputer oldGetType = this.myTypeComputer.get();
        boolean isStatisticsEnabled = Registry.is((String)"ruby.typeInference.verbose", (boolean)false);
        if (isStatisticsEnabled) {
            this.updateStatistics(owner);
        }
        TypeInferenceResult info = null;
        try {
            info = TypeInferenceResult.createTypeInferenceResult(owner);
            this.updateGetType(info::getType, owner);
            if (!DumbService.isDumb((Project)owner.getProject()) && this.myControlFlowBasedTypesCache.getIfPresent((Object)owner) == null) {
                this.myControlFlowBasedTypesCache.put((Object)owner, (Object)info);
            }
            info.performAnalysis();
        }
        finally {
            if (info != null && this.myControlFlowBasedTypesCache.getIfPresent((Object)owner) == info && !info.isComplete()) {
                this.myControlFlowBasedTypesCache.invalidate((Object)owner);
            }
            if (isStatisticsEnabled) {
                this.processStatistic();
            }
            this.myTypeComputer.set(oldGetType);
        }
        TypeInferenceResult typeInferenceResult = info;
        if (typeInferenceResult == null) {
            TypeInferenceContext.$$$reportNull$$$0(6);
        }
        return typeInferenceResult;
    }

    @NotNull
    public RType inferControlFlowBasedReturnType(@NotNull RMethod method) {
        if (method == null) {
            TypeInferenceContext.$$$reportNull$$$0(7);
        }
        RType rType = this.getTypeInferenceResult((ControlFlowHolder)method).getReturnType();
        if (rType == null) {
            TypeInferenceContext.$$$reportNull$$$0(8);
        }
        return rType;
    }

    @NotNull
    public RType getType(@NotNull RExpression expression) {
        if (expression == null) {
            TypeInferenceContext.$$$reportNull$$$0(9);
        }
        if (!expression.isValid()) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                TypeInferenceContext.$$$reportNull$$$0(10);
            }
            return rEmptyType;
        }
        if (expression instanceof RRegexpLiteralImpl) {
            RType rType = RTypeFactory.createTypeClassName("Regexp", (RPsiElement)expression);
            if (rType == null) {
                TypeInferenceContext.$$$reportNull$$$0(11);
            }
            return rType;
        }
        if (expression instanceof RBoolNegExpression) {
            RBoolNegExpression boolNegExpression = (RBoolNegExpression)expression;
            RPsiElement element = boolNegExpression.getElement();
            if (element instanceof RExpression) {
                RType rType = RTypeUtil.notType(boolNegExpression.getProject(), RTypeUtil.getType((PsiElement)element));
                if (rType == null) {
                    TypeInferenceContext.$$$reportNull$$$0(12);
                }
                return rType;
            }
            RType rType = RTypeFactory.createBoolType(boolNegExpression.getProject());
            if (rType == null) {
                TypeInferenceContext.$$$reportNull$$$0(13);
            }
            return rType;
        }
        expression = TypeInferenceContext.getRealExpression(expression);
        Project project = expression.getProject();
        TypeInferenceContext self = TypeInferenceContext.getInstance(project);
        RType existingType = (RType)self.expressionsTypeCache.get(expression);
        if (existingType != null) {
            RType rType = existingType;
            if (rType == null) {
                TypeInferenceContext.$$$reportNull$$$0(14);
            }
            return rType;
        }
        RType type = self.myTypeComputer.get().computeType(expression);
        if (!DumbService.isDumb((Project)project)) {
            self.expressionsTypeCache.put(expression, type);
        }
        RType rType = type;
        if (rType == null) {
            TypeInferenceContext.$$$reportNull$$$0(15);
        }
        return rType;
    }

    private void processStatistic() {
        Statistics statistics = this.myStatistics.get();
        long time = System.nanoTime() - (Long)statistics.getInTime().pop();
        if (time > 5000000000L) {
            LOG.warn("Type inference: " + time / 1000000L + " ms " + String.valueOf(statistics.getAnalysisStack()));
        }
        statistics.getAnalysisStack().pop();
    }

    private void updateStatistics(@NotNull ControlFlowHolder owner) {
        if (owner == null) {
            TypeInferenceContext.$$$reportNull$$$0(16);
        }
        if (this.myStatistics.get() == null) {
            this.myStatistics.set(new Statistics());
        }
        this.myStatistics.get().getInTime().push((Object)System.nanoTime());
        this.myStatistics.get().getAnalysisStack().push((Object)TypeInferenceContext.getControlFlowHolderName(owner));
    }

    public static String getControlFlowHolderName(@NotNull ControlFlowHolder owner) {
        PsiFile ownerContainingFile;
        VirtualFile file;
        if (owner == null) {
            TypeInferenceContext.$$$reportNull$$$0(17);
        }
        VirtualFile virtualFile = file = (ownerContainingFile = owner.getContainingFile()) != null ? ownerContainingFile.getVirtualFile() : null;
        if (ownerContainingFile == null) {
            return NONAME_STRING;
        }
        Document document = PsiDocumentManager.getInstance((Project)owner.getProject()).getDocument(ownerContainingFile);
        if (document != null && file != null) {
            int startOffset = owner.getTextRange().getStartOffset();
            int endOffset = owner.getTextRange().getEndOffset();
            if (0 <= startOffset && startOffset < document.getTextLength() && 0 <= endOffset && endOffset < document.getTextLength()) {
                return String.format("%s %d..%d", file.getPath(), document.getLineNumber(startOffset), document.getLineNumber(endOffset));
            }
        }
        return NONAME_STRING;
    }

    @NotNull
    private RType getExpressionType(@NotNull RExpression expression) {
        ControlFlowHolder holder;
        if (expression == null) {
            TypeInferenceContext.$$$reportNull$$$0(18);
        }
        if ((holder = TypeInferenceContext.getControlFlowHolder((PsiElement)expression)) != null) {
            RType rType = this.getTypeInferenceResult(holder, (PsiElement)expression).getType((RPsiElement)expression);
            if (rType == null) {
                TypeInferenceContext.$$$reportNull$$$0(19);
            }
            return rType;
        }
        REmptyType rEmptyType = REmptyType.INSTANCE;
        if (rEmptyType == null) {
            TypeInferenceContext.$$$reportNull$$$0(20);
        }
        return rEmptyType;
    }

    private void updateGetType(@NotNull TypeComputer typeComputer, @NotNull ControlFlowHolder holder) {
        if (typeComputer == null) {
            TypeInferenceContext.$$$reportNull$$$0(21);
        }
        if (holder == null) {
            TypeInferenceContext.$$$reportNull$$$0(22);
        }
        this.myTypeComputer.set(TypeComputer.createTypeComputerWithContext(holder, this.myTypeComputer.get(), typeComputer));
    }

    @Nullable
    public static ControlFlowHolder getControlFlowHolder(@NotNull PsiElement expression) {
        if (expression == null) {
            TypeInferenceContext.$$$reportNull$$$0(23);
        }
        return (ControlFlowHolder)PsiTreeUtil.getParentOfType((PsiElement)expression, ControlFlowHolder.class);
    }

    public static boolean isTooBigForTypeInference(@NotNull Graph<Instruction> graph) {
        if (graph == null) {
            TypeInferenceContext.$$$reportNull$$$0(24);
        }
        return InstructionGraphUtil.isTooBig(graph) || graph.getNodes().size() > TypeInferenceContext.getMaxTypeInferenceCfgSize();
    }

    public static int getMaxTypeInferenceCfgSize() {
        return Registry.intValue((String)"ruby.typeInference.max.control.flow.size", (int)1000);
    }

    @NotNull
    private static RExpression getRealExpression(@NotNull RExpression expression) {
        RReference reference;
        RCall command;
        if (expression == null) {
            TypeInferenceContext.$$$reportNull$$$0(25);
        }
        if ((command = RCallNavigator.getByCommand((PsiElement)expression)) != null && command.getPsiCommand() == expression) {
            expression = command;
        }
        if ((reference = RReferenceNavigator.getReferenceByRightPart((PsiElement)expression)) != null) {
            RReference rReference = reference;
            if (rReference == null) {
                TypeInferenceContext.$$$reportNull$$$0(26);
            }
            return rReference;
        }
        RExpression rExpression = expression;
        if (rExpression == null) {
            TypeInferenceContext.$$$reportNull$$$0(27);
        }
        return rExpression;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 8, 10, 11, 12, 13, 14, 15, 19, 20, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/TypeInferenceContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: 
            case 18: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeComputer";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/TypeInferenceContext";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInferenceResult";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "inferControlFlowBasedReturnType";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypeInferenceResult";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 26: 
            case 27: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "inferControlFlowBasedReturnType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateStatistics";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowHolderName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateGetType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowHolder";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isTooBigForTypeInference";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getRealExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 8, 10, 11, 12, 13, 14, 15, 19, 20, 26, 27 -> new IllegalStateException(string);
        };
    }

    private static class Statistics {
        private final Stack<Long> myInTime = new Stack();
        private final Stack<String> myAnalysisStack = new Stack();

        private Statistics() {
        }

        @NotNull
        public Stack<Long> getInTime() {
            Stack<Long> stack = this.myInTime;
            if (stack == null) {
                Statistics.$$$reportNull$$$0(0);
            }
            return stack;
        }

        @NotNull
        public Stack<String> getAnalysisStack() {
            Stack<String> stack = this.myAnalysisStack;
            if (stack == null) {
                Statistics.$$$reportNull$$$0(1);
            }
            return stack;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/TypeInferenceContext$Statistics";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInTime";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnalysisStack";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

