/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.MethodAnnotationData;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.CoreFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.CallableSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.MultiSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.TypedSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RDuckType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RIntersectionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSymbolType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeSubTypeContributor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeWithNilability;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RUnionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyTypeProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections.RCollectionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.computable.RPsiBasedTypeComputable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.computable.RSymbolBasedTypeComputable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RDelegatedType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RDuckTypeImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RDynamicType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RFrozenType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RIntersectionTypeImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RModuleType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RUnionTypeImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.primitive.RBooleanType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.RControlFlowUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.RAssocKeyValueReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.fields.RInstanceVariableImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RLambdaCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RInstanceVariableStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class RTypeUtil {
    private static final Logger LOG = Logger.getInstance(RTypeUtil.class);

    private RTypeUtil() {
    }

    @NotNull
    public static RType getTypeForReceiver(@NotNull RPossibleCall call) {
        RReference reference;
        PsiElement psiElement;
        RPossibleCall expression;
        RPossibleCall realCall;
        if (call == null) {
            RTypeUtil.$$$reportNull$$$0(0);
        }
        if (call instanceof RBlockCall) {
            RBlockCall blockCall = (RBlockCall)call;
            v0 = blockCall.getCall();
        } else {
            v0 = realCall = call;
        }
        if (realCall instanceof RLambdaCall) {
            RLambdaCall lambdaCall = (RLambdaCall)realCall;
            RType rType = (RType)ObjectUtils.coalesce((Object)((RType)ObjectUtils.doIfNotNull((Object)lambdaCall.getReceiver(), RTypeUtil::getType)), (Object)REmptyType.INSTANCE);
            if (rType == null) {
                RTypeUtil.$$$reportNull$$$0(1);
            }
            return rType;
        }
        if (call instanceof RAssignmentExpression) {
            RAssignmentExpression assignment = (RAssignmentExpression)call;
            expression = (RExpression)ObjectUtils.coalesce((Object)((RExpression)ObjectUtils.tryCast((Object)assignment.getObject(), RExpression.class)), (Object)call);
        } else if (!(call instanceof RArrayIndexing) && (psiElement = call.getPsiCommand()) instanceof RExpression) {
            RExpression command = (RExpression)psiElement;
            expression = command;
        } else {
            expression = call;
        }
        if (expression instanceof RArrayIndexing) {
            RArrayIndexing indexing = (RArrayIndexing)expression;
            return RTypeUtil.getType((PsiElement)indexing.getReceiver());
        }
        RReference rReference = reference = expression instanceof RReference ? (RReference)expression : RReferenceNavigator.getReferenceByRightPart((PsiElement)expression);
        if (reference != null && (psiElement = reference.getReceiver()) instanceof RExpression) {
            RExpression receiver = (RExpression)psiElement;
            return RTypeUtil.getType((PsiElement)receiver);
        }
        return RTypeUtil.getTypeForSelf((PsiElement)call);
    }

    @NotNull
    public static RType getTypeForSelf(@NotNull PsiElement element) {
        if (element == null) {
            RTypeUtil.$$$reportNull$$$0(2);
        }
        RBlockCall call = (RBlockCall)ObjectUtils.doIfCast((Object)ScopeUtilCore.findScopeHolder((PsiElement)element), RCodeBlock.class, RBlockCallNavigator::getByBlock);
        while (call != null) {
            RType typeFromProviders = (RType)ObjectUtils.doIfNotNull((Object)call, RubyTypeProvider::getBlockSelfTypeFromProviders);
            if (typeFromProviders != null) {
                RType rType = typeFromProviders;
                if (rType == null) {
                    RTypeUtil.$$$reportNull$$$0(3);
                }
                return rType;
            }
            call = (RBlockCall)ObjectUtils.doIfCast((Object)ScopeUtilCore.findScopeHolder((PsiElement)call), RCodeBlock.class, RBlockCallNavigator::getByBlock);
        }
        Symbol scopeContext = SymbolUtil.getScopeContextWithCaching(element);
        Symbol selfContext = SymbolUtil.getSymbolRepresentingContext(scopeContext, ContextImpl.getContext(element));
        Object object = selfContext != null ? RTypeFactory.createTypeBySymbol(selfContext) : REmptyType.INSTANCE;
        if (object == null) {
            RTypeUtil.$$$reportNull$$$0(4);
        }
        return object;
    }

    @NotNull
    public static RType getTypeForSelf(@NotNull PsiElement invocationPoint, @Nullable Symbol symbol) {
        if (invocationPoint == null) {
            RTypeUtil.$$$reportNull$$$0(5);
        }
        if (symbol == null) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RTypeUtil.$$$reportNull$$$0(6);
            }
            return rEmptyType;
        }
        if (!(invocationPoint instanceof RPsiElement)) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RTypeUtil.$$$reportNull$$$0(7);
            }
            return rEmptyType;
        }
        RBlockCall call = (RBlockCall)ObjectUtils.doIfCast((Object)ScopeUtilCore.findScopeHolder((PsiElement)invocationPoint), RCodeBlock.class, RBlockCallNavigator::getByBlock);
        RType typeFromProviders = (RType)ObjectUtils.doIfNotNull((Object)call, RubyTypeProvider::getBlockSelfTypeFromProviders);
        if (typeFromProviders != null) {
            RType rType = typeFromProviders;
            if (rType == null) {
                RTypeUtil.$$$reportNull$$$0(8);
            }
            return rType;
        }
        ContextImpl symbolContext = invocationPoint instanceof RContainer ? (invocationPoint instanceof RFile ? ContextImpl.INSTANCE : ContextImpl.getContextByContainer((RContainer)invocationPoint)) : (((RPsiElement)invocationPoint).getParentContainer() instanceof RFile ? ContextImpl.INSTANCE : ContextImpl.getContext(invocationPoint));
        symbol = SymbolUtil.getSymbolRepresentingContext(symbol, symbolContext);
        RType rType = RTypeFactory.createTypeBySymbol(symbol);
        if (rType == null) {
            RTypeUtil.$$$reportNull$$$0(9);
        }
        return rType;
    }

    public static RType getTypeByClass(@NotNull RClass aClass) {
        if (aClass == null) {
            RTypeUtil.$$$reportNull$$$0(10);
        }
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)aClass);
        return RTypeFactory.createTypeBySymbol(symbol);
    }

    @NotNull
    public static RType union(@NotNull Collection<? extends RType> types) {
        List<RType> flattenedTypes;
        if (types == null) {
            RTypeUtil.$$$reportNull$$$0(11);
        }
        if ((flattenedTypes = types.stream().flatMap(type -> type instanceof RUnionType ? ((RUnionType)type).getTypes().stream() : Stream.of(type)).filter(type -> type != REmptyType.INSTANCE).distinct().toList()).size() <= 1) {
            RType rType = (RType)ContainerUtil.getFirstItem(flattenedTypes, (Object)REmptyType.INSTANCE);
            if (rType == null) {
                RTypeUtil.$$$reportNull$$$0(12);
            }
            return rType;
        }
        RType intersectionType = (RType)ContainerUtil.find(flattenedTypes, type -> {
            if (!(type instanceof RIntersectionType)) return false;
            if (!((RIntersectionType)type).getTypes().containsAll(ContainerUtil.filter((Collection)flattenedTypes, (Condition)Conditions.not(arg_0 -> ((RType)type).equals(arg_0))))) return false;
            return true;
        });
        if (intersectionType != null) {
            RType rType = intersectionType;
            if (rType == null) {
                RTypeUtil.$$$reportNull$$$0(13);
            }
            return rType;
        }
        boolean isIntersectionOfDuckTypes = ContainerUtil.and(flattenedTypes, type -> type instanceof RIntersectionType && ContainerUtil.exists((Iterable)((RIntersectionType)type).getTypes(), it -> it instanceof RDuckType && !it.isTyped()));
        if (isIntersectionOfDuckTypes) {
            boolean hasCommonType;
            boolean bl = hasCommonType = !((Collection)flattenedTypes.stream().map(type -> ((RIntersectionType)type).getTypes()).reduce(ContainerUtil::intersection).orElse(Collections.emptyList())).isEmpty();
            if (hasCommonType) {
                RType rType = RTypeUtil.intersect(types);
                if (rType == null) {
                    RTypeUtil.$$$reportNull$$$0(14);
                }
                return rType;
            }
        }
        Map<Boolean, List<RType>> partitionedTypes = flattenedTypes.stream().collect(Collectors.partitioningBy(type -> type instanceof RDuckType && !type.isTyped()));
        ArrayList<RType> regularTypes = new ArrayList<RType>(partitionedTypes.getOrDefault(false, Collections.emptyList()));
        List duckTypes = partitionedTypes.getOrDefault(true, Collections.emptyList());
        regularTypes.removeIf(candidate -> {
            if (!(candidate instanceof RFrozenType)) {
                return false;
            }
            RFrozenType frozenType = (RFrozenType)((Object)candidate);
            if (ContainerUtil.exists((Iterable)regularTypes, arg_0 -> ((RType)frozenType.getOriginalType()).equals(arg_0))) {
                return true;
            }
            return !frozenType.isChilled() && ContainerUtil.exists((Iterable)regularTypes, it -> {
                RFrozenType otherFrozenType;
                return it instanceof RFrozenType && (otherFrozenType = (RFrozenType)((Object)((Object)it))).isChilled();
            });
        });
        ArrayList<RType> uniqueTypes = new ArrayList<RType>();
        if (!duckTypes.isEmpty()) {
            uniqueTypes.add((RType)duckTypes.stream().reduce(REmptyType.INSTANCE, (type1, type2) -> new RDuckTypeImpl(RTypeUtilCore.union((Collection)type1.getMembers(Symbol.Filter.ACCEPT_ALL, null), (Collection)type2.getMembers(Symbol.Filter.ACCEPT_ALL, null)))));
        }
        uniqueTypes.addAll(ContainerUtil.filter(regularTypes, it -> !ContainerUtil.or((Iterable)regularTypes, other -> it != other && RTypeUtil.isSubtype(it, other) == ThreeState.YES)));
        if (uniqueTypes.size() <= 1) {
            RType rType = (RType)ContainerUtil.getOnlyItem(uniqueTypes, (Object)REmptyType.INSTANCE);
            if (rType == null) {
                RTypeUtil.$$$reportNull$$$0(15);
            }
            return rType;
        }
        RType rType = RUnionTypeImpl.create(uniqueTypes);
        if (rType == null) {
            RTypeUtil.$$$reportNull$$$0(16);
        }
        return rType;
    }

    @NotNull
    public static RType union(@NotNull RType type1, @NotNull RType type2) {
        if (type1 == null) {
            RTypeUtil.$$$reportNull$$$0(17);
        }
        if (type2 == null) {
            RTypeUtil.$$$reportNull$$$0(18);
        }
        return RTypeUtil.union(Arrays.asList(type1, type2));
    }

    public static RType intersect(@NotNull Collection<? extends RType> types) {
        if (types == null) {
            RTypeUtil.$$$reportNull$$$0(19);
        }
        List<RType> flattenedTypes = types.stream().flatMap(type -> type instanceof RIntersectionType ? ((RIntersectionType)type).getTypes().stream() : Stream.of(type)).filter(type -> type != REmptyType.INSTANCE).distinct().toList();
        Map<Boolean, List<RType>> partitionedTypes = flattenedTypes.stream().collect(Collectors.partitioningBy(type -> type instanceof RDuckType && !type.isTyped()));
        ArrayList<RType> regularTypes = new ArrayList<RType>(partitionedTypes.getOrDefault(false, Collections.emptyList()));
        List duckTypes = partitionedTypes.getOrDefault(true, Collections.emptyList());
        regularTypes.removeIf(candidate -> {
            if (!(candidate instanceof RFrozenType)) {
                return false;
            }
            RFrozenType frozenType = (RFrozenType)((Object)candidate);
            if (ContainerUtil.exists((Iterable)regularTypes, arg_0 -> ((RType)frozenType.getOriginalType()).equals(arg_0))) {
                return true;
            }
            return !frozenType.isChilled() && ContainerUtil.exists((Iterable)regularTypes, it -> {
                RFrozenType otherFrozenType;
                return it instanceof RFrozenType && (otherFrozenType = (RFrozenType)((Object)((Object)it))).isChilled();
            });
        });
        ArrayList<RType> uniqueTypes = new ArrayList<RType>();
        if (!duckTypes.isEmpty()) {
            uniqueTypes.add((RType)duckTypes.stream().reduce(REmptyType.INSTANCE, (type1, type2) -> new RDuckTypeImpl(RTypeUtilCore.union((Collection)type1.getMembers(Symbol.Filter.ACCEPT_ALL, null), (Collection)type2.getMembers(Symbol.Filter.ACCEPT_ALL, null)))));
        }
        uniqueTypes.addAll(ContainerUtil.filter(regularTypes, it -> !ContainerUtil.or((Iterable)regularTypes, other -> it != other && RTypeUtil.isSubtype(other, it) == ThreeState.YES)));
        if (uniqueTypes.size() <= 1) {
            return (RType)ContainerUtil.getOnlyItem(uniqueTypes, (Object)REmptyType.INSTANCE);
        }
        return RIntersectionTypeImpl.create(uniqueTypes);
    }

    public static RType intersect(@NotNull RType type1, @NotNull RType type2) {
        if (type1 == null) {
            RTypeUtil.$$$reportNull$$$0(20);
        }
        if (type2 == null) {
            RTypeUtil.$$$reportNull$$$0(21);
        }
        return RTypeUtil.intersect(Arrays.asList(type1, type2));
    }

    @NotNull
    public static RType notType(@NotNull Project project, @NotNull RType type) {
        if (project == null) {
            RTypeUtil.$$$reportNull$$$0(22);
        }
        if (type == null) {
            RTypeUtil.$$$reportNull$$$0(23);
        }
        if (type == REmptyType.INSTANCE || !type.isTyped()) {
            RType rType = RTypeFactory.createBoolType(project);
            if (rType == null) {
                RTypeUtil.$$$reportNull$$$0(24);
            }
            return rType;
        }
        RType falseType = RTypeFactory.createFalseType(project);
        REmptyType nilType = REmptyType.INSTANCE;
        if (type.equals((Object)falseType) || type.equals((Object)nilType) || type.equals((Object)RTypeUtil.union(falseType, (RType)nilType))) {
            RType rType = RTypeFactory.createTrueType(project);
            if (rType == null) {
                RTypeUtil.$$$reportNull$$$0(25);
            }
            return rType;
        }
        if (RTypeUtil.isSubtype(falseType, type) == ThreeState.YES || RTypeUtil.isSubtype((RType)nilType, type) == ThreeState.YES) {
            RType rType = RTypeFactory.createBoolType(project);
            if (rType == null) {
                RTypeUtil.$$$reportNull$$$0(26);
            }
            return rType;
        }
        RType rType = falseType;
        if (rType == null) {
            RTypeUtil.$$$reportNull$$$0(27);
        }
        return rType;
    }

    public static boolean isBoolType(@NotNull RType type) {
        if (type == null) {
            RTypeUtil.$$$reportNull$$$0(28);
        }
        if (type instanceof RUnionType) {
            return ContainerUtil.and((Iterable)((RUnionType)type).getTypes(), RTypeUtil::isBoolType);
        }
        return type instanceof RBooleanType;
    }

    public static boolean isStringType(@NotNull RType type) {
        Symbol symbol;
        if (type == null) {
            RTypeUtil.$$$reportNull$$$0(29);
        }
        return (symbol = RTypeUtilCore.getBirthTypeSymbol((RType)type)) != null && symbol.getFQNWithNesting().equals((Object)CoreFqns.STRING);
    }

    @NotNull
    public static Access getBirthTypeAccess(@Nullable RType type) {
        Access access = type instanceof RModuleType ? Access.CLASS : Access.INSTANCE;
        if (access == null) {
            RTypeUtil.$$$reportNull$$$0(30);
        }
        return access;
    }

    @NotNull
    public static RSymbolBasedTypeComputable createTypeByNameComputable(final String typeBirthClassQualifiedName) {
        return new RSymbolBasedTypeComputable(){

            @Override
            @NotNull
            public RType getType(@NotNull Symbol symbol) {
                RType primitiveType;
                RType type;
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((type = RTypeFactory.createTypeByFQN(symbol.getProject(), typeBirthClassQualifiedName)) != REmptyType.INSTANCE) {
                    RType rType = type;
                    if (rType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return rType;
                }
                if (typeBirthClassQualifiedName.indexOf(58) <= -1 && (primitiveType = RTypeFactory.createTypeForPrimitiveTypes(symbol.getProject(), typeBirthClassQualifiedName, null)) != null) {
                    RType rType = primitiveType;
                    if (rType == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return rType;
                }
                REmptyType rEmptyType = REmptyType.INSTANCE;
                if (rEmptyType == null) {
                    1.$$$reportNull$$$0(3);
                }
                return rEmptyType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "symbol";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/RTypeUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/RTypeUtil$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getType";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    public static RDynamicType createDynamicType(Symbol symbol) {
        RDynamicType type = new RDynamicType(symbol);
        type.addDynamicMembers((Condition<String>)Conditions.alwaysTrue());
        return type;
    }

    public static RSymbolBasedTypeComputable createEmptyTypeComputable() {
        return new RSymbolBasedTypeComputable(){

            @Override
            public RType getType(@NotNull Symbol symbol) {
                if (symbol == null) {
                    2.$$$reportNull$$$0(0);
                }
                return REmptyType.INSTANCE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "org/jetbrains/plugins/ruby/ruby/codeInsight/types/RTypeUtil$2", "getType"));
            }
        };
    }

    public static RSymbolBasedTypeComputable createDynamicTypeComputable(final @NotNull RSymbolBasedTypeComputable membersReturnTypeComputable) {
        if (membersReturnTypeComputable == null) {
            RTypeUtil.$$$reportNull$$$0(31);
        }
        return new RSymbolBasedTypeComputable(){

            @Override
            @NotNull
            public RType getType(@NotNull Symbol symbol) {
                if (symbol == null) {
                    3.$$$reportNull$$$0(0);
                }
                RDynamicType dynamicType = RTypeUtil.createDynamicType(symbol);
                dynamicType.setMembersReturnTypeComputable(membersReturnTypeComputable);
                RDynamicType rDynamicType = dynamicType;
                if (rDynamicType == null) {
                    3.$$$reportNull$$$0(1);
                }
                return rDynamicType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "symbol";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/RTypeUtil$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/RTypeUtil$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getType";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public static ThreeState isSubtype(@Nullable RType child, @Nullable RType parent) {
        RType unfrozenParent;
        RType unfrozenChild;
        if (RTypeUtilCore.isNullOrEmpty((RType)child) || RTypeUtilCore.isNullOrEmpty((RType)parent)) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                RTypeUtil.$$$reportNull$$$0(32);
            }
            return threeState;
        }
        if (child instanceof RFrozenType) {
            RFrozenType frozenType = (RFrozenType)child;
            v1 = frozenType.getOriginalType();
        } else {
            v1 = unfrozenChild = child;
        }
        if (parent instanceof RFrozenType) {
            RFrozenType frozenType = (RFrozenType)parent;
            v2 = frozenType.getOriginalType();
        } else {
            v2 = unfrozenParent = parent;
        }
        if (unfrozenChild.equals((Object)unfrozenParent)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                RTypeUtil.$$$reportNull$$$0(33);
            }
            return threeState;
        }
        for (RTypeSubTypeContributor contributor : RTypeSubTypeContributor.all()) {
            ThreeState subtype = contributor.isSubTypeOf(unfrozenChild, unfrozenParent);
            if (subtype == ThreeState.UNSURE) continue;
            ThreeState threeState = subtype;
            if (threeState == null) {
                RTypeUtil.$$$reportNull$$$0(34);
            }
            return threeState;
        }
        if (child instanceof RDelegatedType) {
            return RTypeUtil.isSubtype(((RDelegatedType)child).getOriginalType(), parent);
        }
        if (parent instanceof RDelegatedType) {
            return RTypeUtil.isSubtype(child, ((RDelegatedType)parent).getOriginalType());
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            RTypeUtil.$$$reportNull$$$0(35);
        }
        return threeState;
    }

    @Nullable
    public static RType getCoveringExpressionType(@Nullable PsiElement element) {
        RType type;
        RExpression originalExpression = RubyPsiUtil.getCoveringExpression(element);
        if (originalExpression != null && (type = originalExpression.getType()) != REmptyType.INSTANCE) {
            return type;
        }
        return null;
    }

    @NotNull
    public static RType getType(@Nullable PsiElement element) {
        if (element instanceof RExpression) {
            RType rType = ((RExpression)element).getType();
            if (rType == null) {
                RTypeUtil.$$$reportNull$$$0(36);
            }
            return rType;
        }
        if (element instanceof RAssoc) {
            RType keyType;
            RAssoc assoc = (RAssoc)element;
            Project project = element.getProject();
            RType rType = keyType = assoc.getKey() instanceof RAssocKey ? RTypeFactory.createSymbolType(project) : RTypeUtil.getType((PsiElement)assoc.getKey());
            Object valueType = assoc.getValue() != null ? RTypeUtil.getType((PsiElement)assoc.getValue()) : (assoc.getKey() != null ? Arrays.stream(assoc.getKey().getReferences()).mapMulti(StreamUtil.select(RAssocKeyValueReference.class, (Class[])new Class[0])).flatMap(it -> Arrays.stream(it.multiResolve(false))).map(ResolveResult::getElement).map(RTypeUtil::getType).findFirst().orElse((RType)REmptyType.INSTANCE) : REmptyType.INSTANCE);
            RType rType2 = RTypeFactory.createHashType(project, keyType, valueType);
            if (rType2 == null) {
                RTypeUtil.$$$reportNull$$$0(37);
            }
            return rType2;
        }
        REmptyType rEmptyType = REmptyType.INSTANCE;
        if (rEmptyType == null) {
            RTypeUtil.$$$reportNull$$$0(38);
        }
        return rEmptyType;
    }

    @Nullable
    public static RType getTypeFromTypedSymbol(@Nullable PsiElement contextElement, @NotNull Symbol symbol) {
        RType type;
        if (symbol == null) {
            RTypeUtil.$$$reportNull$$$0(39);
        }
        if (symbol instanceof MultiSymbol) {
            return RTypeUtil.union(ContainerUtil.mapNotNull((Collection)((MultiSymbol)symbol).getSymbols(), s -> RTypeUtil.getTypeFromTypedSymbol(contextElement, s)));
        }
        if (symbol instanceof CallableSymbol && contextElement instanceof RCall && (type = ((CallableSymbol)symbol).getCallType((RCall)contextElement)) != null) {
            return type;
        }
        if (symbol instanceof TypedSymbol) {
            ContextImpl context = SymbolUtil.isClassOrModuleSymbol(symbol.getType()) ? ContextImpl.CLASS : ContextImpl.INSTANCE;
            return ((TypedSymbol)symbol).getType((Context)context);
        }
        return null;
    }

    @NotNull
    public static ThreeState getNilabilityFromSymbol(@NotNull Symbol symbol) {
        ThreeState threeState;
        if (symbol == null) {
            RTypeUtil.$$$reportNull$$$0(40);
        }
        if (symbol instanceof TypedSymbol) {
            TypedSymbol typedSymbol = (TypedSymbol)symbol;
            threeState = typedSymbol.getNilability();
        } else {
            threeState = ThreeState.UNSURE;
        }
        if (threeState == null) {
            RTypeUtil.$$$reportNull$$$0(41);
        }
        return threeState;
    }

    @Nullable
    public static Symbol extractSymbolOrMultiSymbol(@NotNull RType type) {
        if (type == null) {
            RTypeUtil.$$$reportNull$$$0(42);
        }
        if (type instanceof RSymbolType) {
            RSymbolType symbolType = (RSymbolType)type;
            return symbolType.getSymbol();
        }
        if (type instanceof RDelegatedType) {
            RDelegatedType delegate = (RDelegatedType)type;
            return RTypeUtil.extractSymbolOrMultiSymbol(delegate.getOriginalType());
        }
        if (type instanceof RUnionType) {
            RUnionType union = (RUnionType)type;
            return MultiSymbol.of((List)ContainerUtil.mapNotNull((Collection)union.getTypes(), RTypeUtil::extractSymbolOrMultiSymbol));
        }
        if (type instanceof RIntersectionType) {
            RIntersectionType intersection = (RIntersectionType)type;
            return MultiSymbol.of((List)ContainerUtil.mapNotNull((Collection)intersection.getTypes(), RTypeUtil::extractSymbolOrMultiSymbol));
        }
        return null;
    }

    @Nullable
    public static RSymbolType extractSymbolType(RType operandType) {
        if (operandType instanceof RSymbolType) {
            return (RSymbolType)operandType;
        }
        if (operandType instanceof RDelegatedType) {
            return RTypeUtil.extractSymbolType(((RDelegatedType)operandType).getOriginalType());
        }
        if (operandType instanceof RUnionType) {
            return ((RUnionType)operandType).getTypes().stream().map(RTypeUtil::extractSymbolType).filter(Objects::nonNull).findFirst().orElse(null);
        }
        if (operandType instanceof RIntersectionType) {
            return ((RIntersectionType)operandType).getTypes().stream().map(RTypeUtil::extractSymbolType).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    @NotNull
    public static RPsiBasedTypeComputable createReceiverTypeComputable() {
        return new RPsiBasedTypeComputable(){

            public RType getType(@NotNull Symbol callSymbol, @NotNull RExpression expression) {
                if (callSymbol == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (expression == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (!(expression instanceof RReference)) {
                    LOG.error("Reference expected for symbol [" + String.valueOf(callSymbol.getFQNWithNesting()) + "] and expression: " + expression.getText());
                }
                return RTypeUtil.createTypeSameAsReceiver((RReference)expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callSymbol";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/RTypeUtil$4";
                objectArray[2] = "getType";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static RType createTypeSameAsReceiver(@NotNull RReference reference) {
        RExpression expression;
        RPsiElement receiver;
        if (reference == null) {
            RTypeUtil.$$$reportNull$$$0(43);
        }
        if ((receiver = reference.getReceiver()) != null && (expression = RubyPsiUtil.getCoveringExpression((PsiElement)receiver)) != null) {
            return expression.getType();
        }
        return REmptyType.INSTANCE;
    }

    @NotNull
    public static ThreeState isMorePrecise(@Nullable RType origin, @Nullable RType newType) {
        if (origin instanceof RCollectionType && newType instanceof RCollectionType) {
            ThreeState threeState = ThreeState.fromBoolean((RTypeUtilCore.isNullOrEmpty((RType)((RType)((RCollectionType)origin).getEachType())) && RTypeUtilCore.isNotEmpty((RType)((RType)((RCollectionType)newType).getEachType())) ? 1 : 0) != 0);
            if (threeState == null) {
                RTypeUtil.$$$reportNull$$$0(44);
            }
            return threeState;
        }
        if (origin instanceof RModuleType && newType instanceof RModuleType) {
            ThreeState threeState = ThreeState.fromBoolean((((RModuleType)origin).isWithoutGenericType() && !((RModuleType)newType).isWithoutGenericType() ? 1 : 0) != 0);
            if (threeState == null) {
                RTypeUtil.$$$reportNull$$$0(45);
            }
            return threeState;
        }
        if (origin instanceof RFrozenType && !(newType instanceof RFrozenType)) {
            return RTypeUtil.isMorePrecise(RFrozenType.clearFrozenStatus(origin), newType);
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            RTypeUtil.$$$reportNull$$$0(46);
        }
        return threeState;
    }

    @NotNull
    public static RTypeWithNilability inferMethodTypeAndNilabilityByMethodBody(@NotNull RMethod method) {
        if (method == null) {
            RTypeUtil.$$$reportNull$$$0(47);
        }
        RTypeWithNilability rTypeWithNilability = RControlFlowUtil.findExitInstructions((ControlFlow)method.getControlFlow()).stream().map(Instruction::getElement).filter(RExpression.class::isInstance).map(it -> RTypeWithNilability.fromPsiElement(it)).reduce((first, second) -> first.union((RTypeWithNilability)second)).orElse(RTypeWithNilability.EMPTY);
        if (rTypeWithNilability == null) {
            RTypeUtil.$$$reportNull$$$0(48);
        }
        return rTypeWithNilability;
    }

    @NotNull
    public static RTypeWithNilability inferMethodTypeAndNilabilityByDoc(@Nullable RMethod method, @NotNull ThreeState defaultCanBeNil) {
        if (defaultCanBeNil == null) {
            RTypeUtil.$$$reportNull$$$0(49);
        }
        Symbol methodSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)method);
        RTypeWithNilability rTypeWithNilability = Optional.ofNullable(methodSymbol).filter(RMethodSymbol.class::isInstance).map(it -> ((RMethodSymbol)it).getAnnotationData()).map(MethodAnnotationData::getReturnType).map(it -> RTypeWithNilability.fromSerializableType(it, method.getProject(), defaultCanBeNil, (PsiElement)method)).orElse(RTypeWithNilability.EMPTY);
        if (rTypeWithNilability == null) {
            RTypeUtil.$$$reportNull$$$0(50);
        }
        return rTypeWithNilability;
    }

    @NotNull
    public static List<RType> flattenUnionType(@NotNull RType type) {
        if (type == null) {
            RTypeUtil.$$$reportNull$$$0(51);
        }
        List list = type instanceof RUnionType ? ContainerUtil.flatMap((Iterable)((RUnionType)type).getTypes(), RTypeUtil::flattenUnionType) : List.of(type);
        if (list == null) {
            RTypeUtil.$$$reportNull$$$0(52);
        }
        return list;
    }

    @NotNull
    public static List<RType> flattenUnionAndIntersectionType(@NotNull RType type) {
        if (type == null) {
            RTypeUtil.$$$reportNull$$$0(53);
        }
        if (type instanceof RUnionType) {
            List list = ContainerUtil.flatMap((Iterable)((RUnionType)type).getTypes(), RTypeUtil::flattenUnionAndIntersectionType);
            if (list == null) {
                RTypeUtil.$$$reportNull$$$0(54);
            }
            return list;
        }
        if (type instanceof RIntersectionType) {
            List list = ContainerUtil.flatMap((Iterable)((RIntersectionType)type).getTypes(), RTypeUtil::flattenUnionAndIntersectionType);
            if (list == null) {
                RTypeUtil.$$$reportNull$$$0(55);
            }
            return list;
        }
        return new SmartList((Object)type);
    }

    @NotNull
    public static SerializableType getInstanceVariableYardType(@NotNull RInstanceVariable instanceVariable) {
        RInstanceVariableStub stub;
        if (instanceVariable == null) {
            RTypeUtil.$$$reportNull$$$0(56);
        }
        if ((stub = (RInstanceVariableStub)((RInstanceVariableImpl)instanceVariable).getGreenStub()) != null) {
            SerializableType serializableType = stub.getYardType();
            if (serializableType == null) {
                RTypeUtil.$$$reportNull$$$0(57);
            }
            return serializableType;
        }
        SerializableType type = RubyCommentsUtil.getTypeFromTypeComment(instanceVariable);
        if (type == null) {
            type = SerializableTypeUtil.EMPTY;
        }
        SerializableType serializableType = type;
        if (serializableType == null) {
            RTypeUtil.$$$reportNull$$$0(58);
        }
        return serializableType;
    }

    @NotNull
    public static RType addMember(@NotNull RType type, @NotNull Symbol member) {
        if (type == null) {
            RTypeUtil.$$$reportNull$$$0(59);
        }
        if (member == null) {
            RTypeUtil.$$$reportNull$$$0(60);
        }
        if (type instanceof RDuckTypeImpl) {
            RDuckTypeImpl duckType = (RDuckTypeImpl)type;
            RType rType = duckType.addMember(member);
            if (rType == null) {
                RTypeUtil.$$$reportNull$$$0(61);
            }
            return rType;
        }
        if (type instanceof RDelegatedType) {
            RDelegatedType delegatedType = (RDelegatedType)type;
            if (!(type instanceof RModuleType)) {
                delegatedType.setOriginalType(RTypeUtil.addMember(delegatedType.getOriginalType(), member));
                RDelegatedType rDelegatedType = delegatedType;
                if (rDelegatedType == null) {
                    RTypeUtil.$$$reportNull$$$0(62);
                }
                return rDelegatedType;
            }
        }
        RType rType = RTypeUtil.intersect(type, new RDuckTypeImpl().addMember(member));
        if (rType == null) {
            RTypeUtil.$$$reportNull$$$0(63);
        }
        return rType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 6, 7, 8, 9, 12, 13, 14, 15, 16, 24, 25, 26, 27, 30, 32, 33, 34, 35, 36, 37, 38, 41, 44, 45, 46, 48, 50, 52, 54, 55, 57, 58, 61, 62, 63 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/RTypeUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocationPoint";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: 
            case 28: 
            case 29: 
            case 42: 
            case 51: 
            case 53: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersReturnTypeComputable";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCanBeNil";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceVariable";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/RTypeUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeForReceiver";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeForSelf";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "notType";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getBirthTypeAccess";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "isSubtype";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getNilabilityFromSymbol";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "isMorePrecise";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "inferMethodTypeAndNilabilityByMethodBody";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "inferMethodTypeAndNilabilityByDoc";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenUnionType";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenUnionAndIntersectionType";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceVariableYardType";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "addMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForReceiver";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 63: {
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForSelf";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByClass";
                break;
            }
            case 11: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "notType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isBoolType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isStringType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createDynamicTypeComputable";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromTypedSymbol";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getNilabilityFromSymbol";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "extractSymbolOrMultiSymbol";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createTypeSameAsReceiver";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "inferMethodTypeAndNilabilityByMethodBody";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "inferMethodTypeAndNilabilityByDoc";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "flattenUnionType";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "flattenUnionAndIntersectionType";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceVariableYardType";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "addMember";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 6, 7, 8, 9, 12, 13, 14, 15, 16, 24, 25, 26, 27, 30, 32, 33, 34, 35, 36, 37, 38, 41, 44, 45, 46, 48, 50, 52, 54, 55, 57, 58, 61, 62, 63 -> new IllegalStateException(string);
        };
    }
}

