/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.TypedSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolContainerUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections.RCollectionTypeImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections.RHashType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RClassType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RFrozenType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RModuleType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RSymbolTypeImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.primitive.RBooleanType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.primitive.RFloatType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.primitive.RIntegerType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class RTypeFactory {
    private static final Logger LOG = Logger.getInstance(RTypeFactory.class);
    private static final String FROZEN_STRING_LITERAL_PRAGMA = "frozen_string_literal";

    private RTypeFactory() {
    }

    public static RType createTypeClassName(@NotNull String className, @NotNull RPsiElement usage) {
        if (className == null) {
            RTypeFactory.$$$reportNull$$$0(0);
        }
        if (usage == null) {
            RTypeFactory.$$$reportNull$$$0(1);
        }
        return RTypeFactory.createTypeBySymbol(SymbolUtil.findConstantByFQN(usage.getProject(), Type.CLASS, className, null), usage);
    }

    public static RType createTypeClassName(Project project, @NotNull String className, @NotNull Visibility visibility) {
        if (className == null) {
            RTypeFactory.$$$reportNull$$$0(2);
        }
        if (visibility == null) {
            RTypeFactory.$$$reportNull$$$0(3);
        }
        Symbol symbol = SymbolUtil.findConstantByFQN(project, Type.CLASS, className, null);
        return RTypeFactory.createTypeBySymbol(symbol);
    }

    public static RType createTypeBySymbol(@Nullable Symbol symbol, @NotNull RPsiElement element) {
        Symbol containerSymbol;
        if (element == null) {
            RTypeFactory.$$$reportNull$$$0(4);
        }
        if (symbol == null) {
            return REmptyType.INSTANCE;
        }
        RContainer container = element.getParentContainer();
        if (container instanceof RMethod && !(container instanceof RSingletonMethod) && (container = container.getParentContainer()) instanceof RClass && (containerSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)container)) != null && SymbolHierarchy.isInheritor(containerSymbol, symbol.getFQNWithNesting(), null)) {
            return RTypeFactory.createTypeBySymbol(symbol);
        }
        return RTypeFactory.createTypeBySymbol(symbol);
    }

    @NotNull
    public static RType createTypeBySymbol(@Nullable Symbol symbol) {
        if (symbol == null) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RTypeFactory.$$$reportNull$$$0(5);
            }
            return rEmptyType;
        }
        return RTypeFactory.createTypeBySymbol(symbol, Collections.emptyList(), true);
    }

    @NotNull
    public static RType createTypeBySymbol(@NotNull Symbol symbol, @NotNull List<RType> typeArguments) {
        if (symbol == null) {
            RTypeFactory.$$$reportNull$$$0(6);
        }
        if (typeArguments == null) {
            RTypeFactory.$$$reportNull$$$0(7);
        }
        return RTypeFactory.createTypeBySymbol(symbol, typeArguments, true);
    }

    @NotNull
    public static RType createModuleOrClassTypeWithoutGeneric(@NotNull Type type, @NotNull Project project) {
        if (type == null) {
            RTypeFactory.$$$reportNull$$$0(8);
        }
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(9);
        }
        return RTypeFactory.createModuleOrClassType(type, project, null);
    }

    @NotNull
    public static RType createModuleOrClassType(@NotNull Type type, @NotNull Project project, @Nullable RType originalType) {
        if (type == null) {
            RTypeFactory.$$$reportNull$$$0(10);
        }
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(11);
        }
        if (!type.isClass() && type != Type.MODULE) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RTypeFactory.$$$reportNull$$$0(12);
            }
            return rEmptyType;
        }
        if (RTypeUtilCore.isNullOrEmpty((RType)originalType)) {
            Symbol classSymbol = SymbolUtil.findConstantByFQN(project, type.isClass() ? "Class" : "Module");
            if (classSymbol == null) {
                REmptyType rEmptyType = REmptyType.INSTANCE;
                if (rEmptyType == null) {
                    RTypeFactory.$$$reportNull$$$0(13);
                }
                return rEmptyType;
            }
            originalType = new RSymbolTypeImpl(classSymbol);
        }
        if (type.isClass()) {
            return new RClassType((RType)originalType);
        }
        return new RModuleType((RType)originalType);
    }

    @NotNull
    public static RType createModuleOrClassType(@NotNull Project project, @NotNull Symbol originalTypeSymbol) {
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(14);
        }
        if (originalTypeSymbol == null) {
            RTypeFactory.$$$reportNull$$$0(15);
        }
        RType originalType = RTypeFactory.createTypeBySymbol(originalTypeSymbol, Collections.emptyList(), false);
        return RTypeFactory.createModuleOrClassType(originalTypeSymbol.getType(), project, originalType);
    }

    @NotNull
    public static RType createTrueType(@NotNull Project project) {
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(16);
        }
        RBooleanType rBooleanType = RBooleanType.getTrueType(project);
        if (rBooleanType == null) {
            RTypeFactory.$$$reportNull$$$0(17);
        }
        return rBooleanType;
    }

    @NotNull
    public static RType createFalseType(@NotNull Project project) {
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(18);
        }
        RBooleanType rBooleanType = RBooleanType.getFalseType(project);
        if (rBooleanType == null) {
            RTypeFactory.$$$reportNull$$$0(19);
        }
        return rBooleanType;
    }

    @NotNull
    public static RType createBoolType(@NotNull Project project) {
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(20);
        }
        RType rType = RTypeUtil.union(RTypeFactory.createTrueType(project), RTypeFactory.createFalseType(project));
        if (rType == null) {
            RTypeFactory.$$$reportNull$$$0(21);
        }
        return rType;
    }

    @NotNull
    public static RType createStringType(@NotNull Project project) {
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(22);
        }
        return RTypeFactory.createTypeByFQN(project, "String");
    }

    @NotNull
    public static RType createStringType(@NotNull RPsiElement usage) {
        RFile file;
        if (usage == null) {
            RTypeFactory.$$$reportNull$$$0(23);
        }
        RType type = RTypeFactory.createTypeClassName("String", usage);
        if (!(usage instanceof RContainer) && !(usage instanceof RStringLiteral)) {
            RType rType = type;
            if (rType == null) {
                RTypeFactory.$$$reportNull$$$0(24);
            }
            return rType;
        }
        PsiFile psiFile = usage.getContainingFile();
        if (!(psiFile instanceof RFile) || !(file = (RFile)psiFile).isValid()) {
            RType rType = type;
            if (rType == null) {
                RTypeFactory.$$$reportNull$$$0(25);
            }
            return rType;
        }
        String pragma = (String)file.getPragmas().get(FROZEN_STRING_LITERAL_PRAGMA);
        if (pragma != null) {
            Object object = "true".equals(pragma) ? new RFrozenType(type) : type;
            if (object == null) {
                RTypeFactory.$$$reportNull$$$0(26);
            }
            return object;
        }
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)usage);
        Object object = LanguageLevel.RUBY33.isLessThan(languageLevel) ? new RFrozenType(type, true) : type;
        if (object == null) {
            RTypeFactory.$$$reportNull$$$0(27);
        }
        return object;
    }

    @NotNull
    public static RType createSymbolType(@NotNull Project project) {
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(28);
        }
        return RTypeFactory.createTypeByFQN(project, "Symbol");
    }

    @NotNull
    public static RType createIntType(@NotNull Project project) {
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(29);
        }
        return new RIntegerType(project, LanguageLevel.RUBY25);
    }

    @NotNull
    public static RType createIntType(@NotNull PsiElement usage) {
        if (usage == null) {
            RTypeFactory.$$$reportNull$$$0(30);
        }
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)usage);
        return new RIntegerType(usage.getProject(), languageLevel != null ? languageLevel : LanguageLevel.latest());
    }

    public static RType createFloatType(@NotNull Project project) {
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(31);
        }
        return new RFloatType(project);
    }

    @NotNull
    public static RType createArrayType(@NotNull Project project, @NotNull RType elementType) {
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(32);
        }
        if (elementType == null) {
            RTypeFactory.$$$reportNull$$$0(33);
        }
        return RTypeFactory.createArrayType(project, elementType != REmptyType.INSTANCE ? Collections.singletonList(elementType) : Collections.emptyList());
    }

    @NotNull
    public static RType createArrayType(@NotNull Project project, @NotNull List<RType> elementTypes) {
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(34);
        }
        if (elementTypes == null) {
            RTypeFactory.$$$reportNull$$$0(35);
        }
        return RTypeFactory.createRCollectionType(project, elementTypes, "Array");
    }

    @NotNull
    public static RType createRangeType(@NotNull Project project, @NotNull RType elementType) {
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(36);
        }
        if (elementType == null) {
            RTypeFactory.$$$reportNull$$$0(37);
        }
        return RTypeFactory.createRCollectionType(project, Collections.singletonList(elementType), "Range");
    }

    @NotNull
    public static RType createSetType(@NotNull Project project, @NotNull RType elementType) {
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(38);
        }
        if (elementType == null) {
            RTypeFactory.$$$reportNull$$$0(39);
        }
        return RTypeFactory.createRCollectionType(project, Collections.singletonList(elementType), "Set");
    }

    @NotNull
    public static RType createHashType(@NotNull Project project, @NotNull RType keyType, @NotNull RType valueType) {
        Symbol hashSymbol;
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(40);
        }
        if (keyType == null) {
            RTypeFactory.$$$reportNull$$$0(41);
        }
        if (valueType == null) {
            RTypeFactory.$$$reportNull$$$0(42);
        }
        if ((hashSymbol = SymbolUtil.findConstantByFQN(project, "Hash")) == null) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RTypeFactory.$$$reportNull$$$0(43);
            }
            return rEmptyType;
        }
        return new RHashType(project, (RType)new RSymbolTypeImpl(hashSymbol), keyType, valueType);
    }

    @NotNull
    public static RType createRCollectionType(@NotNull Project project, @NotNull List<RType> elementTypes, @NotNull String collectionFQN) {
        Symbol collectionSymbol;
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(44);
        }
        if (elementTypes == null) {
            RTypeFactory.$$$reportNull$$$0(45);
        }
        if (collectionFQN == null) {
            RTypeFactory.$$$reportNull$$$0(46);
        }
        if ((collectionSymbol = SymbolUtil.findConstantByFQN(project, collectionFQN)) == null) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RTypeFactory.$$$reportNull$$$0(47);
            }
            return rEmptyType;
        }
        RSymbolTypeImpl collectionType = new RSymbolTypeImpl(collectionSymbol);
        return new RCollectionTypeImpl((RType)collectionType, elementTypes);
    }

    @NotNull
    public static RType createTypeByFQN(@NotNull Project project, @NotNull String fqn) {
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(48);
        }
        if (fqn == null) {
            RTypeFactory.$$$reportNull$$$0(49);
        }
        return RTypeFactory.createTypeByFQN(project, fqn, null);
    }

    @NotNull
    public static RType createTypeByFQN(@NotNull Project project, @NotNull String fqn, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(50);
        }
        if (fqn == null) {
            RTypeFactory.$$$reportNull$$$0(51);
        }
        return RTypeFactory.createTypeByFQN(project, fqn, Collections.emptyList(), invocationPoint);
    }

    @NotNull
    public static RType createTypeByFQN(@NotNull Project project, @NotNull String fqn, @NotNull List<RType> typeArguments, @Nullable PsiElement invocationPoint) {
        Symbol symbol;
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(52);
        }
        if (fqn == null) {
            RTypeFactory.$$$reportNull$$$0(53);
        }
        if (typeArguments == null) {
            RTypeFactory.$$$reportNull$$$0(54);
        }
        Object object = (symbol = SymbolUtil.findConstantByFQN(project, FQN.of((String)fqn), invocationPoint)) != null ? RTypeFactory.createTypeBySymbol(symbol, typeArguments) : REmptyType.INSTANCE;
        if (object == null) {
            RTypeFactory.$$$reportNull$$$0(55);
        }
        return object;
    }

    @NotNull
    public static RType createSingletonTypeByFqn(@NotNull Project project, @NotNull String fqn, @Nullable PsiElement invocationPoint) {
        Symbol typeBirthClassOrModule;
        if (project == null) {
            RTypeFactory.$$$reportNull$$$0(56);
        }
        if (fqn == null) {
            RTypeFactory.$$$reportNull$$$0(57);
        }
        if ((typeBirthClassOrModule = SymbolUtil.findConstantByFQN(project, FQN.of((String)fqn), invocationPoint)) == null) {
            LOG.debug("Cannot create type by fqn: ", new Object[]{fqn});
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RTypeFactory.$$$reportNull$$$0(58);
            }
            return rEmptyType;
        }
        return RTypeFactory.createTypeBySymbol(SymbolContainerUtil.getSingletonClassSymbol(typeBirthClassOrModule));
    }

    @Nullable
    public static RType createTypeForPrimitiveTypes(Project project, String typeName, @Nullable PsiElement invocationPoint) {
        if ("Integer".equalsIgnoreCase(typeName)) {
            return invocationPoint != null ? RTypeFactory.createIntType(invocationPoint) : RTypeFactory.createIntType(project);
        }
        if ("String".equals(typeName)) {
            return invocationPoint instanceof RPsiElement ? RTypeFactory.createStringType((RPsiElement)invocationPoint) : RTypeFactory.createStringType(project);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)"Class", (CharSequence)typeName)) {
            return RTypeFactory.createModuleOrClassTypeWithoutGeneric(Type.CLASS, project);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)"Module", (CharSequence)typeName)) {
            return RTypeFactory.createModuleOrClassTypeWithoutGeneric(Type.MODULE, project);
        }
        if ("Boolean".equalsIgnoreCase(typeName)) {
            return RTypeFactory.createBoolType(project);
        }
        if ("TrueClass".equals(typeName)) {
            return RTypeFactory.createTrueType(project);
        }
        if ("FalseClass".equals(typeName)) {
            return RTypeFactory.createFalseType(project);
        }
        if ("NilClass".equals(typeName)) {
            return REmptyType.INSTANCE;
        }
        return null;
    }

    public static RType createNotTypedObjectSymbolType(Project project) {
        RType type = RTypeFactory.createTypeByFQN(project, "Object");
        if (type instanceof RSymbolTypeImpl) {
            ((RSymbolTypeImpl)type).setTyped(false);
        }
        return type;
    }

    @NotNull
    private static RType createTypeBySymbol(@NotNull Symbol symbol, @NotNull List<RType> typeArguments, boolean expandSingleton) {
        if (symbol == null) {
            RTypeFactory.$$$reportNull$$$0(59);
        }
        if (typeArguments == null) {
            RTypeFactory.$$$reportNull$$$0(60);
        }
        if (symbol instanceof TypedSymbol) {
            RType rType = ((TypedSymbol)symbol).getType((Context)SymbolUtil.getContextRepresentingSymbol(symbol));
            if (rType == null) {
                RTypeFactory.$$$reportNull$$$0(61);
            }
            return rType;
        }
        Type type = symbol.getType();
        if (Types.METHODS_LIKE.contains(type)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Method like symbol isn't expected here. It should be processed earlier. Symbol [" + String.valueOf(symbol.getType()) + "] fqn : " + String.valueOf(symbol.getFQNWithNesting()));
            }
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RTypeFactory.$$$reportNull$$$0(62);
            }
            return rEmptyType;
        }
        if (type == Type.CLASS) {
            if ("Array".equals(symbol.getName()) || "Range".equals(symbol.getName())) {
                return new RCollectionTypeImpl((RType)new RSymbolTypeImpl(symbol), List.of(RTypeUtil.union(typeArguments)));
            }
            if ("Hash".equals(symbol.getName())) {
                RType keyType = (RType)ContainerUtil.getOrElse(typeArguments, (int)0, (Object)REmptyType.INSTANCE);
                RType valueType = (RType)ContainerUtil.getOrElse(typeArguments, (int)1, (Object)REmptyType.INSTANCE);
                return RTypeFactory.createHashType(symbol.getProject(), keyType, valueType);
            }
        }
        if (Types.MODULE_OR_CLASS_OR_FILE.contains(type)) {
            if (expandSingleton && symbol instanceof SingletonClassSymbol && type != Type.FILE) {
                return RTypeFactory.createModuleOrClassType(symbol.getProject(), symbol);
            }
            Symbol expandedSymbol = expandSingleton && symbol instanceof SingletonClassSymbol ? ((SingletonClassSymbol)symbol).getOriginSymbol() : symbol;
            RType rType = RSymbolTypeImpl.create(expandedSymbol, typeArguments);
            if (rType == null) {
                RTypeFactory.$$$reportNull$$$0(63);
            }
            return rType;
        }
        REmptyType rEmptyType = REmptyType.INSTANCE;
        if (rEmptyType == null) {
            RTypeFactory.$$$reportNull$$$0(64);
        }
        return rEmptyType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 12, 13, 17, 19, 21, 24, 25, 26, 27, 43, 47, 55, 58, 61, 62, 63, 64 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 43: 
            case 47: 
            case 55: 
            case 58: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/RTypeFactory";
                break;
            }
            case 6: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 7: 
            case 54: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 44: 
            case 48: 
            case 50: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalTypeSymbol";
                break;
            }
            case 33: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 35: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypes";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyType";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueType";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionFQN";
                break;
            }
            case 49: 
            case 51: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/RTypeFactory";
                break;
            }
            case 5: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeBySymbol";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleOrClassType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createTrueType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createFalseType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createBoolType";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringType";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createHashType";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createRCollectionType";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeByFQN";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createSingletonTypeByFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTypeClassName";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createTypeBySymbol";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 43: 
            case 47: 
            case 55: 
            case 58: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createModuleOrClassTypeWithoutGeneric";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createModuleOrClassType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createTrueType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createFalseType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createBoolType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createStringType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createIntType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createFloatType";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createArrayType";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createRangeType";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createSetType";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createHashType";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createRCollectionType";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createTypeByFQN";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createSingletonTypeByFqn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 12, 13, 17, 19, 21, 24, 25, 26, 27, 43, 47, 55, 58, 61, 62, 63, 64 -> new IllegalStateException(string);
        };
    }
}

