/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types;

import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyTypeProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public abstract class AbstractFqnBasedRubyTypeProvider
implements RubyTypeProvider {
    private final Map<FQN, TypeComputer> myRegisteredTypes = new HashMap<FQN, TypeComputer>();
    private final Set<String> myRegisteredNames = new HashSet<String>();

    protected final void registerType(@NotNull FQN fqn, @NotNull TypeComputer typeComputer) {
        if (fqn == null) {
            AbstractFqnBasedRubyTypeProvider.$$$reportNull$$$0(0);
        }
        if (typeComputer == null) {
            AbstractFqnBasedRubyTypeProvider.$$$reportNull$$$0(1);
        }
        this.myRegisteredTypes.put(fqn, typeComputer);
        this.myRegisteredNames.add(fqn.getShortName());
    }

    @Nullable
    public RType createTypeByRExpression(@NotNull RExpression expression) {
        if (expression == null) {
            AbstractFqnBasedRubyTypeProvider.$$$reportNull$$$0(2);
        }
        if (expression instanceof RIdentifier && ((RIdentifier)expression).isLocalVariable()) {
            return null;
        }
        if (!this.myRegisteredNames.contains(expression.getName())) {
            return null;
        }
        Symbol symbol = ResolveUtil.resolveToSymbolWithCaching(expression.getReference());
        if (symbol == null) {
            return null;
        }
        FQN fqn = symbol.getFQNWithNesting();
        TypeComputer registeredTypeComputer = this.myRegisteredTypes.get(fqn);
        if (registeredTypeComputer == null) {
            return null;
        }
        return registeredTypeComputer.getType(symbol, (PsiElement)expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeComputer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/AbstractFqnBasedRubyTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeByRExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    protected static interface TypeComputer {
        @Nullable
        public RType getType(@NotNull Symbol var1, @NotNull PsiElement var2);
    }
}

