/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.RubySymbolProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolInheritanceInfo;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolContainerUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.TopLevelSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;

public class TopLevelSymbolImpl
extends SymbolImpl
implements TopLevelSymbol {
    @Nullable
    private final PsiElement myElement;

    public TopLevelSymbolImpl(@NotNull PsiElement element) {
        if (element == null) {
            TopLevelSymbolImpl.$$$reportNull$$$0(0);
        }
        this(element.getProject(), element);
    }

    public TopLevelSymbolImpl(@NotNull Project project, @Nullable PsiElement element) {
        if (project == null) {
            TopLevelSymbolImpl.$$$reportNull$$$0(1);
        }
        super(project, null, Type.FILE, null);
        this.myElement = element;
    }

    public PsiElement getPsiElement() {
        return this.myElement;
    }

    @NotNull
    public FQN getFQNWithNesting() {
        FQN fQN = this.getFQN();
        if (fQN == null) {
            TopLevelSymbolImpl.$$$reportNull$$$0(2);
        }
        return fQN;
    }

    @NotNull
    public FQN getFQN() {
        FQN fQN = RTopLevelContainer.TOPLEVEL_FQN;
        if (fQN == null) {
            TopLevelSymbolImpl.$$$reportNull$$$0(3);
        }
        return fQN;
    }

    public boolean isInnerReferenceToMe(@NotNull FQN reference) {
        if (reference == null) {
            TopLevelSymbolImpl.$$$reportNull$$$0(4);
        }
        return this.getFQN().equals((Object)reference);
    }

    @NotNull
    public Symbol getSingletonClassSymbol() {
        Symbol symbol = SymbolContainerUtil.getSingletonClassSymbol((Symbol)this);
        if (symbol == null) {
            TopLevelSymbolImpl.$$$reportNull$$$0(5);
        }
        return symbol;
    }

    @NotNull
    public SymbolInheritanceInfo getInheritanceInfo(@Nullable PsiElement invocationPoint) {
        SymbolInheritanceInfo symbolInheritanceInfo = SymbolContainerUtil.getSymbolInheritanceInfo((Symbol)this, invocationPoint);
        if (symbolInheritanceInfo == null) {
            TopLevelSymbolImpl.$$$reportNull$$$0(6);
        }
        return symbolInheritanceInfo;
    }

    public boolean processChildren(SymbolPsiProcessor processor, PsiElement invocationPoint) {
        if (!SymbolContainerUtil.processOwnChildren(processor, (Symbol)this, this.getFQN(), invocationPoint)) {
            return false;
        }
        RPsiElement element = (RPsiElement)ObjectUtils.tryCast((Object)this.myElement, RPsiElement.class);
        FQN fqn = this.getFQN();
        for (RubySymbolProvider provider : RubySymbolProvider.EP_NAME.getExtensionList()) {
            if (provider.processDynamicSymbols((Symbol)this, element, fqn, processor, invocationPoint)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Symbol getParentSymbol() {
        return null;
    }

    @Nullable
    public Module getModule() {
        return this.myElement != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement) : super.getModule();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        return Objects.equals(this.myElement, ((TopLevelSymbolImpl)((Object)o)).myElement);
    }

    public int hashCode() {
        return super.hashCode() * 31 + (this.myElement != null ? this.myElement.hashCode() : 0);
    }

    @NotNull
    public String toString() {
        String string = "%s{myVirtualFile=%s, myType=%s}".formatted(((Object)((Object)this)).getClass().getSimpleName(), RubyPsiUtil.getVirtualFileFromElement(this.myElement), this.myType);
        if (string == null) {
            TopLevelSymbolImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/v2/TopLevelSymbolImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/v2/TopLevelSymbolImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQNWithNesting";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingletonClassSymbol";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInheritanceInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInnerReferenceToMe";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

