/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2;

import com.intellij.psi.PsiElement;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class SingletonClassSymbol
extends ClassModuleSymbol {
    private static final FQN CLASS_FQN = FQN.Builder.fromString((String)"Class");

    public SingletonClassSymbol(@NotNull Symbol parent, @Nullable RContainer container) {
        if (parent == null) {
            SingletonClassSymbol.$$$reportNull$$$0(0);
        }
        super(parent.getProject(), RObjectClass.makeSingletonClassFQN((FQN)parent.getFQNWithNesting()), container, parent);
    }

    public SingletonClassSymbol(@NotNull Symbol parent, @NotNull FQN fqn, @Nullable RContainer container) {
        if (parent == null) {
            SingletonClassSymbol.$$$reportNull$$$0(1);
        }
        if (fqn == null) {
            SingletonClassSymbol.$$$reportNull$$$0(2);
        }
        super(parent.getProject(), fqn, container, parent);
    }

    @NotNull
    public Symbol getOriginSymbol() {
        Symbol symbol = Objects.requireNonNull(this.getParentSymbol(), "This singleton appears to have no parent??");
        if (symbol == null) {
            SingletonClassSymbol.$$$reportNull$$$0(3);
        }
        return symbol;
    }

    @Override
    @Nullable
    public Symbol getSuperClassSymbol(@Nullable PsiElement invocationPoint) {
        Symbol superClassSymbol;
        Symbol originSymbol = this.getOriginSymbol();
        Symbol result = null;
        if (originSymbol instanceof ClassModuleSymbol && (superClassSymbol = ((ClassModuleSymbol)originSymbol).getSuperClassSymbol(invocationPoint)) != null) {
            result = superClassSymbol.getSingletonClassSymbol();
        }
        if (result != null) {
            return result;
        }
        if (FQN.same((FQN)originSymbol.getFQNWithNesting(), (String)"BasicObject")) {
            return SymbolUtil.findConstantByFQN(this.getProject(), Type.CLASS, CLASS_FQN, invocationPoint);
        }
        return null;
    }

    @Override
    @NotNull
    public Symbol getSingletonClassSymbol() {
        SingletonClassSymbol singletonClassSymbol = this;
        if (singletonClassSymbol == null) {
            SingletonClassSymbol.$$$reportNull$$$0(4);
        }
        return singletonClassSymbol;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/v2/SingletonClassSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/v2/SingletonClassSymbol";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginSymbol";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingletonClassSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

