/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2;

import com.intellij.openapi.vfs.VirtualFile;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Comparator;
import java.util.Set;

public final class RubyProcessedFilesMap {
    private final Set<VirtualFile> myFiles;
    private Comparator<VirtualFile> myComparator;
    final Object2IntMap<VirtualFile> map;

    public RubyProcessedFilesMap(Set<VirtualFile> files) {
        this.map = new Object2IntOpenHashMap(files.size());
        this.map.defaultReturnValue(-1);
        this.myFiles = files;
        int i = 0;
        for (VirtualFile virtualFile : files) {
            this.map.put((Object)virtualFile, i++);
        }
    }

    public Set<VirtualFile> getFiles() {
        return this.myFiles;
    }

    public Comparator<VirtualFile> getComparator() {
        if (this.myComparator == null) {
            this.myComparator = (o1, o2) -> {
                int value1 = this.map.getInt(o1);
                int value2 = this.map.getInt(o2);
                if (value1 == -1 && value2 == -1) {
                    return 0;
                }
                if (value1 == -1) {
                    return 1;
                }
                if (value2 == -1) {
                    return -1;
                }
                return value1 - value2;
            };
        }
        return this.myComparator;
    }
}

