/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.RubySymbolProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolInheritanceInfo;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ScopeSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolContainerUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;

public class ClassModuleSymbol
extends SymbolImpl
implements ScopeSymbol {
    @NotNull
    private final FQN myFQN;
    @Nullable
    private final RContainer myContainer;

    public ClassModuleSymbol(@NotNull Project project, @NotNull FQN fqn, @Nullable RContainer creationPoint, @Nullable Symbol parent) {
        if (project == null) {
            ClassModuleSymbol.$$$reportNull$$$0(0);
        }
        if (fqn == null) {
            ClassModuleSymbol.$$$reportNull$$$0(1);
        }
        this(project, fqn, creationPoint != null ? creationPoint.getSymbolType() : Type.CLASS, creationPoint, parent);
    }

    public ClassModuleSymbol(@NotNull Project project, @NotNull FQN fqn, @NotNull Type type, @Nullable RContainer creationPoint, @Nullable Symbol parent) {
        if (project == null) {
            ClassModuleSymbol.$$$reportNull$$$0(2);
        }
        if (fqn == null) {
            ClassModuleSymbol.$$$reportNull$$$0(3);
        }
        if (type == null) {
            ClassModuleSymbol.$$$reportNull$$$0(4);
        }
        super(project, fqn.getShortName(), type, parent);
        this.myFQN = fqn;
        this.myContainer = creationPoint;
    }

    @NotNull
    public Collection<PsiElement> getAllDeclarations(@Nullable PsiElement invocationPoint) {
        List<RContainer> declarations = RubyFQNUtil.findContainersByFQN(this.getProject(), this.getType().asSet(), this.myFQN, (PsiElement)this.myContainer);
        if (!declarations.isEmpty()) {
            return new ArrayList<RContainer>(declarations);
        }
        List<Object> list = this.myContainer != null && this.myContainer.isValid() ? List.of(this.myContainer) : Collections.emptyList();
        if (list == null) {
            ClassModuleSymbol.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean processChildren(SymbolPsiProcessor processor, PsiElement invocationPoint) {
        if (!SymbolContainerUtil.processOwnChildren(processor, (Symbol)this, this.myFQN, invocationPoint)) {
            return false;
        }
        if (this.myContainer != invocationPoint) {
            FQN fqn = this.getFQN();
            for (RubySymbolProvider provider : RubySymbolProvider.EP_NAME.getExtensionList()) {
                if (provider.processDynamicSymbols((Symbol)this, (RPsiElement)this.myContainer, fqn, processor, invocationPoint)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public Symbol getSuperClassSymbol(@Nullable PsiElement invocationPoint) {
        return SymbolContainerUtil.findSuperclass((Symbol)this, invocationPoint);
    }

    public final boolean processSuperClassSymbols(@NotNull Processor<? super Symbol> symbolProcessor, @Nullable PsiElement invocationPoint, boolean strict) {
        ClassModuleSymbol symbol;
        if (symbolProcessor == null) {
            ClassModuleSymbol.$$$reportNull$$$0(6);
        }
        HashSet<ClassModuleSymbol> visitedSymbols = new HashSet<ClassModuleSymbol>();
        ClassModuleSymbol classModuleSymbol = symbol = strict ? SymbolContainerUtil.getSymbolInheritanceInfo((Symbol)this, invocationPoint).getSuperClass() : this;
        while (symbol instanceof ClassModuleSymbol && visitedSymbols.add(symbol)) {
            if (!symbolProcessor.process((Object)symbol)) {
                return false;
            }
            symbol = SymbolContainerUtil.getSymbolInheritanceInfo((Symbol)symbol, invocationPoint).getSuperClass();
        }
        return true;
    }

    public boolean isInnerReferenceToMe(@NotNull FQN reference) {
        if (reference == null) {
            ClassModuleSymbol.$$$reportNull$$$0(7);
        }
        return this.getFQN().equals((Object)reference);
    }

    @NotNull
    public FQN getFQN() {
        FQN fQN = this.myFQN;
        if (fQN == null) {
            ClassModuleSymbol.$$$reportNull$$$0(8);
        }
        return fQN;
    }

    @NotNull
    public FQN getFQNWithNesting() {
        FQN fQN = this.getFQN();
        if (fQN == null) {
            ClassModuleSymbol.$$$reportNull$$$0(9);
        }
        return fQN;
    }

    public Module getModule() {
        return this.getPsiElement() != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getPsiElement()) : null;
    }

    @Nullable
    public Symbol getParentSymbol() {
        return this.myParent != null ? this.myParent : SymbolUtil.getSymbolByContainer((RElementWithFQN)RubyPsiUtilCore.getParentNamespace((PsiElement)this.getPsiElement()));
    }

    public PsiElement getPsiElement() {
        return this.myContainer;
    }

    @NotNull
    public Symbol getSingletonClassSymbol() {
        Symbol symbol = SymbolContainerUtil.getSingletonClassSymbol((Symbol)this);
        if (symbol == null) {
            ClassModuleSymbol.$$$reportNull$$$0(10);
        }
        return symbol;
    }

    @NotNull
    public SymbolInheritanceInfo getInheritanceInfo(@Nullable PsiElement invocationPoint) {
        SymbolInheritanceInfo symbolInheritanceInfo = SymbolContainerUtil.getSymbolInheritanceInfo((Symbol)this, invocationPoint);
        if (symbolInheritanceInfo == null) {
            ClassModuleSymbol.$$$reportNull$$$0(11);
        }
        return symbolInheritanceInfo;
    }

    public List<Symbol> getIncludeSymbols(@Nullable PsiElement invocationPoint) {
        SymbolInheritanceInfo info = this.getInheritanceInfo(invocationPoint);
        return ContainerUtil.concat((List)info.getPrepends(), (List)info.getIncludes()).stream().flatMap(rCall -> ((List)rCall.getData(RubyCallTypes.INCLUDE_EXTEND_CALLS)).stream().filter(qualifiedName -> !RubyCallTypes.isIgnoredIncludeExtendArgument((RPossibleCall)rCall, qualifiedName)).map(qualifiedName -> SymbolUtil.lookupConstant((Symbol)this, (PsiElement)rCall, qualifiedName, Type.MODULE.asSet(), invocationPoint)).filter(Objects::nonNull)).collect(Collectors.toList());
    }

    public List<Symbol> getExtendSymbols(@Nullable PsiElement invocationPoint) {
        return this.getInheritanceInfo(invocationPoint).getExtends().stream().flatMap(rCall -> ((List)rCall.getData(RubyCallTypes.INCLUDE_EXTEND_CALLS)).stream().filter(qualifiedName -> !RubyCallTypes.isIgnoredIncludeExtendArgument((RPossibleCall)rCall, qualifiedName)).map(qualifiedName -> SymbolUtil.lookupConstant((Symbol)this, (PsiElement)rCall, qualifiedName, Type.MODULE.asSet(), invocationPoint)).filter(Objects::nonNull)).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        return this.getFQN().equals((Object)((ClassModuleSymbol)((Object)o)).getFQN());
    }

    public int hashCode() {
        return super.hashCode() * 31 + this.getFQN().hashCode();
    }

    @NotNull
    public String toString() {
        String string = "%s{myFQN=%s, myType=%s, myParent=%s}".formatted(((Object)((Object)this)).getClass().getSimpleName(), this.myFQN, this.myType, this.myParent);
        if (string == null) {
            ClassModuleSymbol.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/v2/ClassModuleSymbol";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/v2/ClassModuleSymbol";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDeclarations";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQNWithNesting";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingletonClassSymbol";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInheritanceInfo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processSuperClassSymbols";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInnerReferenceToMe";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

