/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.OutboundSemiGraph;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.ResolveAncestor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.AnonymousClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;

public final class HierarchyPresentationUtil {
    public static OutboundSemiGraph<Symbol> getHierarchyGraph(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            HierarchyPresentationUtil.$$$reportNull$$$0(0);
        }
        final List ancestors = SymbolHierarchy.getAncestorsCaching(symbol, invocationPoint).stream().map(ResolveAncestor::getSymbol).collect(Collectors.toList());
        ContainerUtil.removeDuplicates(ancestors);
        final Map map = StreamEx.of(ancestors).toMap(it -> SymbolHierarchy.getAncestorsCaching(it, invocationPoint).stream().map(ResolveAncestor::getSymbol).collect(Collectors.toSet()));
        OutboundSemiGraph<Symbol> graph = new OutboundSemiGraph<Symbol>(){

            @NotNull
            public Collection<Symbol> getNodes() {
                List list = ancestors;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @NotNull
            public Iterator<Symbol> getOut(Symbol n) {
                Iterator<Symbol> iterator = ((Set)map.get(n)).iterator();
                if (iterator == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/util/HierarchyPresentationUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOut";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        DFSTBuilder builder2 = new DFSTBuilder((OutboundSemiGraph)graph);
        for (Symbol pair : ContainerUtil.reverse((List)builder2.getSortedNodes())) {
            ((Set)map.get(pair)).remove(pair);
            ArrayList<Symbol> toRemove = new ArrayList<Symbol>();
            for (Symbol edge : (Set)map.get(pair)) {
                Set collection = (Set)map.get(edge);
                if (collection != null) {
                    toRemove.addAll(collection);
                    continue;
                }
                toRemove.add(edge);
            }
            toRemove.forEach(((Set)map.get(pair))::remove);
        }
        return graph;
    }

    @NotNull
    public static String toDot(@NotNull OutboundSemiGraph<Pair<Symbol, ContextImpl>> graph) {
        if (graph == null) {
            HierarchyPresentationUtil.$$$reportNull$$$0(1);
        }
        StringBuilder builder2 = new StringBuilder();
        int i = 0;
        Object2IntOpenHashMap objectIntHashMap = new Object2IntOpenHashMap();
        objectIntHashMap.defaultReturnValue(-1);
        AtomicInteger integer = new AtomicInteger();
        graph.getNodes().forEach(arg_0 -> HierarchyPresentationUtil.lambda$toDot$1((Object2IntMap)objectIntHashMap, integer, arg_0));
        builder2.append("digraph {");
        for (Pair node : graph.getNodes()) {
            builder2.append("V").append(i).append("[label=\"").append(HierarchyPresentationUtil.symbolToString((Symbol)node.first)).append(" ").append(((ContextImpl)node.second).getAccess().getMask()).append("\"]").append(System.lineSeparator());
            int cur = i++;
            graph.getOut((Object)node).forEachRemaining(arg_0 -> HierarchyPresentationUtil.lambda$toDot$2(builder2, cur, (Object2IntMap)objectIntHashMap, arg_0));
        }
        builder2.append("}");
        String string = builder2.toString();
        if (string == null) {
            HierarchyPresentationUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static String symbolToString(Symbol symbol) {
        if (symbol instanceof SingletonClassSymbol) {
            return "S[" + symbol.getParentSymbol().getName() + "]";
        }
        if (symbol instanceof AnonymousClassModuleSymbol) {
            return "A[" + symbol.getParentSymbol().getName() + "]";
        }
        if (Objects.equals(symbol.getName(), "ClassMethods")) {
            return "CM[" + symbol.getParentSymbol().getName() + "]";
        }
        return symbol.getName();
    }

    public static void toSvgFile(@NotNull String outSvgFile, @NotNull OutboundSemiGraph<Pair<Symbol, ContextImpl>> graph) {
        if (outSvgFile == null) {
            HierarchyPresentationUtil.$$$reportNull$$$0(3);
        }
        if (graph == null) {
            HierarchyPresentationUtil.$$$reportNull$$$0(4);
        }
        try {
            String dotUtilName = SystemInfo.isUnix ? "dot" : "dot.exe";
            File dotFullPath = PathEnvironmentVariableUtil.findInPath((String)dotUtilName);
            if (dotFullPath == null) {
                throw new FileNotFoundException("Cannot find dot utility in path");
            }
            File tmpFile = FileUtil.createTempFile((String)"inheritance", (String)".dot", (boolean)true);
            FileUtil.writeToFile((File)tmpFile, (String)HierarchyPresentationUtil.toDot(graph));
            GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{dotFullPath.getAbsolutePath()}).withInput(tmpFile.getAbsoluteFile()).withParameters(new String[]{"-Tsvg", "-o" + outSvgFile, tmpFile.getAbsolutePath()}).withRedirectErrorStream(true);
            ExecUtil.execAndGetOutput((GeneralCommandLine)generalCommandLine);
        }
        catch (ExecutionException | IOException e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void lambda$toDot$2(StringBuilder builder2, int cur, Object2IntMap objectIntHashMap, Pair it) {
        builder2.append("V").append(cur).append(" -> ").append("V").append(objectIntHashMap.getInt((Object)it)).append(System.lineSeparator());
    }

    private static /* synthetic */ void lambda$toDot$1(Object2IntMap objectIntHashMap, AtomicInteger integer, Pair it) {
        objectIntHashMap.put((Object)it, integer.getAndIncrement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/util/HierarchyPresentationUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outSvgFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/util/HierarchyPresentationUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toDot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchyGraph";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toDot";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toSvgFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

