/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.model.Pointer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.cache.DumbAwareCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.TextResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubyModificationTrackers;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.AttributeFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubySymbolNameIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;

@Service(value={Service.Level.PROJECT})
public final class RubyTextResolveResultsCache
implements Disposable {
    private final Project myProject;
    private final Cache<String, List<Pointer<TextResolveResult>>> myCache;
    private final AtomicLong myStamp;

    public RubyTextResolveResultsCache(@NotNull Project project) {
        if (project == null) {
            RubyTextResolveResultsCache.$$$reportNull$$$0(0);
        }
        this.myStamp = new AtomicLong();
        this.myProject = project;
        this.myCache = new DumbAwareCache<String, List<Pointer<TextResolveResult>>>(project, Caffeine.newBuilder().maximumSize(1000L).build());
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                RubyTextResolveResultsCache.this.myCache.invalidateAll();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/RubyTextResolveResultsCache$1", "rootsChanged"));
            }
        });
        LowMemoryWatcher.register(() -> this.myCache.invalidateAll(), (Disposable)this);
    }

    public void dispose() {
        this.invalidate();
    }

    public void invalidate() {
        this.myCache.invalidateAll();
    }

    @NotNull
    public List<TextResolveResult> get(@NotNull String key) {
        ArrayList<TextResolveResult> results;
        Cache<String, List<Pointer<TextResolveResult>>> cache;
        List cached;
        if (key == null) {
            RubyTextResolveResultsCache.$$$reportNull$$$0(1);
        }
        if ((cached = (List)(cache = this.getCache()).getIfPresent((Object)key)) != null) {
            results = ContainerUtil.mapNotNull((Collection)cached, Pointer::dereference);
            if (results.size() == cached.size()) {
                ArrayList<TextResolveResult> arrayList = results;
                if (arrayList == null) {
                    RubyTextResolveResultsCache.$$$reportNull$$$0(2);
                }
                return arrayList;
            }
            this.myCache.invalidate((Object)key);
        }
        results = new ArrayList<TextResolveResult>();
        try {
            Collection elements = (Collection)ReadAction.compute(() -> RubySymbolNameIndex.getInstance().getElements(this.myProject, (SearchScope)GlobalSearchScope.allScope((Project)this.myProject), key));
            for (PsiElement element : elements) {
                RCall call;
                if (element instanceof RCall && RubyCallTypesCore.isFieldConstructor((RCall)(call = (RCall)element)) && !key.equals(call.getName())) {
                    results.add(new TextResolveResult((PsiElement)new AttributeFakePsiElement(key, call), key));
                    continue;
                }
                results.add(new TextResolveResult(element, key));
            }
        }
        catch (IndexNotReadyException __) {
            List<TextResolveResult> list = Collections.emptyList();
            if (list == null) {
                RubyTextResolveResultsCache.$$$reportNull$$$0(3);
            }
            return list;
        }
        this.myCache.put((Object)key, (Object)ContainerUtil.map(results, TextResolveResult::createPointer));
        ArrayList<TextResolveResult> arrayList = results;
        if (arrayList == null) {
            RubyTextResolveResultsCache.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @RequiresReadLock
    @NotNull
    private Cache<String, List<Pointer<TextResolveResult>>> getCache() {
        ThreadingAssertions.softAssertReadAccess();
        long stamp = RubyModificationTrackers.getPerFileElementTypeModificationTracker(this.myProject).getModificationCount();
        if (this.myStamp.getAndSet(stamp) != stamp) {
            this.invalidate();
        }
        Cache<String, List<Pointer<TextResolveResult>>> cache = this.myCache;
        if (cache == null) {
            RubyTextResolveResultsCache.$$$reportNull$$$0(5);
        }
        return cache;
    }

    @NotNull
    public static RubyTextResolveResultsCache getInstance(@NotNull Project project) {
        if (project == null) {
            RubyTextResolveResultsCache.$$$reportNull$$$0(6);
        }
        RubyTextResolveResultsCache rubyTextResolveResultsCache = (RubyTextResolveResultsCache)project.getService(RubyTextResolveResultsCache.class);
        if (rubyTextResolveResultsCache == null) {
            RubyTextResolveResultsCache.$$$reportNull$$$0(7);
        }
        return rubyTextResolveResultsCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/RubyTextResolveResultsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/RubyTextResolveResultsCache";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCache";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

