/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.ruby.model.cache.DumbAwareCache;
import org.jetbrains.plugins.ruby.model.cache.IdempotentCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.AbstractRubyPsiModificationCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubyModificationTrackers;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolInheritanceInfo;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.ResolveAncestor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;

@Service(value={Service.Level.PROJECT})
public final class RubySymbolsLookupCache
extends AbstractRubyPsiModificationCache {
    private final LoadingCache<SearchScope, MyCache> myCache;
    private final AtomicLong myStamp;

    public RubySymbolsLookupCache(@NotNull Project project) {
        if (project == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(0);
        }
        super(project);
        this.myCache = Caffeine.newBuilder().softValues().build(__ -> new MyCache(this.myProject));
        this.myStamp = new AtomicLong();
        this.initializeListeners();
    }

    @Override
    public void dispose() {
        this.myCache.invalidateAll();
    }

    @Nullable
    public List<ResolveAncestor> getAncestors(@Nullable PsiElement element, @NotNull Symbol symbol) {
        if (symbol == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(1);
        }
        return this.getCache(element).getAncestors(symbol);
    }

    public void registerAncestors(@Nullable PsiElement element, @NotNull Symbol symbol, @NotNull List<ResolveAncestor> ancestors) {
        if (symbol == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(2);
        }
        if (ancestors == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(3);
        }
        this.getCache(element).registerAncestors(symbol, ancestors);
    }

    @Nullable
    public Symbol getMatchedSymbolByName(@Nullable PsiElement element, @NotNull Symbol symbol, String name) {
        if (symbol == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(4);
        }
        return this.getCache(element).getMatchedSymbolByName(symbol, name);
    }

    public void registerMatchedSymbol(PsiElement element, @NotNull Symbol symbol, @NotNull Symbol s) {
        if (symbol == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(5);
        }
        if (s == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(6);
        }
        this.getCache(element).registerMatchedSymbol(symbol, s);
    }

    public void registerExceptionFQN(@NotNull PsiElement element, @NotNull FQN fqn, @NotNull Boolean isException) {
        if (element == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(7);
        }
        if (fqn == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(8);
        }
        if (isException == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(9);
        }
        this.getCache(element).registerException(fqn, isException);
    }

    @Nullable
    public Boolean isExceptionFQN(@NotNull PsiElement element, @NotNull FQN fqn) {
        if (element == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(10);
        }
        if (fqn == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(11);
        }
        return this.getCache(element).isExceptionFQN(fqn);
    }

    public boolean isNotFound(@Nullable PsiElement element, @NotNull Symbol symbol, @NotNull String name) {
        if (symbol == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(12);
        }
        if (name == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(13);
        }
        return this.getCache(element).isNotFound(symbol, name);
    }

    public void registerNotFoundName(@Nullable PsiElement element, @NotNull Symbol symbol, @NotNull String name) {
        if (symbol == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(14);
        }
        if (name == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(15);
        }
        this.getCache(element).registerNotFoundName(symbol, name);
    }

    public Boolean isInheritor(@Nullable PsiElement element, Symbol symbol, String className) {
        return this.getCache(element).isInheritor(symbol, className);
    }

    public void registerIsInheritor(@Nullable PsiElement element, Symbol symbol, String className, boolean isInheritor) {
        this.getCache(element).registerIsInheritor(symbol, className, isInheritor);
    }

    @NotNull
    public Collection<RPsiElement> getOrCalculateDeclarationElements(@Nullable PsiElement invocationPoint, @NotNull Symbol symbol, @NotNull @NotNull BiFunction<? super Symbol, ? super PsiElement, ? extends @NotNull Collection<RPsiElement>> calculator) {
        if (symbol == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(16);
        }
        if (calculator == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(17);
        }
        MyCache cache = this.getCache(invocationPoint);
        Collection<RPsiElement> result = (Collection<RPsiElement>)cache.myDeclarationPoints.getIfPresent((Object)symbol);
        if (result != null) {
            for (RPsiElement element : result) {
                if (element.isValid()) continue;
                result = null;
                break;
            }
        }
        if (result == null) {
            result = calculator.apply((Symbol)symbol, (PsiElement)invocationPoint);
            cache.myDeclarationPoints.put((Object)symbol, result);
        }
        Collection<RPsiElement> collection = result;
        if (collection == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(18);
        }
        return collection;
    }

    @Nullable
    public SymbolInheritanceInfo getSymbolInheritanceInfo(@Nullable PsiElement element, @NotNull Symbol symbol) {
        if (symbol == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(19);
        }
        return this.getCache(element).getSymbolInheritanceInfo(symbol);
    }

    public void registerSymbolInheritanceInfo(@Nullable PsiElement element, @NotNull Symbol symbol, @NotNull SymbolInheritanceInfo symbolInheritanceInfo) {
        if (symbol == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(20);
        }
        if (symbolInheritanceInfo == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(21);
        }
        this.getCache(element).registerSymbolInheritanceInfo(symbol, symbolInheritanceInfo);
    }

    @Override
    protected void clearModuleCache(@NotNull Module module) {
        if (module == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(22);
        }
        this.myCache.invalidateAll();
    }

    @Override
    protected void clearProjectCache() {
        this.myCache.invalidateAll();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @NotNull
    private MyCache getCache(@Nullable PsiElement psiElement) {
        void element;
        ThreadingAssertions.softAssertReadAccess();
        return this.getCache((SearchScope)(element != null ? element.getResolveScope() : GlobalSearchScope.allScope((Project)this.myProject)));
    }

    @NotNull
    private MyCache getCache(@NotNull SearchScope searchScope) {
        long stamp;
        if (searchScope == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(23);
        }
        if (this.myStamp.getAndSet(stamp = this.getCacheDependency().getModificationCount()) != stamp) {
            this.myCache.invalidateAll();
        }
        MyCache myCache = (MyCache)this.myCache.get((Object)searchScope);
        if (myCache == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(24);
        }
        return myCache;
    }

    @VisibleForTesting
    @NotNull
    public ModificationTracker getCacheDependency() {
        ModificationTracker modificationTracker = RubyModificationTrackers.getPerFileElementTypeModificationTracker(this.myProject);
        if (modificationTracker == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(25);
        }
        return modificationTracker;
    }

    @NotNull
    public static RubySymbolsLookupCache getInstance(@NotNull Project project) {
        if (project == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(26);
        }
        RubySymbolsLookupCache rubySymbolsLookupCache = (RubySymbolsLookupCache)project.getService(RubySymbolsLookupCache.class);
        if (rubySymbolsLookupCache == null) {
            RubySymbolsLookupCache.$$$reportNull$$$0(27);
        }
        return rubySymbolsLookupCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 24, 25, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestors";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isException";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calculator";
                break;
            }
            case 18: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/RubySymbolsLookupCache";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolInheritanceInfo";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/RubySymbolsLookupCache";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCalculateDeclarationElements";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCache";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheDependency";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAncestors";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerAncestors";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMatchedSymbolByName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerMatchedSymbol";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerExceptionFQN";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isExceptionFQN";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isNotFound";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerNotFoundName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOrCalculateDeclarationElements";
                break;
            }
            case 18: 
            case 24: 
            case 25: 
            case 27: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolInheritanceInfo";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerSymbolInheritanceInfo";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "clearModuleCache";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCache";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 24, 25, 27 -> new IllegalStateException(string);
        };
    }

    private static final class MyCache {
        private static final long DEFAULT_MAXIMUM_SIZE = Math.max(0, Registry.get((String)"ruby.symbols.cache.size").asInteger());
        private final Cache<Symbol, Map<String, Symbol>> myNameMap;
        private final Cache<Symbol, Set<String>> myNameNotFoundMap;
        private final Cache<Pair<Symbol, String>, Boolean> myIsInheritorMap;
        private final Cache<Symbol, List<ResolveAncestor>> myAncestors;
        private final Cache<FQN, Boolean> myExceptions;
        private final Cache<Symbol, Collection<RPsiElement>> myDeclarationPoints;
        private final Cache<Symbol, SymbolInheritanceInfo> myInheritanceInfos;

        private MyCache(@NotNull Project project) {
            if (project == null) {
                MyCache.$$$reportNull$$$0(0);
            }
            this.myNameMap = new DumbAwareCache<Symbol, Map<String, Symbol>>(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myNameNotFoundMap = new DumbAwareCache<Symbol, Set<String>>(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myIsInheritorMap = new IdempotentCache<Pair<Symbol, String>, Boolean>(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE * 10L).build());
            this.myAncestors = new IdempotentCache<Symbol, List<ResolveAncestor>>(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myExceptions = new IdempotentCache<FQN, Boolean>(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myDeclarationPoints = new DumbAwareCache<Symbol, Collection<RPsiElement>>(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myInheritanceInfos = new IdempotentCache<Symbol, SymbolInheritanceInfo>(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
        }

        public Boolean isInheritor(@NotNull Symbol symbol, @NotNull String name) {
            if (symbol == null) {
                MyCache.$$$reportNull$$$0(1);
            }
            if (name == null) {
                MyCache.$$$reportNull$$$0(2);
            }
            return (Boolean)this.myIsInheritorMap.getIfPresent((Object)Pair.create((Object)symbol, (Object)name));
        }

        public void registerIsInheritor(@NotNull Symbol symbol, @NotNull String name, boolean isInheritor) {
            if (symbol == null) {
                MyCache.$$$reportNull$$$0(3);
            }
            if (name == null) {
                MyCache.$$$reportNull$$$0(4);
            }
            this.myIsInheritorMap.put((Object)Pair.create((Object)symbol, (Object)name), (Object)isInheritor);
        }

        @Nullable
        public Symbol getMatchedSymbolByName(@NotNull Symbol symbol, String name) {
            Map map;
            if (symbol == null) {
                MyCache.$$$reportNull$$$0(5);
            }
            if ((map = (Map)this.myNameMap.getIfPresent((Object)symbol)) == null) {
                return null;
            }
            Symbol result = (Symbol)map.get(name);
            if (result == null) {
                return null;
            }
            if (MyCache.isInvalid(result)) {
                map.remove(name);
                return null;
            }
            return result;
        }

        public void registerMatchedSymbol(@NotNull Symbol symbol, @NotNull Symbol s) {
            if (symbol == null) {
                MyCache.$$$reportNull$$$0(6);
            }
            if (s == null) {
                MyCache.$$$reportNull$$$0(7);
            }
            ((Map)this.myNameMap.get((Object)symbol, __ -> new ConcurrentHashMap())).put(s.getName(), s);
        }

        public boolean isNotFound(@NotNull Symbol symbol, @NotNull String name) {
            Set notFoundNames;
            if (symbol == null) {
                MyCache.$$$reportNull$$$0(8);
            }
            if (name == null) {
                MyCache.$$$reportNull$$$0(9);
            }
            return (notFoundNames = (Set)this.myNameNotFoundMap.getIfPresent((Object)symbol)) != null && notFoundNames.contains(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerNotFoundName(@NotNull Symbol symbol, @NotNull String name) {
            Set notFoundNames;
            if (symbol == null) {
                MyCache.$$$reportNull$$$0(10);
            }
            if (name == null) {
                MyCache.$$$reportNull$$$0(11);
            }
            Cache<Symbol, Set<String>> cache = this.myNameNotFoundMap;
            synchronized (cache) {
                notFoundNames = (Set)this.myNameNotFoundMap.get((Object)symbol, __ -> ConcurrentCollectionFactory.createConcurrentSet());
            }
            notFoundNames.add(name);
        }

        public List<ResolveAncestor> getAncestors(@NotNull Symbol symbol) {
            List ancestors;
            if (symbol == null) {
                MyCache.$$$reportNull$$$0(12);
            }
            if ((ancestors = (List)this.myAncestors.getIfPresent((Object)symbol)) != null && ContainerUtil.exists((Iterable)ancestors, it -> MyCache.isInvalid(it.getSymbol()))) {
                this.myAncestors.invalidate((Object)symbol);
                return null;
            }
            return ancestors;
        }

        public void registerAncestors(@NotNull Symbol symbol, @NotNull List<ResolveAncestor> resolveEntries) {
            if (symbol == null) {
                MyCache.$$$reportNull$$$0(13);
            }
            if (resolveEntries == null) {
                MyCache.$$$reportNull$$$0(14);
            }
            this.myAncestors.put((Object)symbol, resolveEntries);
        }

        public void registerException(@NotNull FQN fqn, @NotNull Boolean isException) {
            if (fqn == null) {
                MyCache.$$$reportNull$$$0(15);
            }
            if (isException == null) {
                MyCache.$$$reportNull$$$0(16);
            }
            this.myExceptions.put((Object)fqn, (Object)isException);
        }

        @Nullable
        public Boolean isExceptionFQN(@NotNull FQN fqn) {
            if (fqn == null) {
                MyCache.$$$reportNull$$$0(17);
            }
            return (Boolean)this.myExceptions.getIfPresent((Object)fqn);
        }

        public void registerSymbolInheritanceInfo(@NotNull Symbol symbol, @NotNull SymbolInheritanceInfo symbolInheritanceInfo) {
            if (symbol == null) {
                MyCache.$$$reportNull$$$0(18);
            }
            if (symbolInheritanceInfo == null) {
                MyCache.$$$reportNull$$$0(19);
            }
            this.myInheritanceInfos.put((Object)symbol, (Object)symbolInheritanceInfo);
        }

        @Nullable
        public SymbolInheritanceInfo getSymbolInheritanceInfo(@NotNull Symbol symbol) {
            SymbolInheritanceInfo inheritanceInfo;
            if (symbol == null) {
                MyCache.$$$reportNull$$$0(20);
            }
            if ((inheritanceInfo = (SymbolInheritanceInfo)this.myInheritanceInfos.getIfPresent((Object)symbol)) != null && !inheritanceInfo.isValid()) {
                this.myInheritanceInfos.invalidate((Object)symbol);
                return null;
            }
            return inheritanceInfo;
        }

        private static boolean isInvalid(@NotNull Symbol symbol) {
            if (symbol == null) {
                MyCache.$$$reportNull$$$0(21);
            }
            return symbol.getPsiElement() != null && !symbol.getPsiElement().isValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 18: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 2: 
                case 4: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolveEntries";
                    break;
                }
                case 15: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isException";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbolInheritanceInfo";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/RubySymbolsLookupCache$MyCache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInheritor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerIsInheritor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getMatchedSymbolByName";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerMatchedSymbol";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isNotFound";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerNotFoundName";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAncestors";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerAncestors";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerException";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isExceptionFQN";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerSymbolInheritanceInfo";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSymbolInheritanceInfo";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInvalid";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

