/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Chunk;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.messages.MessageBusConnection;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.ImplicitRequireProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RequiresIndexExtension;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.graph.CondensedRequirementGraph;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.graph.RequirementGraph;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.LoadPathUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.RubyProcessedFilesMap;
import org.jetbrains.plugins.ruby.ruby.lang.AbstractRubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RequireInfo;

@Service(value={Service.Level.PROJECT})
public final class FileRequireCache
implements Disposable {
    public static final String FEATURE_TOGGLE_KEY = "ruby.disable.require.processing";
    private static final Logger LOG = Logger.getInstance(FileRequireCache.class);
    private final ConcurrentMap<Object2IntMap<VirtualFile>, Map<String, Collection<VirtualFile>>> myLoadPathLookupMap;
    private final ConcurrentMap<String, Set<VirtualFile>> myBuiltinsProcessedFiles;
    private final SimpleModificationTracker myTracker;
    private final Map<Integer, CondensedRequirementGraph> myGraphsPerLoadpath;
    private final Map<Integer, RequirementGraph> myRawGraphsPerLoadpath;
    private final Map<VirtualFile, List<RequireInfo>> myInvalidationQueue;

    public static FileRequireCache getInstance(Project project) {
        return (FileRequireCache)project.getService(FileRequireCache.class);
    }

    public FileRequireCache(final @NotNull Project project) {
        if (project == null) {
            FileRequireCache.$$$reportNull$$$0(0);
        }
        this.myLoadPathLookupMap = CollectionFactory.createConcurrentWeakMap();
        this.myBuiltinsProcessedFiles = new ConcurrentHashMap<String, Set<VirtualFile>>();
        this.myTracker = new SimpleModificationTracker();
        this.myGraphsPerLoadpath = CollectionFactory.createConcurrentSoftValueMap();
        this.myRawGraphsPerLoadpath = CollectionFactory.createConcurrentSoftValueMap();
        this.myInvalidationQueue = new HashMap<VirtualFile, List<RequireInfo>>();
        if (Registry.is((String)FEATURE_TOGGLE_KEY, (boolean)true)) {
            return;
        }
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        messageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (vFileEvent.getFile() == null) continue;
                    if (vFileEvent instanceof VFilePropertyChangeEvent) {
                        String propertyName = ((VFilePropertyChangeEvent)vFileEvent).getPropertyName();
                        if (!"name".equals(propertyName) || !FileRequireCache.isRelatedFile(project, vFileEvent.getFile())) continue;
                        FileRequireCache.this.clearCache(true);
                        continue;
                    }
                    if (vFileEvent instanceof VFileMoveEvent) {
                        if (!FileRequireCache.isRelatedFile(project, ((VFileMoveEvent)vFileEvent).getOldParent()) && !FileRequireCache.isRelatedFile(project, vFileEvent.getFile())) continue;
                        FileRequireCache.this.clearCache(true);
                        continue;
                    }
                    if (!(vFileEvent instanceof VFileCreateEvent) && !(vFileEvent instanceof VFileDeleteEvent) && !(vFileEvent instanceof VFileCopyEvent) || !FileRequireCache.isRelatedFile(project, vFileEvent.getFile())) continue;
                    FileRequireCache.this.clearCache(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/FileRequireCache$1", "after"));
            }
        });
        messageBusConnection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                FileRequireCache.this.clearCache(true);
                FileRequireCache.this.myBuiltinsProcessedFiles.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/FileRequireCache$2", "rootsChanged"));
            }
        });
        messageBusConnection.subscribe(RequiresIndexExtension.RequireSetChangedListener.TOPIC, (Object)new RequiresIndexExtension.RequireSetChangedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySetMaybeChanged(@NotNull VirtualFile virtualFile, @NotNull List<RequireInfo> newRequires) {
                if (virtualFile == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (newRequires == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!FileRequireCache.isRelatedFile(project, virtualFile)) {
                    return;
                }
                if (FileRequireCache.this.myRawGraphsPerLoadpath.isEmpty()) {
                    FileRequireCache.this.clearCache(false);
                    return;
                }
                Map<VirtualFile, List<RequireInfo>> map = FileRequireCache.this.myInvalidationQueue;
                synchronized (map) {
                    FileRequireCache.this.myInvalidationQueue.put(virtualFile, newRequires);
                }
                for (Integer hashCode : FileRequireCache.this.myGraphsPerLoadpath.keySet()) {
                    if (FileRequireCache.this.myRawGraphsPerLoadpath.get(hashCode) != null) continue;
                    FileRequireCache.this.clearCache(false);
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "virtualFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "newRequires";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/FileRequireCache$3";
                objectArray[2] = "notifySetMaybeChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private Set<VirtualFile> getProcessedFiles(@NotNull RTopLevelContainer file2start, boolean processBuiltins, boolean processImplicits) {
        if (file2start == null) {
            FileRequireCache.$$$reportNull$$$0(1);
        }
        Collection<VirtualFile> loadPath = LoadPathUtil.getLoadPath(file2start);
        Project project = file2start.getProject();
        CondensedRequirementGraph graph = this.getGraph(project, loadPath);
        LinkedHashSet<VirtualFile> processedFiles = new LinkedHashSet<VirtualFile>(graph.getAnswer(RubyPsiUtil.getVirtualFileFromElement((PsiElement)file2start)));
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2start);
        if (processImplicits && module != null) {
            for (ImplicitRequireProvider provider : ImplicitRequireProvider.EP_NAME.getExtensionList()) {
                processedFiles.addAll(provider.getImplicitRequires(module, file2start.getContainingFile()));
            }
        }
        VirtualFile virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)file2start);
        if (processBuiltins && virtualFile != null) {
            Sdk sdk = LoadPathUtil.findSdkForBuiltInSymbol(virtualFile, project);
            processedFiles.addAll(FileRequireCache.getInstance(project).getBuiltinProcessedFiles(project, sdk));
        }
        return processedFiles;
    }

    private static boolean isRelatedFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            FileRequireCache.$$$reportNull$$$0(2);
        }
        if (virtualFile == null) {
            FileRequireCache.$$$reportNull$$$0(3);
        }
        return virtualFile.isDirectory() || RequiresIndexExtension.getProcessedScope(project).accept(virtualFile) && virtualFile.getFileType() instanceof AbstractRubyFileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateGraphsIfNeeded() {
        ArrayList invalidationValues = new ArrayList();
        Map<VirtualFile, List<RequireInfo>> map = this.myInvalidationQueue;
        synchronized (map) {
            this.myInvalidationQueue.forEach((file, requires) -> invalidationValues.add(Pair.create((Object)file, (Object)requires)));
            this.myInvalidationQueue.clear();
        }
        for (RequirementGraph graph : this.myRawGraphsPerLoadpath.values()) {
            invalidationValues.forEach(pair -> {
                if (graph.invalidateOutEdges((VirtualFile)pair.first, (List)pair.second)) {
                    this.clearCache(false);
                }
            });
        }
    }

    @NotNull
    private CondensedRequirementGraph getGraph(@NotNull Project project, @NotNull Collection<VirtualFile> loadPath) {
        if (project == null) {
            FileRequireCache.$$$reportNull$$$0(4);
        }
        if (loadPath == null) {
            FileRequireCache.$$$reportNull$$$0(5);
        }
        int hashCode = loadPath.hashCode();
        CondensedRequirementGraph condensedRequirementGraph = this.myGraphsPerLoadpath.computeIfAbsent(hashCode, x -> {
            RequirementGraph rawGraph = this.myRawGraphsPerLoadpath.computeIfAbsent(hashCode, y -> new RequirementGraph(project, loadPath));
            return new CondensedRequirementGraph((Graph<Chunk<VirtualFile>>)GraphAlgorithms.getInstance().computeSCCGraph((Graph)rawGraph));
        });
        if (condensedRequirementGraph == null) {
            FileRequireCache.$$$reportNull$$$0(6);
        }
        return condensedRequirementGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(boolean clearRawGraphs) {
        LOG.debug("Clearing all caches");
        this.myLoadPathLookupMap.clear();
        this.myTracker.incModificationCount();
        this.myGraphsPerLoadpath.clear();
        if (clearRawGraphs) {
            this.myRawGraphsPerLoadpath.clear();
            Map<VirtualFile, List<RequireInfo>> map = this.myInvalidationQueue;
            synchronized (map) {
                this.myInvalidationQueue.clear();
            }
        }
    }

    @NotNull
    public Collection<VirtualFile> findFilesUnderLoadPath(@NotNull Object2IntMap<VirtualFile> loadPath, String name, Computable<Collection<VirtualFile>> computable) {
        Collection value;
        ConcurrentHashMap<String, Collection> newVal;
        ConcurrentHashMap<String, Collection> map;
        if (loadPath == null) {
            FileRequireCache.$$$reportNull$$$0(7);
        }
        if ((map = (ConcurrentHashMap<String, Collection>)this.myLoadPathLookupMap.putIfAbsent(loadPath, newVal = new ConcurrentHashMap<String, Collection>())) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache miss for " + String.valueOf(loadPath));
            }
            map = newVal;
        }
        if ((value = (Collection)map.get(name)) == null) {
            value = (Collection)computable.compute();
            map.put(name, value);
        }
        Collection collection = value;
        if (collection == null) {
            FileRequireCache.$$$reportNull$$$0(8);
        }
        return collection;
    }

    public RubyProcessedFilesMap getProcessedFilesMap(@NotNull RTopLevelContainer invocationPoint) {
        if (invocationPoint == null) {
            FileRequireCache.$$$reportNull$$$0(9);
        }
        this.invalidateGraphsIfNeeded();
        return (RubyProcessedFilesMap)CachedValuesManager.getCachedValue((PsiElement)invocationPoint, () -> {
            VirtualFile invocationPointFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)invocationPoint);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Calculating processed files for " + (invocationPointFile != null ? invocationPointFile.getPath() : null));
            }
            return new CachedValueProvider.Result((Object)new RubyProcessedFilesMap(this.getProcessedFiles(invocationPoint, true, true)), new Object[]{this.myTracker});
        });
    }

    @NotNull
    private Set<VirtualFile> getBuiltinProcessedFiles(@NotNull Project project, @Nullable Sdk sdk) {
        if (project == null) {
            FileRequireCache.$$$reportNull$$$0(10);
        }
        if (sdk == null) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                FileRequireCache.$$$reportNull$$$0(11);
            }
            return set;
        }
        String sdkHomePath = sdk.getHomePath();
        if (StringUtil.isEmptyOrSpaces((String)sdkHomePath)) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                FileRequireCache.$$$reportNull$$$0(12);
            }
            return set;
        }
        Set set = (Set)this.myBuiltinsProcessedFiles.get(sdkHomePath);
        if (set == null) {
            VirtualFile builtinFile = LoadPathUtil.getBuiltinFile(sdk);
            if (builtinFile != null) {
                PsiFile builtinPsiFile = PsiManager.getInstance((Project)project).findFile(builtinFile);
                set = builtinPsiFile != null ? this.getProcessedFiles((RTopLevelContainer)((RFile)builtinPsiFile), false, false) : Collections.emptySet();
                this.myBuiltinsProcessedFiles.put(sdkHomePath, set);
            } else {
                set = Collections.emptySet();
            }
        }
        Set set2 = set;
        if (set2 == null) {
            FileRequireCache.$$$reportNull$$$0(13);
        }
        return set2;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2start";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadPath";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/FileRequireCache";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocationPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/FileRequireCache";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesUnderLoadPath";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinProcessedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedFiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRelatedFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getGraph";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findFilesUnderLoadPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedFilesMap";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinProcessedFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

