/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.AbstractRubyPsiModificationCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyResolutionIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

public class FQNCache
extends AbstractRubyPsiModificationCache {
    private static final Logger LOG = Logger.getInstance(FQNCache.class);
    private final ConcurrentMap<String, Pair<Collection<RContainer>, Collection<RContainer>>> myFQNMap;
    private final ConcurrentMap<String, Ref<RContainer>> mySingleEntryMap;
    private final ConcurrentMap<String, Ref<RPsiElement>> myConstantCache;

    public FQNCache(@NotNull Project project) {
        if (project == null) {
            FQNCache.$$$reportNull$$$0(0);
        }
        super(project);
        this.myFQNMap = ContainerUtil.createConcurrentSoftValueMap();
        this.mySingleEntryMap = ContainerUtil.createConcurrentSoftValueMap();
        this.myConstantCache = ContainerUtil.createConcurrentSoftValueMap();
        this.initializeListeners();
    }

    @Nullable
    public RPsiElement getAnyConstant(@NotNull Project project, @NotNull FQN fqn, @Nullable PsiElement invocationPoint) {
        RPsiElement element2;
        String fqnStr;
        Ref cached;
        if (project == null) {
            FQNCache.$$$reportNull$$$0(1);
        }
        if (fqn == null) {
            FQNCache.$$$reportNull$$$0(2);
        }
        if ((cached = (Ref)this.myConstantCache.get(fqnStr = fqn.getFullPath())) != null && (element2 = (RPsiElement)cached.get()) != null && element2.isValid()) {
            return element2;
        }
        Predicate<RPsiElement> predicate = element -> element instanceof RClass || element instanceof RModule || element instanceof RConstant;
        GlobalSearchScope searchScope = invocationPoint != null ? invocationPoint.getResolveScope() : GlobalSearchScope.allScope((Project)project);
        RPsiElement element3 = (RPsiElement)ReadAction.compute(() -> RubyResolutionIndex.getInstance().findElement(project, (SearchScope)searchScope, fqnStr, predicate));
        if (!DumbService.isDumb((Project)project)) {
            this.myConstantCache.put(fqnStr, (Ref<RPsiElement>)Ref.create((Object)element3));
        }
        return element3;
    }

    @Nullable
    public RContainer getAnyClassModule(@NotNull Project project, @NotNull FQN fqn, @Nullable Predicate<RContainer> filter) {
        Predicate<RPsiElement> predicate;
        RContainer container;
        String strFqn;
        Ref value;
        if (project == null) {
            FQNCache.$$$reportNull$$$0(3);
        }
        if (fqn == null) {
            FQNCache.$$$reportNull$$$0(4);
        }
        if ((value = (Ref)this.mySingleEntryMap.get(strFqn = fqn.getFullPath())) != null && ((container = (RContainer)value.get()) == null || container.isValid())) {
            return filter == null || filter.test(container) ? container : null;
        }
        GlobalSearchScope libScope = ProjectScope.getLibrariesScope((Project)project);
        GlobalSearchScope contentScope = ProjectScope.getContentScope((Project)project);
        RContainer result = (RContainer)ReadAction.compute(() -> FQNCache.lambda$getAnyClassModule$3(project, contentScope, fqn, predicate = element -> element instanceof RContainer));
        if (result == null) {
            result = (RContainer)ReadAction.compute(() -> RubyResolutionIndex.getInstance().findElement(project, (SearchScope)libScope, fqn.getFullPath(), predicate));
        }
        if (!DumbService.isDumb((Project)project)) {
            this.mySingleEntryMap.put(strFqn, (Ref<RContainer>)Ref.create((Object)result));
        }
        return filter == null || filter.test(result) ? result : null;
    }

    public Pair<Collection<RContainer>, Collection<RContainer>> get(@NotNull Project project, @NotNull TypeSet types, @NotNull FQN fqn) {
        String strFqn;
        Pair<Collection<RContainer>, Collection<RContainer>> value;
        if (project == null) {
            FQNCache.$$$reportNull$$$0(5);
        }
        if (types == null) {
            FQNCache.$$$reportNull$$$0(6);
        }
        if (fqn == null) {
            FQNCache.$$$reportNull$$$0(7);
        }
        if ((value = (Pair<Collection<RContainer>, Collection<RContainer>>)this.myFQNMap.get(strFqn = fqn.getFullPath())) != null && (value.first != null && ContainerUtil.exists((Iterable)((Iterable)value.first), it -> it != null && !it.isValid()) || value.second != null && ContainerUtil.exists((Iterable)((Iterable)value.second), it -> it != null && !it.isValid()))) {
            value = null;
        }
        if (value == null) {
            LOG.debug("Cache not found: ", new Object[]{strFqn});
            if (DumbService.getInstance((Project)this.myProject).isDumb()) {
                LOG.debug("Dumb mode: return empty result");
                return Pair.empty();
            }
            value = FQNCache.computeFQNCacheValue(project, types, fqn);
            this.myFQNMap.put(strFqn, value);
        } else {
            LOG.debug("Cache HIT: ", new Object[]{strFqn});
        }
        return value;
    }

    public static FQNCache getInstance(Project project) {
        return (FQNCache)project.getService(FQNCache.class);
    }

    @Override
    protected void clearModuleCache(@NotNull Module module) {
        if (module == null) {
            FQNCache.$$$reportNull$$$0(8);
        }
        this.clear();
    }

    @Override
    protected void clearProjectCache() {
        this.clear();
    }

    private void clear() {
        this.myFQNMap.clear();
        this.mySingleEntryMap.clear();
        this.myConstantCache.clear();
    }

    @NotNull
    private static Pair<Collection<RContainer>, Collection<RContainer>> computeFQNCacheValue(@NotNull Project project, @NotNull TypeSet types, @NotNull FQN fqn) {
        Collection<RContainer> contentCandidates;
        Collection<RContainer> libCandidates;
        if (project == null) {
            FQNCache.$$$reportNull$$$0(9);
        }
        if (types == null) {
            FQNCache.$$$reportNull$$$0(10);
        }
        if (fqn == null) {
            FQNCache.$$$reportNull$$$0(11);
        }
        GlobalSearchScope libScope = ProjectScope.getLibrariesScope((Project)project);
        GlobalSearchScope contentScope = ProjectScope.getContentScope((Project)project);
        try {
            libCandidates = FQNCache.getScopedContainers(project, (SearchScope)libScope, types, fqn);
            contentCandidates = FQNCache.getScopedContainers(project, (SearchScope)contentScope, types, fqn);
        }
        catch (IndexNotReadyException e) {
            LOG.warn((Throwable)e);
            Pair pair = Pair.empty();
            if (pair == null) {
                FQNCache.$$$reportNull$$$0(12);
            }
            return pair;
        }
        if (libCandidates.isEmpty() && contentCandidates.isEmpty()) {
            Pair pair = Pair.empty();
            if (pair == null) {
                FQNCache.$$$reportNull$$$0(13);
            }
            return pair;
        }
        Pair pair = Pair.create(libCandidates, contentCandidates);
        if (pair == null) {
            FQNCache.$$$reportNull$$$0(14);
        }
        return pair;
    }

    @NotNull
    private static Collection<RContainer> getScopedContainers(@NotNull Project project, @NotNull SearchScope scope, @NotNull TypeSet types, @NotNull FQN fqn) {
        if (project == null) {
            FQNCache.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            FQNCache.$$$reportNull$$$0(16);
        }
        if (types == null) {
            FQNCache.$$$reportNull$$$0(17);
        }
        if (fqn == null) {
            FQNCache.$$$reportNull$$$0(18);
        }
        SmartList candidates = new SmartList();
        ((Collection)ReadAction.compute(() -> RubyResolutionIndex.getInstance().getElements(project, scope, fqn))).stream().filter(element -> {
            if (element instanceof RClass) {
                return types.contains(Type.CLASS);
            }
            if (element instanceof RModule) {
                return types.contains(Type.MODULE);
            }
            if (element instanceof RMethod) {
                return types.contains(Type.INSTANCE_METHOD) || types.contains(Type.CLASS_METHOD);
            }
            return false;
        }).forEach(arg_0 -> FQNCache.lambda$getScopedContainers$9((Collection)candidates, arg_0));
        SmartList smartList = candidates;
        if (smartList == null) {
            FQNCache.$$$reportNull$$$0(19);
        }
        return smartList;
    }

    private static /* synthetic */ void lambda$getScopedContainers$9(Collection candidates, RPsiElement e) {
        candidates.add((RContainer)e);
    }

    private static /* synthetic */ RPsiElement lambda$getAnyClassModule$3(Project project, GlobalSearchScope contentScope, FQN fqn, Predicate predicate) throws RuntimeException {
        return RubyResolutionIndex.getInstance().findElement(project, (SearchScope)contentScope, fqn.getFullPath(), predicate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 14, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 6: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/FQNCache";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/FQNCache";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeFQNCacheValue";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopedContainers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAnyConstant";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAnyClassModule";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clearModuleCache";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeFQNCacheValue";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getScopedContainers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 14, 19 -> new IllegalStateException(string);
        };
    }
}

