/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.visitors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.ArgMapping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.MutableLocalMemory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.attribute.TypeAttribute;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.ArrayValueSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.BinarySymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.BinarySymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.IntegerValueSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.NegationSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.PhiSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicCall;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.attribute.AttributeKey;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.CoreFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.primitive.RIntegerType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RFloatConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RIntegerConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RYieldStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBeginEndBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolBinExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolMatchingExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolNegExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RSelfAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RTernaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RUnaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.AnonymousDefiningCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.ClassModuleCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RLambdaCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFid;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public final class PsiParsingVisitor
extends RubyElementVisitor {
    @Nullable
    private SymbolicExpression myResult;
    @NotNull
    private final SymbolicExecutionContext myContext;
    @NotNull
    private final SymbolicExpressionProvider myProvider;
    private SerializableType myIntegerType;

    public void visitRBodyStatement(@NotNull RBodyStatement rBodyStatement) {
        if (rBodyStatement == null) {
            PsiParsingVisitor.$$$reportNull$$$0(0);
        }
        this.myResult = this.myProvider.getSymbolicExpression((RPsiElement)rBodyStatement.getCompoundStatement(), this.myContext);
    }

    private PsiParsingVisitor(@NotNull SymbolicExecutionContext context, @NotNull SymbolicExpressionProvider provider) {
        if (context == null) {
            PsiParsingVisitor.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            PsiParsingVisitor.$$$reportNull$$$0(2);
        }
        this.myResult = null;
        this.myContext = context;
        this.myProvider = provider;
    }

    public void visitGroupedExpression(@NotNull RGroupedExpression groupedExpression) {
        if (groupedExpression == null) {
            PsiParsingVisitor.$$$reportNull$$$0(3);
        }
        this.myResult = groupedExpression.getExpression() != null ? this.myProvider.getSymbolicExpression(groupedExpression.getExpression(), this.myContext) : this.myProvider.getNilSymbolicExpression();
    }

    public void visitRTopConstReference(@NotNull RTopConstReference rTopConstReference) {
        RConstant constant;
        if (rTopConstReference == null) {
            PsiParsingVisitor.$$$reportNull$$$0(4);
        }
        if ((constant = rTopConstReference.getConstant()) == null) {
            return;
        }
        String name = constant.getName();
        if (name == null) {
            return;
        }
        SymbolicCall receiver = this.myProvider.createSymbolicCall(Collections.emptyList(), "Object", null, true, false);
        this.myResult = this.myProvider.createSymbolicCall(Collections.emptyList(), name, (SymbolicExpression)receiver, true, false);
    }

    public void visitRConstant(@NotNull RConstant rConstant) {
        String name;
        if (rConstant == null) {
            PsiParsingVisitor.$$$reportNull$$$0(5);
        }
        if ((name = rConstant.getName()) != null) {
            SymbolicExpression expression = this.myContext.getLocalMemory().tryReadLocalValue(name);
            if (expression != null) {
                this.myResult = expression;
                return;
            }
            this.myResult = this.createSymbolicCallByName((RPsiElement)rConstant, rConstant.isDeclaration() || rConstant.doesReferenceToConstant());
        }
    }

    public void visitRGlobalVariable(@NotNull RGlobalVariable rGlobalVariable) {
        if (rGlobalVariable == null) {
            PsiParsingVisitor.$$$reportNull$$$0(6);
        }
        String name = rGlobalVariable.getName();
        SymbolicExpression expression = this.myContext.getLocalMemory().tryReadLocalValue("$" + name);
        this.myResult = expression != null ? expression : this.myProvider.createSymbolicCall(Collections.emptyList(), "$" + name, null, false, false);
    }

    public void visitRInstanceVariable(@NotNull RInstanceVariable rInstanceVariable) {
        SymbolicExpression expression;
        String name;
        if (rInstanceVariable == null) {
            PsiParsingVisitor.$$$reportNull$$$0(7);
        }
        if ((name = rInstanceVariable.getName()) != null && (expression = this.myContext.getLocalMemory().tryReadLocalValue("@" + name)) != null) {
            this.myResult = expression;
        }
    }

    public void visitRClassVariable(@NotNull RClassVariable rClassVariable) {
        SymbolicExpression expression;
        String name;
        if (rClassVariable == null) {
            PsiParsingVisitor.$$$reportNull$$$0(8);
        }
        if ((name = rClassVariable.getName()) != null && (expression = this.myContext.getLocalMemory().tryReadLocalValue("@@" + name)) != null) {
            this.myResult = expression;
        }
    }

    public void visitRArrayIndexing(@NotNull RArrayIndexing arrayIndexing) {
        RPsiElement psiReceiver;
        if (arrayIndexing == null) {
            PsiParsingVisitor.$$$reportNull$$$0(9);
        }
        SymbolicExpression receiver = (psiReceiver = arrayIndexing.getReceiver()) != null ? this.myProvider.getSymbolicExpression(psiReceiver, this.myContext) : null;
        List<SymbolicCall.SymbolicArgumentInfo> args = this.createSymbolicArgumentInfo(arrayIndexing.getIndexes());
        this.myResult = this.myProvider.createSymbolicCall(args, "[]", receiver, false, false);
    }

    public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
        if (rIdentifier == null) {
            PsiParsingVisitor.$$$reportNull$$$0(10);
        }
        String name = rIdentifier.getName();
        if ((rIdentifier.isLocalVariable() || rIdentifier.isParameter()) && name != null) {
            MutableLocalMemory localMemory = this.myContext.getLocalMemory();
            this.myResult = localMemory.readLocalValue(name);
        } else {
            this.myResult = this.createSymbolicCallByName((RPsiElement)rIdentifier, false);
        }
    }

    public void visitRCondition(@NotNull RCondition condition) {
        PsiElement child;
        if (condition == null) {
            PsiParsingVisitor.$$$reportNull$$$0(11);
        }
        if ((child = condition.getFirstChild()) != null) {
            child.accept((PsiElementVisitor)this);
        }
    }

    public void visitRFid(@NotNull RFid rFid) {
        if (rFid == null) {
            PsiParsingVisitor.$$$reportNull$$$0(12);
        }
        this.myResult = this.createSymbolicCallByName((RPsiElement)rFid, false);
    }

    public void visitRCodeBlock(@NotNull RCodeBlock codeBlock) {
        if (codeBlock == null) {
            PsiParsingVisitor.$$$reportNull$$$0(13);
        }
        this.myResult = this.myProvider.getSymbolicExpression((RPsiElement)codeBlock.getCompoundStatement(), this.myContext);
    }

    public void visitRAssignmentExpression(@NotNull RAssignmentExpression assignmentExpression) {
        if (assignmentExpression == null) {
            PsiParsingVisitor.$$$reportNull$$$0(14);
        }
        if (assignmentExpression.isCall()) {
            List<? extends RPsiElement> arguments = RubyPsiUtil.getCallArgumentsIncludingIndexes((RPossibleCall)assignmentExpression);
            List<SymbolicCall.SymbolicArgumentInfo> symbolicArgumentInfos = this.createSymbolicArgumentInfo(arguments);
            this.myResult = this.createSymbolicCallByAssignmentWithArguments(this.myContext, (PsiElement)assignmentExpression.getObject(), symbolicArgumentInfos);
        } else {
            this.myResult = assignmentExpression.getValue() != null ? this.myProvider.getSymbolicExpression(assignmentExpression.getValue(), this.myContext) : this.myProvider.getSymbolicExpression(assignmentExpression.getObject(), this.myContext);
        }
    }

    public void visitRSelfAssignmentExpression(RSelfAssignmentExpression selfAssignmentExpression) {
        if (selfAssignmentExpression.getValue() != null) {
            this.myResult = this.myProvider.createExpression(id -> new BinarySymbolicExpressionImpl(id, this.myProvider.getSymbolicExpression(selfAssignmentExpression.getObject(), this.myContext), this.myProvider.getSymbolicExpression(selfAssignmentExpression.getValue(), this.myContext), BinarySymbolicExpression.OperationKind.SELF_ASSIGNMENT));
        }
    }

    public void visitRArray(@NotNull RArray array) {
        if (array == null) {
            PsiParsingVisitor.$$$reportNull$$$0(15);
        }
        List arrayItems = ContainerUtil.map((Collection)array.getElements(), it -> this.myProvider.getSymbolicExpression(it, this.myContext));
        this.myResult = this.myProvider.createExpression(id -> new ArrayValueSymbolicExpressionImpl((SymbolicExpression.IdSupplier)id, arrayItems));
    }

    public void visitRTernaryExpression(@NotNull RTernaryExpression ternaryExpression) {
        if (ternaryExpression == null) {
            PsiParsingVisitor.$$$reportNull$$$0(16);
        }
        RPsiElement trueCommand = ternaryExpression.getTrueCommand();
        RPsiElement falseCommand = ternaryExpression.getFalseCommand();
        RCondition condition = ternaryExpression.getCondition();
        if (condition != null && trueCommand != null && falseCommand != null) {
            this.myResult = this.myProvider.createExpression(id -> new PhiSymbolicExpressionImpl(id, this.myProvider.getSymbolicExpression((RPsiElement)condition, this.myContext), this.myProvider.getSymbolicExpression(trueCommand, this.myContext), this.myProvider.getSymbolicExpression(falseCommand, this.myContext)));
        } else if (trueCommand != null) {
            this.myResult = this.myProvider.getSymbolicExpression(trueCommand, this.myContext);
        } else if (falseCommand != null) {
            this.myResult = this.myProvider.getSymbolicExpression(falseCommand, this.myContext);
        }
    }

    public void visitRBoolBinExpression(@NotNull RBoolBinExpression rBoolBinExpression) {
        IElementType operationType;
        boolean isBooleanAnd;
        if (rBoolBinExpression == null) {
            PsiParsingVisitor.$$$reportNull$$$0(17);
        }
        boolean bl = isBooleanAnd = (operationType = rBoolBinExpression.getOperationType()) == RubyTokenTypesCore.tAND || operationType == RubyTokenTypes.kAND;
        if (rBoolBinExpression.getRightOperand() != null) {
            this.myResult = this.myProvider.createExpression(id -> new BinarySymbolicExpressionImpl(id, this.myProvider.getSymbolicExpression(rBoolBinExpression.getLeftOperand(), this.myContext), this.myProvider.getSymbolicExpression(rBoolBinExpression.getRightOperand(), this.myContext), isBooleanAnd ? BinarySymbolicExpression.OperationKind.BOOLEAN_AND : BinarySymbolicExpression.OperationKind.BOOLEAN_OR));
        }
        if (rBoolBinExpression instanceof RBoolMatchingExpression) {
            this.myResult = this.myProvider.createTypedSymbolicExpression(SerializableTypeUtil.BOOLEAN);
        }
    }

    public void visitRBoolMatchingExpression(@NotNull RBoolMatchingExpression expr) {
        if (expr == null) {
            PsiParsingVisitor.$$$reportNull$$$0(18);
        }
        BinarySymbolicExpression.OperationKind operationKind = BinarySymbolicExpression.OperationKind.from((IElementType)expr.getOperationType());
        RPsiElement rightOperand = expr.getRightOperand();
        if (operationKind != null && rightOperand != null) {
            this.myResult = this.myProvider.createExpression(id -> new BinarySymbolicExpressionImpl(id, this.myProvider.getSymbolicExpression(expr.getLeftOperand(), this.myContext), this.myProvider.getSymbolicExpression(rightOperand, this.myContext), operationKind));
        } else {
            super.visitRBoolMatchingExpression(expr);
        }
    }

    public void visitRPseudoConstant(@NotNull RPseudoConstant rPseudoConstant) {
        if (rPseudoConstant == null) {
            PsiParsingVisitor.$$$reportNull$$$0(19);
        }
        if (rPseudoConstant.getText().equals(RubyTokenTypesCore.kTRUE.toString())) {
            this.myResult = this.myProvider.getTrueSymbolicExpression();
        } else if (rPseudoConstant.getText().equals(RubyTokenTypesCore.kFALSE.toString())) {
            this.myResult = this.myProvider.getFalseSymbolicExpression();
        } else if (rPseudoConstant.getText().equals(RubyTokenTypesCore.kNIL.toString())) {
            this.myResult = this.myProvider.getNilSymbolicExpression();
        } else if (rPseudoConstant.getText().equals(RubyTokenTypes.kSELF.toString())) {
            this.myResult = this.createSymbolicCallByName((RPsiElement)rPseudoConstant, false);
        } else if (rPseudoConstant.getText().equals(RubyTokenTypes.kSUPER.toString())) {
            RMethod method = RubyPsiUtil.getContainingRMethod((PsiElement)rPseudoConstant);
            if (method == null) {
                return;
            }
            MutableLocalMemory memory = this.myContext.getLocalMemory();
            List args = rPseudoConstant.getParent() instanceof RCall ? Collections.emptyList() : ContainerUtil.map((Collection)method.getArguments(), parameter -> SymbolicCall.SymbolicArgumentInfo.fromParameter((RArgument)parameter, (SymbolicExpression)memory.readLocalValue(parameter.getName())));
            this.myResult = this.createSymbolicCallByNameWithArguments((RPsiElement)rPseudoConstant, args, false);
        }
    }

    public void visitRUnaryExpression(@NotNull RUnaryExpression unaryExpression) {
        if (unaryExpression == null) {
            PsiParsingVisitor.$$$reportNull$$$0(20);
        }
        String command = unaryExpression.getOperationName();
        RPsiElement receiver = unaryExpression.getElement();
        if (receiver == null) {
            this.myResult = null;
            return;
        }
        SymbolicExpression expression = this.myProvider.getSymbolicExpression(receiver, this.myContext);
        this.myResult = this.myProvider.createSymbolicCall(Collections.emptyList(), command, expression, false, false).trySimplify(this.myProvider);
    }

    public void visitRBoolNegExpression(@NotNull RBoolNegExpression rBoolNegExpression) {
        if (rBoolNegExpression == null) {
            PsiParsingVisitor.$$$reportNull$$$0(21);
        }
        if (rBoolNegExpression.getElement() != null) {
            this.myResult = this.myProvider.createExpression(id -> new NegationSymbolicExpressionImpl(id, this.myProvider.getSymbolicExpression(rBoolNegExpression.getElement(), this.myContext)));
        }
    }

    public void visitRYieldStatement(@NotNull RYieldStatement rYieldStatement) {
        if (rYieldStatement == null) {
            PsiParsingVisitor.$$$reportNull$$$0(22);
        }
        List<SymbolicCall.SymbolicArgumentInfo> symbolicArgumentInfos = this.createSymbolicArgumentInfo(rYieldStatement.getArguments());
        this.myResult = this.myProvider.createSymbolicCall(symbolicArgumentInfos, "yield", null, false, false);
    }

    public void visitRBeginEndBlockStatement(@NotNull RBeginEndBlockStatement rBeginEndBlockStatement) {
        RBodyStatement body;
        List statements;
        if (rBeginEndBlockStatement == null) {
            PsiParsingVisitor.$$$reportNull$$$0(23);
        }
        if ((statements = (body = rBeginEndBlockStatement.getBody()).getCompoundStatement().getStatements()).isEmpty()) {
            this.myResult = this.myProvider.getNilSymbolicExpression();
        } else {
            RPsiElement lastElement = (RPsiElement)statements.get(statements.size() - 1);
            this.myResult = this.myProvider.getSymbolicExpression(lastElement, this.myContext);
        }
    }

    public void visitRIntegerConstant(@NotNull RIntegerConstant rIntegerConstant) {
        if (rIntegerConstant == null) {
            PsiParsingVisitor.$$$reportNull$$$0(24);
        }
        Integer value = rIntegerConstant.getValue();
        if (rIntegerConstant.getModifier() != null) {
            this.myResult = this.createModifiedNumericConstant(rIntegerConstant.getModifier());
        } else {
            if (this.myIntegerType == null) {
                this.myIntegerType = SerializableTypeUtil.createFullyQualifiedType((String)RIntegerType.getClassName(this.myProvider.getLanguageLevel()));
            }
            if (value != null) {
                this.myResult = this.myProvider.createExpression(id -> new IntegerValueSymbolicExpressionImpl((SymbolicExpression.IdSupplier)id, value));
                this.myResult.setAttributeValue((AttributeKey)TypeAttribute.INSTANCE, (Object)this.myIntegerType);
            } else {
                this.myResult = this.myProvider.createTypedSymbolicExpression(this.myIntegerType);
            }
        }
    }

    public void visitRFloatConstant(@NotNull RFloatConstant rFloatConstant) {
        if (rFloatConstant == null) {
            PsiParsingVisitor.$$$reportNull$$$0(25);
        }
        this.myResult = rFloatConstant.getModifier() != null ? this.createModifiedNumericConstant(rFloatConstant.getModifier()) : this.myProvider.createTypedSymbolicExpression(SerializableTypeUtil.createFullyQualifiedType((String)"Float"));
    }

    public void visitRCall(@NotNull RCall rCall) {
        if (rCall == null) {
            PsiParsingVisitor.$$$reportNull$$$0(26);
        }
        if (this.handleClassModuleCallType((RPossibleCall)rCall)) {
            return;
        }
        List arguments = rCall.getCallArguments().getElements();
        List<SymbolicCall.SymbolicArgumentInfo> symbolicArgumentInfos = this.createSymbolicArgumentInfo(arguments);
        this.myResult = this.createSymbolicCallWithArguments((RPsiElement)rCall.getPsiCommand(), this.myContext, symbolicArgumentInfos);
    }

    public void visitRLambdaCall(@NotNull RLambdaCall lambdaCall) {
        if (lambdaCall == null) {
            PsiParsingVisitor.$$$reportNull$$$0(27);
        }
        List arguments = lambdaCall.getCallArguments().getElements();
        List<SymbolicCall.SymbolicArgumentInfo> symbolicArgumentInfos = this.createSymbolicArgumentInfo(arguments);
        this.myResult = this.createSymbolicCallByRLambdaCallWithArguments(lambdaCall, this.myContext, symbolicArgumentInfos, RubyPsiUtil.isBlockGivenToPsiElement((PsiElement)lambdaCall));
    }

    public void visitRBinaryExpression(@NotNull RBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            PsiParsingVisitor.$$$reportNull$$$0(28);
        }
        String command = binaryExpression.getOperation().getText();
        RPsiElement receiver = binaryExpression.getLeftOperand();
        if (command == null || receiver == null) {
            this.myResult = null;
            return;
        }
        RPsiElement rightOperand = binaryExpression.getRightOperand();
        List arguments = ContainerUtil.createMaybeSingletonList((Object)rightOperand);
        this.myResult = this.myProvider.createSymbolicCall(this.createSymbolicArgumentInfo(arguments), command, this.myProvider.getSymbolicExpression(receiver, this.myContext), false, false).trySimplify(this.myProvider);
    }

    public void visitRReference(@NotNull RReference rReference) {
        if (rReference == null) {
            PsiParsingVisitor.$$$reportNull$$$0(29);
        }
        if (this.handleClassModuleCallType((RPossibleCall)rReference)) {
            return;
        }
        boolean isConstant = RReferenceBase.doesResolveToConstant((RReference)rReference);
        boolean isBlockGiven = RubyPsiUtil.isBlockGivenToPsiElement((PsiElement)rReference);
        this.myResult = this.createSymbolicCallByRReferenceWithArguments(rReference, this.myContext, Collections.emptyList(), isConstant, isBlockGiven);
    }

    public void visitRBlockCall(@NotNull RBlockCall blockCall) {
        if (blockCall == null) {
            PsiParsingVisitor.$$$reportNull$$$0(30);
        }
        this.myResult = this.myProvider.getSymbolicExpression((RPsiElement)blockCall.getCall(), this.myContext);
    }

    public void visitRStringLiteral(@NotNull RStringLiteral rStringLiteral) {
        if (rStringLiteral == null) {
            PsiParsingVisitor.$$$reportNull$$$0(31);
        }
        this.myResult = this.myProvider.createTypedSymbolicExpression(SerializableTypeUtil.STRING);
    }

    public void visitRDStringLiteral(@NotNull RStringLiteral rDStringLiteral) {
        if (rDStringLiteral == null) {
            PsiParsingVisitor.$$$reportNull$$$0(32);
        }
        this.myResult = this.myProvider.createTypedSymbolicExpression(SerializableTypeUtil.STRING);
    }

    public void visitRSymbol(@NotNull RSymbol rSymbol) {
        if (rSymbol == null) {
            PsiParsingVisitor.$$$reportNull$$$0(33);
        }
        this.myResult = this.myProvider.createTypedSymbolicExpression(SerializableTypeUtil.createFullyQualifiedType((String)"Symbol"));
    }

    @Nullable
    private SymbolicExpression createSymbolicCallWithArguments(@NotNull RPsiElement call, @NotNull SymbolicExecutionContext context, @NotNull List<SymbolicCall.SymbolicArgumentInfo> arguments) {
        if (call == null) {
            PsiParsingVisitor.$$$reportNull$$$0(34);
        }
        if (context == null) {
            PsiParsingVisitor.$$$reportNull$$$0(35);
        }
        if (arguments == null) {
            PsiParsingVisitor.$$$reportNull$$$0(36);
        }
        if (call instanceof RReference) {
            return this.createSymbolicCallByRReferenceWithArguments((RReference)call, context, arguments, false, RubyPsiUtil.isBlockGivenToPsiElement((PsiElement)call));
        }
        return this.createSymbolicCallByNameWithArguments(call, arguments, false);
    }

    @Nullable
    private SymbolicExpression createSymbolicCallByName(@NotNull RPsiElement call, boolean isConstant) {
        if (call == null) {
            PsiParsingVisitor.$$$reportNull$$$0(37);
        }
        return this.createSymbolicCallByNameWithArguments(call, Collections.emptyList(), isConstant);
    }

    @Nullable
    private SymbolicExpression createSymbolicCallByNameWithArguments(@NotNull RPsiElement call, @NotNull List<SymbolicCall.SymbolicArgumentInfo> arguments, boolean isConstant) {
        if (call == null) {
            PsiParsingVisitor.$$$reportNull$$$0(38);
        }
        if (arguments == null) {
            PsiParsingVisitor.$$$reportNull$$$0(39);
        }
        if (CoreFqns.KERNEL_BLOCK_GIVEN.getShortName().equals(call.getName())) {
            return this.myProvider.getBlockGivenSymbolicExpression();
        }
        String name = call.getName();
        if (name != null) {
            return this.myProvider.createSymbolicCall(arguments, name, null, isConstant, !isConstant && RubyPsiUtil.isBlockGivenToPsiElement((PsiElement)call));
        }
        return null;
    }

    @Nullable
    private SymbolicCall createSymbolicCallByAssignmentWithArguments(@NotNull SymbolicExecutionContext context, @NotNull PsiElement call, @NotNull List<SymbolicCall.SymbolicArgumentInfo> arguments) {
        String name;
        RPsiElement receiver;
        if (context == null) {
            PsiParsingVisitor.$$$reportNull$$$0(40);
        }
        if (call == null) {
            PsiParsingVisitor.$$$reportNull$$$0(41);
        }
        if (arguments == null) {
            PsiParsingVisitor.$$$reportNull$$$0(42);
        }
        if (call instanceof RReference) {
            RReference reference = (RReference)call;
            receiver = reference.getReceiver();
            name = (String)ObjectUtils.doIfNotNull((Object)reference.getValue(), it -> it.getName());
        } else if (call instanceof RArrayIndexing) {
            RArrayIndexing indexing = (RArrayIndexing)call;
            receiver = indexing.getReceiver();
            name = "[]";
        } else {
            return null;
        }
        if (receiver == null || name == null) {
            return null;
        }
        SymbolicExpression receiverExpression = this.myProvider.getSymbolicExpression(receiver, context);
        return this.myProvider.createSymbolicCall(arguments, name + "=", receiverExpression, false, false);
    }

    @Nullable
    private SymbolicCall createSymbolicCallByRLambdaCallWithArguments(@NotNull RLambdaCall lambdaCall, @NotNull SymbolicExecutionContext context, @NotNull List<SymbolicCall.SymbolicArgumentInfo> arguments, boolean isBlockGiven) {
        RPsiElement receiver;
        if (lambdaCall == null) {
            PsiParsingVisitor.$$$reportNull$$$0(43);
        }
        if (context == null) {
            PsiParsingVisitor.$$$reportNull$$$0(44);
        }
        if (arguments == null) {
            PsiParsingVisitor.$$$reportNull$$$0(45);
        }
        if ((receiver = lambdaCall.getReceiver()) == null) {
            return null;
        }
        return this.myProvider.createSymbolicCall(arguments, "call", this.myProvider.getSymbolicExpression(receiver, context), false, isBlockGiven);
    }

    @Nullable
    private SymbolicCall createSymbolicCallByRReferenceWithArguments(@NotNull RReference reference, @NotNull SymbolicExecutionContext context, @NotNull List<SymbolicCall.SymbolicArgumentInfo> arguments, boolean isConstant, boolean isBlockGiven) {
        if (reference == null) {
            PsiParsingVisitor.$$$reportNull$$$0(46);
        }
        if (context == null) {
            PsiParsingVisitor.$$$reportNull$$$0(47);
        }
        if (arguments == null) {
            PsiParsingVisitor.$$$reportNull$$$0(48);
        }
        RPsiElement receiver = reference.getReceiver();
        RPsiElement value = reference.getValue();
        if (value == null || receiver == null || value.getName() == null) {
            return null;
        }
        String name = value.getName();
        SymbolicExpression expression = this.myProvider.getSymbolicExpression(receiver, context);
        return this.myProvider.createSymbolicCall(arguments, name, expression, isConstant, isBlockGiven);
    }

    @Nullable
    private SymbolicExpression createModifiedNumericConstant(@NotNull PsiElement modifier) {
        String content;
        if (modifier == null) {
            PsiParsingVisitor.$$$reportNull$$$0(49);
        }
        if ("i".equals(content = modifier.getText()) || "ri".equals(content)) {
            return this.myProvider.createTypedSymbolicExpression(SerializableTypeUtil.createFullyQualifiedType((String)"Complex"));
        }
        if ("r".equals(content)) {
            return this.myProvider.createTypedSymbolicExpression(SerializableTypeUtil.createFullyQualifiedType((String)"Rational"));
        }
        return null;
    }

    @NotNull
    private List<SymbolicCall.SymbolicArgumentInfo> createSymbolicArgumentInfo(@NotNull List<? extends RPsiElement> arguments) {
        if (arguments == null) {
            PsiParsingVisitor.$$$reportNull$$$0(50);
        }
        List list = ContainerUtil.map(arguments, it -> {
            String keyName;
            SymbolicExpression symbolicExpression;
            if (it instanceof RAssoc) {
                RPsiElement assocValue = ((RAssoc)it).getValue();
                symbolicExpression = assocValue != null ? this.myProvider.getSymbolicExpression(assocValue, this.myContext) : this.myProvider.createSymbolicVariable();
                keyName = ((RAssoc)it).getKeyText();
            } else {
                symbolicExpression = this.myProvider.getSymbolicExpression(it, this.myContext);
                keyName = "";
            }
            return new SymbolicCall.SymbolicArgumentInfo(ArgMapping.getIncomingType((PsiElement)it), keyName, symbolicExpression);
        });
        if (list == null) {
            PsiParsingVisitor.$$$reportNull$$$0(51);
        }
        return list;
    }

    private boolean handleClassModuleCallType(@NotNull RPossibleCall rPossibleCall) {
        RubyCallType callType;
        if (rPossibleCall == null) {
            PsiParsingVisitor.$$$reportNull$$$0(52);
        }
        if ((callType = rPossibleCall.getCallType()) instanceof ClassModuleCallType) {
            FQN fqn = ((ClassModuleCallType)callType).getClassModuleFQN(rPossibleCall);
            SerializableType type = AnonymousDefiningCallType.isAnonymousFQN((FQN)fqn) ? SerializableTypeUtil.createFullyQualifiedType((String)RObjectClass.makeSingletonClassFQN((FQN)fqn).getFullPath()) : SerializableTypeUtil.createQualifiedType((String)RObjectClass.makeSingletonClassFQN((FQN)fqn).getFullPath());
            this.myResult = this.myProvider.createTypedSymbolicExpression(type);
            return true;
        }
        return false;
    }

    @Nullable
    public static SymbolicExpression createSymbolicExpressionByPsiElement(@NotNull RPsiElement psiElement, @NotNull SymbolicExpressionProvider provider, @NotNull SymbolicExecutionContext context) {
        if (psiElement == null) {
            PsiParsingVisitor.$$$reportNull$$$0(53);
        }
        if (provider == null) {
            PsiParsingVisitor.$$$reportNull$$$0(54);
        }
        if (context == null) {
            PsiParsingVisitor.$$$reportNull$$$0(55);
        }
        PsiParsingVisitor visitor = new PsiParsingVisitor(context, provider);
        psiElement.accept((PsiElementVisitor)visitor);
        return visitor.myResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 51 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBodyStatement";
                break;
            }
            case 1: 
            case 35: 
            case 40: 
            case 44: 
            case 47: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupedExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rTopConstReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rConstant";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rGlobalVariable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rInstanceVariable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClassVariable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayIndexing";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIdentifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFid";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ternaryExpression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBoolBinExpression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPseudoConstant";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unaryExpression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBoolNegExpression";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rYieldStatement";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBeginEndBlockStatement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIntegerConstant";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFloatConstant";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
            case 27: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaCall";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rReference";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockCall";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rStringLiteral";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rDStringLiteral";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rSymbol";
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 36: 
            case 39: 
            case 42: 
            case 45: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/visitors/PsiParsingVisitor";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPossibleCall";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/visitors/PsiParsingVisitor";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createSymbolicArgumentInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitRBodyStatement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitGroupedExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitRTopConstReference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitRConstant";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitRGlobalVariable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitRInstanceVariable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitRClassVariable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitRArrayIndexing";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitRIdentifier";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitRCondition";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitRFid";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitRCodeBlock";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitRAssignmentExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitRArray";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitRTernaryExpression";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitRBoolBinExpression";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitRBoolMatchingExpression";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitRPseudoConstant";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitRUnaryExpression";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitRBoolNegExpression";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitRYieldStatement";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitRBeginEndBlockStatement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitRIntegerConstant";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitRFloatConstant";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitRCall";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitRLambdaCall";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitRBinaryExpression";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitRReference";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitRBlockCall";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitRStringLiteral";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitRDStringLiteral";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitRSymbol";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolicCallWithArguments";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolicCallByName";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolicCallByNameWithArguments";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolicCallByAssignmentWithArguments";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolicCallByRLambdaCallWithArguments";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolicCallByRReferenceWithArguments";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createModifiedNumericConstant";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolicArgumentInfo";
                break;
            }
            case 51: {
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "handleClassModuleCallType";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolicExpressionByPsiElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 51 -> new IllegalStateException(string);
        };
    }
}

