/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.visitors;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.BinarySymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.BinarySymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.DestructedInAssignmentSymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.DestructedInAssignmentSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.LocalSymbolicVariable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.MergedSymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.MergedSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.NegationSymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.NegationSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.PhiSymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.PhiSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicCall;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpressionBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpressionVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.ValueSymbolicExpression;

public final class MigrationVisitor
extends SymbolicExpressionVisitor<SymbolicExpression> {
    private final Map<SymbolicExpression, SymbolicExpression> myMigrationMap;
    private final SymbolicExpressionProvider myNewProvider;

    private MigrationVisitor(Map<SymbolicExpression, SymbolicExpression> migrationMap, SymbolicExpressionProvider newProvider) {
        this.myMigrationMap = migrationMap;
        this.myNewProvider = newProvider;
    }

    public SymbolicExpression visitSymbolicExpression(@NotNull SymbolicExpression symbolicExpression) {
        if (symbolicExpression == null) {
            MigrationVisitor.$$$reportNull$$$0(0);
        }
        throw new IllegalArgumentException(String.valueOf(symbolicExpression) + " is not supported");
    }

    public SymbolicExpression visitLocalSymbolicExpression(@NotNull LocalSymbolicVariable localSymbolicVariable) {
        SymbolicExpression expression;
        if (localSymbolicVariable == null) {
            MigrationVisitor.$$$reportNull$$$0(1);
        }
        if ((expression = this.myMigrationMap.get(localSymbolicVariable)) == null) {
            expression = this.myNewProvider.createSymbolicVariable();
            MigrationVisitor.copyAttributes(expression, (SymbolicExpression)localSymbolicVariable);
        }
        return expression;
    }

    public SymbolicExpression visitNegationSymbolicExpression(@NotNull NegationSymbolicExpression negationSymbolicExpression) {
        if (negationSymbolicExpression == null) {
            MigrationVisitor.$$$reportNull$$$0(2);
        }
        SymbolicExpression expression = this.myNewProvider.createExpression(id -> new NegationSymbolicExpressionImpl(id, this.myMigrationMap.get(negationSymbolicExpression.getOperand())));
        MigrationVisitor.copyAttributes(expression, (SymbolicExpression)negationSymbolicExpression);
        return expression;
    }

    public SymbolicExpression visitBinarySymbolicExpression(@NotNull BinarySymbolicExpression binarySymbolicExpression) {
        if (binarySymbolicExpression == null) {
            MigrationVisitor.$$$reportNull$$$0(3);
        }
        SymbolicExpression expression = this.myNewProvider.createExpression(id -> new BinarySymbolicExpressionImpl(id, this.myMigrationMap.get(binarySymbolicExpression.getLeftOperand()), this.myMigrationMap.get(binarySymbolicExpression.getRightOperand()), binarySymbolicExpression.getOperationKind()));
        MigrationVisitor.copyAttributes(expression, (SymbolicExpression)binarySymbolicExpression);
        return expression;
    }

    public SymbolicExpression visitSymbolicCall(@NotNull SymbolicCall symbolicCall) {
        if (symbolicCall == null) {
            MigrationVisitor.$$$reportNull$$$0(4);
        }
        List list = symbolicCall.getArguments().stream().map(it -> new SymbolicCall.SymbolicArgumentInfo(it.getType(), it.getKeyName(), this.myMigrationMap.get(it.getExpression()))).collect(Collectors.toList());
        SymbolicCall call = this.myNewProvider.createSymbolicCall(list, symbolicCall.getName(), symbolicCall.getReceiver() == null ? null : this.myMigrationMap.get(symbolicCall.getReceiver()), symbolicCall.isConstant(), symbolicCall.isBlockGiven());
        MigrationVisitor.copyAttributes((SymbolicExpression)call, (SymbolicExpression)symbolicCall);
        return call;
    }

    public SymbolicExpression visitMergedSymbolicExpression(@NotNull MergedSymbolicExpression mergedSymbolicExpression) {
        if (mergedSymbolicExpression == null) {
            MigrationVisitor.$$$reportNull$$$0(5);
        }
        SymbolicExpression expression = this.myNewProvider.createExpression(id -> MergedSymbolicExpressionImpl.fromList((SymbolicExpression.IdSupplier)id, (List)ContainerUtil.map((Collection)mergedSymbolicExpression.getComponents(), this.myMigrationMap::get)));
        MigrationVisitor.copyAttributes(expression, (SymbolicExpression)mergedSymbolicExpression);
        return expression;
    }

    @Nullable
    public SymbolicExpression visitPhiSymbolicExpression(@NotNull PhiSymbolicExpression phiSymbolicExpression) {
        if (phiSymbolicExpression == null) {
            MigrationVisitor.$$$reportNull$$$0(6);
        }
        SymbolicExpression expression = this.myNewProvider.createExpression(id -> new PhiSymbolicExpressionImpl(id, this.myMigrationMap.get(phiSymbolicExpression.getCondition()), this.myMigrationMap.get(phiSymbolicExpression.getThenSymbolicExpression()), this.myMigrationMap.get(phiSymbolicExpression.getElseSymbolicExpression())));
        MigrationVisitor.copyAttributes(expression, (SymbolicExpression)phiSymbolicExpression);
        return expression;
    }

    @Nullable
    public SymbolicExpression visitDestructedInAssignmentSymbolicExpression(@NotNull DestructedInAssignmentSymbolicExpression symbolicExpression) {
        if (symbolicExpression == null) {
            MigrationVisitor.$$$reportNull$$$0(7);
        }
        SymbolicExpression expression = this.myNewProvider.createExpression(id -> new DestructedInAssignmentSymbolicExpressionImpl(id, this.myMigrationMap.get(symbolicExpression.getRhs()), symbolicExpression.getLhsIndex()));
        MigrationVisitor.copyAttributes(expression, (SymbolicExpression)symbolicExpression);
        return expression;
    }

    @Nullable
    public <V> SymbolicExpression visitValueSymbolicExpression(@NotNull ValueSymbolicExpression<V> symbolicExpression) {
        if (symbolicExpression == null) {
            MigrationVisitor.$$$reportNull$$$0(8);
        }
        SymbolicExpression expression = this.myNewProvider.createExpression(id -> symbolicExpression.builder().newInstance(id, symbolicExpression.getValue()));
        MigrationVisitor.copyAttributes(expression, symbolicExpression);
        return expression;
    }

    @NotNull
    public static SymbolicExpression migrate(@NotNull SymbolicExpression calleeSymbolicExpression, @NotNull Map<SymbolicExpression, SymbolicExpression> migrationMap, @NotNull SymbolicExpressionProvider newProvider) {
        if (calleeSymbolicExpression == null) {
            MigrationVisitor.$$$reportNull$$$0(9);
        }
        if (migrationMap == null) {
            MigrationVisitor.$$$reportNull$$$0(10);
        }
        if (newProvider == null) {
            MigrationVisitor.$$$reportNull$$$0(11);
        }
        SymbolicExpression symbolicExpression = (SymbolicExpression)calleeSymbolicExpression.accept((SymbolicExpressionVisitor)new MigrationVisitor(migrationMap, newProvider));
        if (symbolicExpression == null) {
            MigrationVisitor.$$$reportNull$$$0(12);
        }
        return symbolicExpression;
    }

    private static void copyAttributes(@NotNull SymbolicExpression destination, @NotNull SymbolicExpression source) {
        if (destination == null) {
            MigrationVisitor.$$$reportNull$$$0(13);
        }
        if (source == null) {
            MigrationVisitor.$$$reportNull$$$0(14);
        }
        if (destination instanceof SymbolicExpressionBase && source instanceof SymbolicExpressionBase) {
            ((SymbolicExpressionBase)destination).copyAttributes((SymbolicExpressionBase)source);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolicExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSymbolicVariable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "negationSymbolicExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binarySymbolicExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolicCall";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedSymbolicExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phiSymbolicExpression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleeSymbolicExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "migrationMap";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/visitors/MigrationVisitor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/visitors/MigrationVisitor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "migrate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitSymbolicExpression";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitLocalSymbolicExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitNegationSymbolicExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitBinarySymbolicExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitSymbolicCall";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitMergedSymbolicExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitPhiSymbolicExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitDestructedInAssignmentSymbolicExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitValueSymbolicExpression";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "migrate";
                break;
            }
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyAttributes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

