/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression;

import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.ArrayValueSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.BinarySymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.BooleanValueSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.DestructedInAssignmentSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.IntegerValueSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.LocalSymbolicVariableImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.MergedSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.NegationSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.PhiSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicCallImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpressionSerializationHelper;

public final class SymbolicExpressionUtil {
    private static final Map<Integer, SymbolicExpressionSerializationHelper<?>> ourId2SymbolicExpressionSerializationHelper = new HashMap();
    private static final Map<SymbolicExpressionSerializationHelper<?>, Integer> ourSymbolicExpressionSerializationHelper2Id = new HashMap();

    public static void serialize(@NotNull Collection<? extends SymbolicExpression> symbolicExpressions, @NotNull StubOutputStream outputStream) throws IOException {
        if (symbolicExpressions == null) {
            SymbolicExpressionUtil.$$$reportNull$$$0(0);
        }
        if (outputStream == null) {
            SymbolicExpressionUtil.$$$reportNull$$$0(1);
        }
        List<SymbolicExpression> expressions = SymbolicExpressionUtil.getTopologicallySortedExpressions(symbolicExpressions);
        outputStream.writeVarInt(expressions.size());
        for (SymbolicExpression expression : expressions) {
            int typeId = ourSymbolicExpressionSerializationHelper2Id.get(expression.getSerializationHelper());
            outputStream.writeVarInt(typeId);
            SymbolicExpressionUtil.serializeExpression(outputStream, expression.getSerializationHelper(), expression);
        }
    }

    public static Map<Integer, SymbolicExpression> deserialize(@NotNull StubInputStream inputStream) throws IOException {
        if (inputStream == null) {
            SymbolicExpressionUtil.$$$reportNull$$$0(2);
        }
        HashMap<Integer, SymbolicExpression> id2symbolicExpression = new HashMap<Integer, SymbolicExpression>();
        int size = inputStream.readVarInt();
        for (int i = 0; i < size; ++i) {
            int typeId = inputStream.readVarInt();
            SymbolicExpressionSerializationHelper<?> type = ourId2SymbolicExpressionSerializationHelper.get(typeId);
            SymbolicExpression expression = type.deserialize(inputStream, id2symbolicExpression);
            id2symbolicExpression.put(expression.getId(), expression);
        }
        return id2symbolicExpression;
    }

    @NotNull
    public static SymbolicExpression deserializeLastExpression(@NotNull StubInputStream inputStream) throws IOException {
        if (inputStream == null) {
            SymbolicExpressionUtil.$$$reportNull$$$0(3);
        }
        SymbolicExpression symbolicExpression = SymbolicExpressionUtil.deserialize(inputStream).entrySet().stream().max(Map.Entry.comparingByKey()).map(Map.Entry::getValue).orElseThrow(() -> new IOException("Symbolic expression list cannot be empty. Index seems to be corrupted"));
        if (symbolicExpression == null) {
            SymbolicExpressionUtil.$$$reportNull$$$0(4);
        }
        return symbolicExpression;
    }

    @NotNull
    public static List<SymbolicExpression> getTopologicallySortedExpressions(@NotNull Collection<? extends SymbolicExpression> symbolicExpressions) {
        if (symbolicExpressions == null) {
            SymbolicExpressionUtil.$$$reportNull$$$0(5);
        }
        ArrayList<SymbolicExpression> expressions = new ArrayList<SymbolicExpression>(SymbolicExpressionUtil.getAllSymbolicExpression(symbolicExpressions));
        expressions.sort(Comparator.comparingInt(SymbolicExpression::getId));
        ArrayList<SymbolicExpression> arrayList = expressions;
        if (arrayList == null) {
            SymbolicExpressionUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static Set<SymbolicExpression> getAllSymbolicExpression(@NotNull Collection<? extends SymbolicExpression> expressions) {
        if (expressions == null) {
            SymbolicExpressionUtil.$$$reportNull$$$0(7);
        }
        HashSet<SymbolicExpression> visited = new HashSet<SymbolicExpression>();
        ArrayDeque<SymbolicExpression> queue = new ArrayDeque<SymbolicExpression>();
        for (SymbolicExpression symbolicExpression : expressions) {
            if (!visited.add(symbolicExpression)) continue;
            queue.add(symbolicExpression);
        }
        while (!queue.isEmpty()) {
            SymbolicExpression currExpression = (SymbolicExpression)queue.remove();
            for (SymbolicExpression expression : currExpression.getChildren()) {
                if (!visited.add(expression)) continue;
                queue.add(expression);
            }
        }
        return visited;
    }

    private static <T extends SymbolicExpression> void serializeExpression(@NotNull StubOutputStream outputStream, SymbolicExpressionSerializationHelper<T> helper, SymbolicExpression expression) throws IOException {
        if (outputStream == null) {
            SymbolicExpressionUtil.$$$reportNull$$$0(8);
        }
        helper.serialize(expression, outputStream);
    }

    private static void registerSymbolicExpressionType(SymbolicExpressionSerializationHelper<?> symbolicExpressionSerializationHelper) {
        int id = ourSymbolicExpressionSerializationHelper2Id.size();
        ourId2SymbolicExpressionSerializationHelper.put(id, symbolicExpressionSerializationHelper);
        ourSymbolicExpressionSerializationHelper2Id.put(symbolicExpressionSerializationHelper, id);
    }

    static {
        SymbolicExpressionUtil.registerSymbolicExpressionType(SymbolicCallImpl.SymbolicCallSerializationHelper.INSTANCE);
        SymbolicExpressionUtil.registerSymbolicExpressionType(LocalSymbolicVariableImpl.LocalSymbolicVariableSerializationHelper.INSTANCE);
        SymbolicExpressionUtil.registerSymbolicExpressionType(MergedSymbolicExpressionImpl.MergedSymbolicExpressionSerializationHelper.INSTANCE);
        SymbolicExpressionUtil.registerSymbolicExpressionType(NegationSymbolicExpressionImpl.NegationSymbolicExpressionSerializationHelper.INSTANCE);
        SymbolicExpressionUtil.registerSymbolicExpressionType(BinarySymbolicExpressionImpl.BinarySymbolicExpressionSerializationHelper.INSTANCE);
        SymbolicExpressionUtil.registerSymbolicExpressionType(PhiSymbolicExpressionImpl.PhiSymbolicExpressionSerializationHelper.INSTANCE);
        SymbolicExpressionUtil.registerSymbolicExpressionType(DestructedInAssignmentSymbolicExpressionImpl.DestructedInAssignmentSymbolicExpressionSerializationHelper.INSTANCE);
        SymbolicExpressionUtil.registerSymbolicExpressionType(IntegerValueSymbolicExpressionImpl.IntegerValueSymbolicExpressionSerializationHelper.INSTANCE);
        SymbolicExpressionUtil.registerSymbolicExpressionType(BooleanValueSymbolicExpressionImpl.BooleanValueSymbolicExpressionSerializationHelper.INSTANCE);
        SymbolicExpressionUtil.registerSymbolicExpressionType(ArrayValueSymbolicExpressionImpl.ArrayValueSymbolicExpressionSerializationHelper.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolicExpressions";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/symbolicExpression/SymbolicExpressionUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/symbolicExpression/SymbolicExpressionUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeLastExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopologicallySortedExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserializeLastExpression";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTopologicallySortedExpressions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllSymbolicExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serializeExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

