/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.MutableLocalMemory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.MutableLocalMemoryImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicContextComponent;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContextImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProviderCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.attribute.TypeAttribute;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.SymbolicProviderInstance;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.DestructedInAssignmentSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.MergedSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.attribute.AttributeKey;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.AssignAccess;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.ParameterAccess;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.instructions.ReadWriteInstruction;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.arguments.RArgumentNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;

public abstract class SymbolicContextInstance
extends SymbolicProviderInstance<SymbolicExecutionContext> {
    public SymbolicContextInstance(@NotNull SymbolicExpressionProvider symbolicExpressionProvider) {
        if (symbolicExpressionProvider == null) {
            SymbolicContextInstance.$$$reportNull$$$0(0);
        }
        super(symbolicExpressionProvider);
    }

    @NotNull
    public SymbolicExecutionContext join(@NotNull SymbolicExecutionContext lhs, @NotNull SymbolicExecutionContext rhs, @NotNull SymbolicExpressionProvider methodContext) {
        if (lhs == null) {
            SymbolicContextInstance.$$$reportNull$$$0(1);
        }
        if (rhs == null) {
            SymbolicContextInstance.$$$reportNull$$$0(2);
        }
        if (methodContext == null) {
            SymbolicContextInstance.$$$reportNull$$$0(3);
        }
        SymbolicExecutionContext symbolicExecutionContext = lhs.join(rhs);
        if (symbolicExecutionContext == null) {
            SymbolicContextInstance.$$$reportNull$$$0(4);
        }
        return symbolicExecutionContext;
    }

    public void fun(SymbolicExecutionContext context, SymbolicExpressionProvider methodContext, Instruction instruction) {
        PsiElement element = instruction.getElement();
        if (element instanceof RCompoundStatement) {
            this.analyzeCompoundStatement(context, instruction, (RCompoundStatement)element);
        }
        if (instruction instanceof ReadWriteInstruction) {
            Access access = ((ReadWriteInstruction)instruction).getAccess();
            if (access instanceof AssignAccess) {
                this.processAssignAccess(context, (ReadWriteInstruction)instruction, (AssignAccess)access);
            }
            if (access instanceof ParameterAccess) {
                this.processArgument(RArgumentNavigator.getByParameter((RPsiElement)access.getElement()), context);
            }
        }
    }

    @NotNull
    public SymbolicExecutionContext copy(@NotNull SymbolicExecutionContext context) {
        if (context == null) {
            SymbolicContextInstance.$$$reportNull$$$0(5);
        }
        SymbolicExecutionContext symbolicExecutionContext = context.copy();
        if (symbolicExecutionContext == null) {
            SymbolicContextInstance.$$$reportNull$$$0(6);
        }
        return symbolicExecutionContext;
    }

    @NotNull
    public SymbolicExecutionContext initialContext() {
        return new SymbolicExecutionContextImpl(new MutableLocalMemoryImpl(this.mySymbolicExpressionProvider), this.createComponents());
    }

    @NotNull
    protected abstract List<SymbolicContextComponent> createComponents();

    private void processAssignAccess(@NotNull SymbolicExecutionContext context, @NotNull ReadWriteInstruction instruction, @NotNull AssignAccess access) {
        RPsiElement rhs;
        if (context == null) {
            SymbolicContextInstance.$$$reportNull$$$0(7);
        }
        if (instruction == null) {
            SymbolicContextInstance.$$$reportNull$$$0(8);
        }
        if (access == null) {
            SymbolicContextInstance.$$$reportNull$$$0(9);
        }
        if ((rhs = access.getValue()) == null) {
            return;
        }
        MutableLocalMemory memory = context.getLocalMemory();
        SymbolicExpression rhsSymbolicExpression = this.mySymbolicExpressionProvider.getSymbolicExpression(rhs, context);
        if (access.isMultiLhs() && !access.isMultiRhs()) {
            SymbolicExpression rhsDestructed = this.mySymbolicExpressionProvider.createExpression(id -> new DestructedInAssignmentSymbolicExpressionImpl(id, rhsSymbolicExpression, access.getLhsIndex()));
            memory.writeLocalValue(instruction.getName(), rhsDestructed);
            this.mySymbolicExpressionProvider.setSymbolicExpression(access.getLhs(), rhsDestructed);
        } else {
            memory.writeLocalValue(instruction.getName(), rhsSymbolicExpression);
            this.mySymbolicExpressionProvider.setSymbolicExpression(access.getLhs(), rhsSymbolicExpression);
        }
    }

    private void processArgument(@Nullable RArgument argument, @NotNull SymbolicExecutionContext context) {
        if (context == null) {
            SymbolicContextInstance.$$$reportNull$$$0(10);
        }
        if (argument == null) {
            return;
        }
        SymbolicExpression expression = this.mySymbolicExpressionProvider.readAtEntryPoint(argument.getName());
        switch (argument.getType()) {
            case PREDEFINED: {
                if (argument.getValue() == null) break;
                this.mySymbolicExpressionProvider.writeAtEntryPoint(argument.getName(), this.mySymbolicExpressionProvider.getSymbolicExpression(argument.getValue(), context));
                break;
            }
            case HASH: {
                expression.setAttributeValue((AttributeKey)TypeAttribute.INSTANCE, (Object)SerializableTypeUtil.createFullyQualifiedType((String)"Hash"));
                break;
            }
            case ARRAY: {
                expression.setAttributeValue((AttributeKey)TypeAttribute.INSTANCE, (Object)SerializableTypeUtil.createFullyQualifiedType((String)"Array"));
                break;
            }
        }
    }

    private void analyzeCompoundStatement(@NotNull SymbolicExecutionContext context, @NotNull Instruction instruction, @NotNull RCompoundStatement statement) {
        RContainer parentContainer;
        List predecessors;
        if (context == null) {
            SymbolicContextInstance.$$$reportNull$$$0(11);
        }
        if (instruction == null) {
            SymbolicContextInstance.$$$reportNull$$$0(12);
        }
        if (statement == null) {
            SymbolicContextInstance.$$$reportNull$$$0(13);
        }
        SymbolicExpression symbolicExpression = !statement.getStatements().isEmpty() ? ((predecessors = instruction.allPred().stream().map(it -> (RPsiElement)it.getElement()).filter(Objects::nonNull).map(it -> this.mySymbolicExpressionProvider.getSymbolicExpression(it, context)).collect(Collectors.toList())).size() == 1 ? (SymbolicExpression)predecessors.get(0) : this.mySymbolicExpressionProvider.createExpression(id -> MergedSymbolicExpressionImpl.fromList((SymbolicExpression.IdSupplier)id, (List)predecessors))) : ((parentContainer = RubyPsiUtilCore.getParentContainer((PsiElement)statement)) instanceof RMethod || parentContainer instanceof RFile || parentContainer instanceof RClass || parentContainer instanceof RCodeBlock ? SymbolicExpressionProviderCore.EMPTY_METHOD_SYMBOLIC_EXPRESSION : this.mySymbolicExpressionProvider.getNilSymbolicExpression());
        this.mySymbolicExpressionProvider.setSymbolicExpression((RPsiElement)statement, symbolicExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolicExpressionProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lhs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rhs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodContext";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/instance/SymbolicContextInstance";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/instance/SymbolicContextInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processAssignAccess";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processArgument";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "analyzeCompoundStatement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

