/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.attribute.TypeAttribute;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.attribute.AttributeKey;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public class SummaryTypeInferenceVisitor
extends RubyElementVisitor {
    @Nullable
    private SymbolicExpression myResult;
    @NotNull
    private final SymbolicExpressionProvider myProvider;
    @NotNull
    private final SymbolicExecutionContext myContext;

    public SummaryTypeInferenceVisitor(@NotNull SymbolicExpressionProvider provider, @NotNull SymbolicExecutionContext context) {
        if (provider == null) {
            SummaryTypeInferenceVisitor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SummaryTypeInferenceVisitor.$$$reportNull$$$0(1);
        }
        this.myResult = null;
        this.myProvider = provider;
        this.myContext = context;
    }

    public void visitRArray(@NotNull RArray array) {
        if (array == null) {
            SummaryTypeInferenceVisitor.$$$reportNull$$$0(2);
        }
        List<SerializableType> elementTypes = this.getCollectionElementTypes(array.getElementsIterator());
        this.myResult = this.myProvider.createTypedSymbolicExpression(SerializableTypeUtil.createCollectionType((SerializableType)SerializableTypeUtil.createFullyQualifiedType((String)"Array"), elementTypes));
    }

    public void visitRAssocList(@NotNull RAssocList rAssocList) {
        if (rAssocList == null) {
            SummaryTypeInferenceVisitor.$$$reportNull$$$0(3);
        }
        Pair<SerializableType, SerializableType> elementTypes = this.getHashElementType(RubyPsiUtilCore.getChildrenIterator((PsiElement)rAssocList, RAssoc.class));
        this.myResult = this.myProvider.createTypedSymbolicExpression(SerializableTypeUtil.createHashType((SerializableType)SerializableTypeUtil.createFullyQualifiedType((String)"Hash"), (SerializableType)((SerializableType)elementTypes.first), (SerializableType)((SerializableType)elementTypes.second)));
    }

    @Nullable
    public static SymbolicExpression createSymbolicExpressionByPsiElement(@NotNull RPsiElement psiElement, @NotNull SymbolicExpressionProvider provider, @NotNull SymbolicExecutionContext context) {
        if (psiElement == null) {
            SummaryTypeInferenceVisitor.$$$reportNull$$$0(4);
        }
        if (provider == null) {
            SummaryTypeInferenceVisitor.$$$reportNull$$$0(5);
        }
        if (context == null) {
            SummaryTypeInferenceVisitor.$$$reportNull$$$0(6);
        }
        SummaryTypeInferenceVisitor visitor = new SummaryTypeInferenceVisitor(provider, context);
        psiElement.accept((PsiElementVisitor)visitor);
        return visitor.myResult;
    }

    @NotNull
    private List<SerializableType> getCollectionElementTypes(@NotNull Iterator<? extends RPsiElement> elementsIterator) {
        if (elementsIterator == null) {
            SummaryTypeInferenceVisitor.$$$reportNull$$$0(7);
        }
        ArrayList<SerializableType> elementTypes = new ArrayList<SerializableType>();
        for (int counter = 0; counter <= SummaryTypeInferenceVisitor.getMaxElementsNumberToAnalyze() && elementsIterator.hasNext(); ++counter) {
            RPsiElement arg = elementsIterator.next();
            SymbolicExpression type = this.myProvider.getSymbolicExpression(arg, this.myContext);
            elementTypes.add((SerializableType)ObjectUtils.coalesce((Object)((SerializableType)type.getAttributeValue((AttributeKey)TypeAttribute.INSTANCE)), (Object)SerializableTypeUtil.EMPTY));
        }
        ArrayList<SerializableType> arrayList = elementTypes;
        if (arrayList == null) {
            SummaryTypeInferenceVisitor.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private Pair<SerializableType, SerializableType> getHashElementType(@NotNull Iterator<? extends RAssoc> assocsIterator) {
        if (assocsIterator == null) {
            SummaryTypeInferenceVisitor.$$$reportNull$$$0(9);
        }
        SerializableType keyType = SerializableTypeUtil.EMPTY;
        SerializableType valueType = SerializableTypeUtil.EMPTY;
        for (int counter = 0; counter <= SummaryTypeInferenceVisitor.getMaxElementsNumberToAnalyze() && assocsIterator.hasNext(); ++counter) {
            SerializableType valueT;
            SerializableType keyT;
            RAssoc assoc = assocsIterator.next();
            RPsiElement key = assoc.getKey();
            RPsiElement value = assoc.getValue();
            if (key != null && (keyT = (SerializableType)this.myProvider.getSymbolicExpression(key, this.myContext).getAttributeValue((AttributeKey)TypeAttribute.INSTANCE)) != null) {
                keyType = keyT;
            }
            if (value != null && (valueT = (SerializableType)this.myProvider.getSymbolicExpression(value, this.myContext).getAttributeValue((AttributeKey)TypeAttribute.INSTANCE)) != null) {
                valueType = valueT;
            }
            if (keyType != SerializableTypeUtil.EMPTY && valueType != SerializableTypeUtil.EMPTY) break;
        }
        Pair pair = Pair.create((Object)keyType, (Object)valueType);
        if (pair == null) {
            SummaryTypeInferenceVisitor.$$$reportNull$$$0(10);
        }
        return pair;
    }

    public static int getMaxElementsNumberToAnalyze() {
        return Registry.intValue((String)"ruby.max.list.size.to.analyze", (int)120);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rAssocList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsIterator";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/instance/SummaryTypeInferenceVisitor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assocsIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/instance/SummaryTypeInferenceVisitor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectionElementTypes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitRArray";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitRAssocList";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolicExpressionByPsiElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionElementTypes";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHashElementType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10 -> new IllegalStateException(string);
        };
    }
}

