/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RControlFlow;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicContextComponent;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionEngineImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionResultImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProviderImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.attribute.StringValueAttribute;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.SummaryTypeInferenceVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.SymbolicContextInstance;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.SymbolicExecutionInstance;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.summary.Summary;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.summary.SummaryImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.MergedSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicCall;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.attribute.AttributeKey;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.InstructionGraphUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.RControlFlowUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RReturnStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RYieldStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RMethodBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;

public class SummaryBuilderInstance
extends SymbolicContextInstance {
    private static final int GRAPH_TOO_BIG = 5000;
    @NotNull
    private final ControlFlowHolder myScope;
    @NotNull
    private final Graph<Instruction> myGraph;

    public SummaryBuilderInstance(@NotNull ControlFlowHolder scope) {
        if (scope == null) {
            SummaryBuilderInstance.$$$reportNull$$$0(0);
        }
        super(new SymbolicExpressionProviderImpl((PsiElement)scope, scope.getProject()));
        this.myScope = scope;
        this.myGraph = RControlFlowUtil.getGraphWithoutRBlockCall((RControlFlow)this.myScope.getControlFlow());
    }

    @NotNull
    public Summary computeSummary(@NotNull SymbolicExecutionResult result) {
        if (result == null) {
            SummaryBuilderInstance.$$$reportNull$$$0(1);
        }
        SymbolicExpression returnValue = this.analyzeReturnInstructions(result);
        List<RArgument> argumentsList = SummaryBuilderInstance.getArguments(this.myScope);
        ArrayList<SymbolicExpression> argumentsExpressions = argumentsList.isEmpty() ? Collections.emptyList() : new ArrayList<SymbolicExpression>(argumentsList.size());
        for (RArgument argument : argumentsList) {
            argumentsExpressions.add(this.mySymbolicExpressionProvider.readAtEntryPoint(argument.getName()));
        }
        SymbolicExpressionProvider provider = result.getMethodContext();
        SmartList yields = new SmartList();
        Collection graphNodes = this.myGraph.getNodes();
        for (Instruction graphNode : graphNodes) {
            PsiElement psiElement = graphNode.getElement();
            if (!(psiElement instanceof RYieldStatement)) continue;
            RYieldStatement yieldStatement = (RYieldStatement)psiElement;
            yields.add((SymbolicCall)provider.getSymbolicExpression((RPsiElement)yieldStatement, (SymbolicExecutionContext)result.getInstruction2OutContext().get(graphNode)));
        }
        return new SummaryImpl(returnValue, argumentsExpressions, (List)yields);
    }

    @Contract(value="false -> !null")
    @Nullable
    public SymbolicExecutionResult performAnalysis(boolean checkGraphSize) {
        if (InstructionGraphUtil.isTooBig(this.myGraph)) {
            return SymbolicExecutionResultImpl.empty((SymbolicExpressionProvider)this.getMethodContext());
        }
        if (checkGraphSize && SummaryBuilderInstance.isGraphTooBig(this.myGraph)) {
            return null;
        }
        SymbolicExecutionEngineImpl engine = new SymbolicExecutionEngineImpl(this.myGraph, (SymbolicExecutionInstance)this);
        SymbolicExecutionResult result = engine.getResult();
        engine.performSymbolicExecution();
        return result;
    }

    @Override
    public void fun(@NotNull SymbolicExecutionContext context, @NotNull SymbolicExpressionProvider methodContext, @NotNull Instruction instruction) {
        if (context == null) {
            SummaryBuilderInstance.$$$reportNull$$$0(2);
        }
        if (methodContext == null) {
            SummaryBuilderInstance.$$$reportNull$$$0(3);
        }
        if (instruction == null) {
            SummaryBuilderInstance.$$$reportNull$$$0(4);
        }
        super.fun(context, methodContext, instruction);
        RPsiElement element = (RPsiElement)instruction.getElement();
        if (element == null) {
            return;
        }
        this.processInstruction(context, instruction, element);
    }

    @Override
    @NotNull
    protected List<SymbolicContextComponent> createComponents() {
        List<SymbolicContextComponent> list = Collections.emptyList();
        if (list == null) {
            SummaryBuilderInstance.$$$reportNull$$$0(5);
        }
        return list;
    }

    private void processInstruction(@NotNull SymbolicExecutionContext context, @NotNull Instruction instruction, @NotNull RPsiElement element) {
        if (context == null) {
            SummaryBuilderInstance.$$$reportNull$$$0(6);
        }
        if (instruction == null) {
            SummaryBuilderInstance.$$$reportNull$$$0(7);
        }
        if (element == null) {
            SummaryBuilderInstance.$$$reportNull$$$0(8);
        }
        if (element instanceof RPseudoConstant) {
            return;
        }
        SymbolicExpression symbolicExpression = SummaryTypeInferenceVisitor.createSymbolicExpressionByPsiElement(element, this.mySymbolicExpressionProvider, context);
        if (symbolicExpression != null) {
            this.mySymbolicExpressionProvider.setSymbolicExpression(element, symbolicExpression);
        }
    }

    @Nullable
    private SymbolicExpression analyzeReturnInstructions(@NotNull SymbolicExecutionResult result) {
        if (result == null) {
            SummaryBuilderInstance.$$$reportNull$$$0(9);
        }
        ArrayList<SymbolicExpression> variants = new ArrayList<SymbolicExpression>();
        List returns = RControlFlowUtil.findExitInstructions((ControlFlow)this.myScope.getControlFlow());
        for (Instruction instruction : returns) {
            Object values;
            SymbolicExecutionContext context = (SymbolicExecutionContext)result.getInstruction2OutContext().get(instruction);
            if (context == null) continue;
            PsiElement psiElement = instruction.getElement();
            if (psiElement instanceof RReturnStatement) {
                RReturnStatement returnStatement = (RReturnStatement)psiElement;
                values = returnStatement.getReturnValues();
                if (values.size() != 1) continue;
                RPsiElement element = (RPsiElement)values.get(0);
                SymbolicExpression expression = this.mySymbolicExpressionProvider.getSymbolicExpression(element, context);
                SummaryBuilderInstance.annotateReturnInstruction(expression, element);
                variants.add(expression);
                continue;
            }
            values = instruction.getElement();
            if (!(values instanceof RPsiElement)) continue;
            RPsiElement element = (RPsiElement)values;
            SymbolicExpression expression = this.mySymbolicExpressionProvider.getSymbolicExpression(element, context);
            SummaryBuilderInstance.annotateReturnInstruction(expression, element);
            variants.add(expression);
        }
        if (variants.isEmpty()) {
            return null;
        }
        return this.mySymbolicExpressionProvider.createExpression(id -> MergedSymbolicExpressionImpl.fromList((SymbolicExpression.IdSupplier)id, (List)variants));
    }

    private static void annotateReturnInstruction(@NotNull SymbolicExpression expression, @NotNull RPsiElement element) {
        String content;
        if (expression == null) {
            SummaryBuilderInstance.$$$reportNull$$$0(10);
        }
        if (element == null) {
            SummaryBuilderInstance.$$$reportNull$$$0(11);
        }
        if ((content = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)element)) != null && content.length() <= SummaryBuilderInstance.getRubyIndexStringLimit()) {
            expression.setAttributeValue((AttributeKey)StringValueAttribute.INSTANCE, (Object)content);
        }
    }

    @NotNull
    private static List<RArgument> getArguments(ControlFlowHolder scope) {
        RBlockArgumentList argumentList = null;
        if (scope instanceof RCodeBlock) {
            argumentList = ((RCodeBlock)scope).getBlockArguments();
        } else if (scope instanceof RMethodBase) {
            argumentList = ((RMethodBase)scope).getArgumentList();
        }
        List list = argumentList != null ? argumentList.getArguments() : Collections.emptyList();
        if (list == null) {
            SummaryBuilderInstance.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static boolean isGraphTooBig(@NotNull Graph<Instruction> graph) {
        if (graph == null) {
            SummaryBuilderInstance.$$$reportNull$$$0(13);
        }
        return InstructionGraphUtil.isTooBig(graph) || graph.getNodes().size() > SummaryBuilderInstance.getMaxSummaryGraphCfgSize();
    }

    public static int getRubyIndexStringLimit() {
        return Registry.intValue((String)"ruby.index.string.limit", (int)2000);
    }

    public static int getMaxSummaryGraphCfgSize() {
        return Registry.intValue((String)"ruby.summary.max.control.flow.size", (int)5000);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodContext";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/instance/SummaryBuilderInstance";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/instance/SummaryBuilderInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponents";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeSummary";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fun";
                break;
            }
            case 5: 
            case 12: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processInstruction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "analyzeReturnInstructions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "annotateReturnInstruction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isGraphTooBig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 12 -> new IllegalStateException(string);
        };
    }
}

