/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicTypeInferenceProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.TypeInferenceComponent;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.TypeInferenceInstance;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicCall;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.CoreFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RFrozenType;

public final class RubyFrozenTypeSymbolicTypeInferenceProvider
implements SymbolicTypeInferenceProvider {
    private static final Set<FQN> IMMUTABLE_TYPE_FQNS = Set.of(CoreFqns.INTEGER, CoreFqns.FLOAT, CoreFqns.SYMBOL);
    private static final String DUP_COMMAND = "dup";
    private static final String FREEZE_COMMAND = "freeze";
    private static final Set<String> STRING_FREEZE_COMMANDS = Set.of("-@", "dedup");
    private static final Set<String> STRING_UNFREEZE_COMMANDS = Set.of("+@");

    @Override
    @Nullable
    public SymbolicExpression evaluateSymbolicCall(@NotNull SymbolicExpressionProvider provider, @NotNull SymbolicExecutionContext context, @NotNull SymbolicCall symbolicCall, @NotNull TypeInferenceInstance.CallContext callContext) {
        SymbolicExpression receiver;
        TypeInferenceComponent component;
        RType receiverType;
        if (provider == null) {
            RubyFrozenTypeSymbolicTypeInferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RubyFrozenTypeSymbolicTypeInferenceProvider.$$$reportNull$$$0(1);
        }
        if (symbolicCall == null) {
            RubyFrozenTypeSymbolicTypeInferenceProvider.$$$reportNull$$$0(2);
        }
        if (callContext == null) {
            RubyFrozenTypeSymbolicTypeInferenceProvider.$$$reportNull$$$0(3);
        }
        if (RTypeUtilCore.isNullOrEmpty((RType)(receiverType = SymbolicTypeInferenceProvider.getReceiverType(symbolicCall, component = (TypeInferenceComponent)context.getComponent(TypeInferenceComponent.class), callContext)))) {
            return null;
        }
        String command = symbolicCall.getName();
        if (command.equals(FREEZE_COMMAND) && (receiver = symbolicCall.getReceiver()) != null) {
            return RubyFrozenTypeSymbolicTypeInferenceProvider.evaluateFreezeCall(context, receiver, receiverType);
        }
        if (command.equals(DUP_COMMAND)) {
            return RubyFrozenTypeSymbolicTypeInferenceProvider.evaluateUnfreezeCall(context, provider.createSymbolicVariable(), receiverType);
        }
        if (RTypeUtil.isStringType(receiverType)) {
            if (STRING_FREEZE_COMMANDS.contains(command)) {
                return RubyFrozenTypeSymbolicTypeInferenceProvider.evaluateFreezeCall(context, provider.createSymbolicVariable(), receiverType);
            }
            if (STRING_UNFREEZE_COMMANDS.contains(command)) {
                return RubyFrozenTypeSymbolicTypeInferenceProvider.evaluateUnfreezeCall(context, provider.createSymbolicVariable(), receiverType);
            }
        }
        return null;
    }

    @NotNull
    private static SymbolicExpression evaluateFreezeCall(@NotNull SymbolicExecutionContext context, @NotNull SymbolicExpression expression, @NotNull RType receiverType) {
        Symbol symbol;
        if (context == null) {
            RubyFrozenTypeSymbolicTypeInferenceProvider.$$$reportNull$$$0(4);
        }
        if (expression == null) {
            RubyFrozenTypeSymbolicTypeInferenceProvider.$$$reportNull$$$0(5);
        }
        if (receiverType == null) {
            RubyFrozenTypeSymbolicTypeInferenceProvider.$$$reportNull$$$0(6);
        }
        if ((symbol = RTypeUtilCore.getBirthTypeSymbol((RType)receiverType)) == null || IMMUTABLE_TYPE_FQNS.contains(symbol.getFQNWithNesting())) {
            context.withComponent(TypeInferenceComponent.class, it -> it.updateSymbolicExpressionType(expression, receiverType));
        } else {
            context.withComponent(TypeInferenceComponent.class, it -> it.updateSymbolicExpressionType(expression, (RType)new RFrozenType(RFrozenType.clearFrozenStatus(receiverType))));
        }
        SymbolicExpression symbolicExpression = expression;
        if (symbolicExpression == null) {
            RubyFrozenTypeSymbolicTypeInferenceProvider.$$$reportNull$$$0(7);
        }
        return symbolicExpression;
    }

    @NotNull
    private static SymbolicExpression evaluateUnfreezeCall(@NotNull SymbolicExecutionContext context, @NotNull SymbolicExpression expression, @NotNull RType receiverType) {
        if (context == null) {
            RubyFrozenTypeSymbolicTypeInferenceProvider.$$$reportNull$$$0(8);
        }
        if (expression == null) {
            RubyFrozenTypeSymbolicTypeInferenceProvider.$$$reportNull$$$0(9);
        }
        if (receiverType == null) {
            RubyFrozenTypeSymbolicTypeInferenceProvider.$$$reportNull$$$0(10);
        }
        context.withComponent(TypeInferenceComponent.class, it -> it.updateSymbolicExpressionType(expression, RFrozenType.clearFrozenStatus(receiverType)));
        SymbolicExpression symbolicExpression = expression;
        if (symbolicExpression == null) {
            RubyFrozenTypeSymbolicTypeInferenceProvider.$$$reportNull$$$0(11);
        }
        return symbolicExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolicCall";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callContext";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverType";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/instance/RubyFrozenTypeSymbolicTypeInferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/instance/RubyFrozenTypeSymbolicTypeInferenceProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateFreezeCall";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateUnfreezeCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSymbolicCall";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluateFreezeCall";
                break;
            }
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "evaluateUnfreezeCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 11 -> new IllegalStateException(string);
        };
    }
}

