/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.controlflow.ConditionalInstruction;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.NotNullFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.MutableLocalMemory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicContextComponent;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionTypeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.visitors.PsiTypeInferenceVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.visitors.SymbolicTypeInferenceVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.visitors.TypeInferenceUsagesVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyTypeProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.condition.Condition;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.condition.ConditionAnalyzer;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.condition.KindOfCondition;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.condition.RespondsToCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.instructions.ReadWriteInstruction;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;

public final class TypeInferenceComponent
implements SymbolicContextComponent,
SymbolicExpressionTypeHolder {
    @NotNull
    private final Map<SymbolicExpression, RType> myTypeMap;
    @NotNull
    private final SymbolicExpressionProvider mySymbolicExpressionProvider;

    public TypeInferenceComponent(@NotNull SymbolicExpressionProvider provider) {
        if (provider == null) {
            TypeInferenceComponent.$$$reportNull$$$0(0);
        }
        this.myTypeMap = new HashMap<SymbolicExpression, RType>();
        this.mySymbolicExpressionProvider = provider;
    }

    private TypeInferenceComponent(@NotNull Map<SymbolicExpression, RType> typeMap, @NotNull SymbolicExpressionProvider provider) {
        if (typeMap == null) {
            TypeInferenceComponent.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            TypeInferenceComponent.$$$reportNull$$$0(2);
        }
        this.myTypeMap = typeMap;
        this.mySymbolicExpressionProvider = provider;
    }

    @NotNull
    public SymbolicContextComponent copy() {
        return new TypeInferenceComponent(new HashMap<SymbolicExpression, RType>(this.myTypeMap), this.mySymbolicExpressionProvider);
    }

    @NotNull
    public SymbolicContextComponent join(@NotNull SymbolicContextComponent another) {
        if (another == null) {
            TypeInferenceComponent.$$$reportNull$$$0(3);
        }
        HashMap<SymbolicExpression, RType> jointTypeMap = new HashMap<SymbolicExpression, RType>();
        Map<SymbolicExpression, RType> anotherTypeMap = ((TypeInferenceComponent)another).myTypeMap;
        for (SymbolicExpression key : Sets.union(this.myTypeMap.keySet(), anotherTypeMap.keySet())) {
            RType anotherValue;
            RType myValue = this.myTypeMap.get(key);
            if (Objects.equals(myValue, anotherValue = anotherTypeMap.get(key))) {
                jointTypeMap.put(key, myValue);
                continue;
            }
            if (myValue == null) {
                jointTypeMap.put(key, anotherValue);
                continue;
            }
            if (anotherValue == null) {
                jointTypeMap.put(key, myValue);
                continue;
            }
            jointTypeMap.put(key, RTypeUtil.union(myValue, anotherValue));
        }
        return new TypeInferenceComponent(jointTypeMap, this.mySymbolicExpressionProvider);
    }

    public void fun(@NotNull SymbolicExecutionContext context, @NotNull SymbolicExpressionProvider methodContext, @NotNull Instruction instruction) {
        PsiElement psiElement;
        if (context == null) {
            TypeInferenceComponent.$$$reportNull$$$0(4);
        }
        if (methodContext == null) {
            TypeInferenceComponent.$$$reportNull$$$0(5);
        }
        if (instruction == null) {
            TypeInferenceComponent.$$$reportNull$$$0(6);
        }
        if (instruction instanceof ConditionalInstruction) {
            this.processDynamicChecks((ConditionalInstruction)instruction, context);
        }
        if (instruction instanceof ReadWriteInstruction) {
            this.processAccessOfReadWriteInstruction(context, (ReadWriteInstruction)instruction);
        }
        if ((psiElement = instruction.getElement()) instanceof RPsiElement) {
            RPsiElement element = (RPsiElement)psiElement;
            RType type = this.inferExpressionType(element, context);
            SymbolicExpression expression = this.mySymbolicExpressionProvider.getSymbolicExpression(element, context);
            if (type != REmptyType.INSTANCE) {
                this.myTypeMap.put(expression, type);
            }
        }
    }

    public void updateSymbolicExpressionType(@NotNull SymbolicExpression expression, @NotNull RType type) {
        if (expression == null) {
            TypeInferenceComponent.$$$reportNull$$$0(7);
        }
        if (type == null) {
            TypeInferenceComponent.$$$reportNull$$$0(8);
        }
        this.myTypeMap.put(expression, type);
    }

    @NotNull
    public RType getTypeForSymbolicExpression(@NotNull SymbolicExpression expression) {
        RType result;
        if (expression == null) {
            TypeInferenceComponent.$$$reportNull$$$0(9);
        }
        if ((result = this.myTypeMap.get(expression)) != null) {
            RType rType = result;
            if (rType == null) {
                TypeInferenceComponent.$$$reportNull$$$0(10);
            }
            return rType;
        }
        result = SymbolicTypeInferenceVisitor.computeType(expression, (NotNullFunction<SymbolicExpression, RType>)((NotNullFunction)it -> it.getType((SymbolicExpressionTypeHolder)this)), this.mySymbolicExpressionProvider);
        this.myTypeMap.put(expression, result);
        RType rType = result;
        if (rType == null) {
            TypeInferenceComponent.$$$reportNull$$$0(11);
        }
        return rType;
    }

    @NotNull
    public Project getProject() {
        Project project = this.mySymbolicExpressionProvider.getProject();
        if (project == null) {
            TypeInferenceComponent.$$$reportNull$$$0(12);
        }
        return project;
    }

    private void processAccessOfReadWriteInstruction(@NotNull SymbolicExecutionContext context, @NotNull ReadWriteInstruction instruction) {
        if (context == null) {
            TypeInferenceComponent.$$$reportNull$$$0(13);
        }
        if (instruction == null) {
            TypeInferenceComponent.$$$reportNull$$$0(14);
        }
        Access access = instruction.getAccess();
        String name = instruction.getName();
        MutableLocalMemory memory = context.getLocalMemory();
        if (StringUtil.isCapitalized((String)name) || StringUtil.startsWithChar((CharSequence)name, (char)'@') || StringUtil.startsWithChar((CharSequence)name, (char)'$')) {
            return;
        }
        SymbolicExpression expression = memory.readLocalValue(name);
        RPsiElement element = (RPsiElement)instruction.getElement();
        TypeInferenceUsagesVisitor.processAccess(access, expression, element, (NotNullFunction<RPsiElement, SymbolicExpression>)((NotNullFunction)e -> this.mySymbolicExpressionProvider.getSymbolicExpression(e, context)), (NotNullFunction<SymbolicExpression, RType>)((NotNullFunction)e -> e.getType((SymbolicExpressionTypeHolder)this)), this.myTypeMap);
    }

    private void processDynamicChecks(@NotNull ConditionalInstruction instruction, @NotNull SymbolicExecutionContext context) {
        boolean result;
        if (instruction == null) {
            TypeInferenceComponent.$$$reportNull$$$0(15);
        }
        if (context == null) {
            TypeInferenceComponent.$$$reportNull$$$0(16);
        }
        if (!(result = instruction.getResult())) {
            return;
        }
        PsiElement psiElement = instruction.getCondition();
        if (!(psiElement instanceof RPsiElement)) {
            return;
        }
        RPsiElement conditionElement = (RPsiElement)psiElement;
        Condition condition = ConditionAnalyzer.create((PsiElement)conditionElement);
        if (condition == null) {
            return;
        }
        SymbolicExpression expression = this.mySymbolicExpressionProvider.getSymbolicExpression(conditionElement, context);
        if (condition instanceof KindOfCondition) {
            expression = this.mySymbolicExpressionProvider.getSymbolicExpression(((KindOfCondition)condition).getReceiver(), context);
        } else if (condition instanceof RespondsToCondition) {
            expression = context.getLocalMemory().readLocalValue(((RespondsToCondition)condition).getReceiver());
        }
        TypeInferenceUsagesVisitor.processCondition(condition, expression, conditionElement, (NotNullFunction<RPsiElement, SymbolicExpression>)((NotNullFunction)e -> this.mySymbolicExpressionProvider.getSymbolicExpression(e, context)), (NotNullFunction<SymbolicExpression, RType>)((NotNullFunction)e -> e.getType((SymbolicExpressionTypeHolder)this)), this.myTypeMap);
    }

    @NotNull
    private RType inferExpressionType(@NotNull RPsiElement value, @NotNull SymbolicExecutionContext context) {
        if (value == null) {
            TypeInferenceComponent.$$$reportNull$$$0(17);
        }
        if (context == null) {
            TypeInferenceComponent.$$$reportNull$$$0(18);
        }
        if (!(value instanceof RExpression)) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                TypeInferenceComponent.$$$reportNull$$$0(19);
            }
            return rEmptyType;
        }
        RType type = RubyTypeProvider.createTypeByRExpressionFromProviders((RExpression)((RExpression)value));
        if (type != null) {
            RType rType = type;
            if (rType == null) {
                TypeInferenceComponent.$$$reportNull$$$0(20);
            }
            return rType;
        }
        SymbolicExpression symbolicExpression = this.mySymbolicExpressionProvider.getSymbolicExpression(value, context);
        type = symbolicExpression.getType((SymbolicExpressionTypeHolder)this);
        if (type != REmptyType.INSTANCE) {
            RType rType = type;
            if (rType == null) {
                TypeInferenceComponent.$$$reportNull$$$0(21);
            }
            return rType;
        }
        type = PsiTypeInferenceVisitor.getExpressionType((RExpression)value, expression -> this.inferExpressionType((RPsiElement)expression, context));
        if (type != REmptyType.INSTANCE) {
            RType rType = type;
            if (rType == null) {
                TypeInferenceComponent.$$$reportNull$$$0(22);
            }
            return rType;
        }
        REmptyType rEmptyType = REmptyType.INSTANCE;
        if (rEmptyType == null) {
            TypeInferenceComponent.$$$reportNull$$$0(23);
        }
        return rEmptyType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 19, 20, 21, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
            case 4: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodContext";
                break;
            }
            case 6: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/TypeInferenceComponent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/TypeInferenceComponent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeForSymbolicExpression";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "inferExpressionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fun";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateSymbolicExpressionType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForSymbolicExpression";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processAccessOfReadWriteInstruction";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processDynamicChecks";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "inferExpressionType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 19, 20, 21, 22, 23 -> new IllegalStateException(string);
        };
    }
}

