/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.controlflow.ConditionalInstruction;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.psi.PsiElement;
import com.intellij.util.ThreeState;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.MergedSymbolicExpressionInfo;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.NilAnalysisUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicContextComponent;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.attribute.NilAttribute;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.MergedSymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.attribute.AttributeKey;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.visitors.NilAnalysisConditionVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.visitors.PsiNilAnalysisVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;

public final class NilAnalysisComponent
implements SymbolicContextComponent {
    @NonNls
    public static final String NIL = "nil?";
    @NonNls
    public static final String BLANK = "blank?";
    @NonNls
    public static final String PRESENT = "present?";
    @NotNull
    private final Map<SymbolicExpression, ThreeState> myCanBeNil;
    @NotNull
    private final SymbolicExpressionProvider mySymbolicExpressionProvider;

    public NilAnalysisComponent(@NotNull SymbolicExpressionProvider provider) {
        if (provider == null) {
            NilAnalysisComponent.$$$reportNull$$$0(0);
        }
        this.myCanBeNil = new HashMap<SymbolicExpression, ThreeState>();
        this.mySymbolicExpressionProvider = provider;
    }

    private NilAnalysisComponent(@NotNull Map<SymbolicExpression, ThreeState> canBeNil, @NotNull SymbolicExpressionProvider provider) {
        if (canBeNil == null) {
            NilAnalysisComponent.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            NilAnalysisComponent.$$$reportNull$$$0(2);
        }
        this.myCanBeNil = canBeNil;
        this.mySymbolicExpressionProvider = provider;
    }

    public SymbolicContextComponent copy() {
        return new NilAnalysisComponent(new HashMap<SymbolicExpression, ThreeState>(this.myCanBeNil), this.mySymbolicExpressionProvider);
    }

    public SymbolicContextComponent join(@NotNull SymbolicContextComponent another) {
        if (another == null) {
            NilAnalysisComponent.$$$reportNull$$$0(3);
        }
        HashMap<SymbolicExpression, ThreeState> jointTypeMap = new HashMap<SymbolicExpression, ThreeState>();
        Map<SymbolicExpression, ThreeState> anotherTypeMap = ((NilAnalysisComponent)another).myCanBeNil;
        for (SymbolicExpression key : Sets.union(this.myCanBeNil.keySet(), anotherTypeMap.keySet())) {
            ThreeState myValue = this.myCanBeNil.get(key);
            ThreeState anotherValue = anotherTypeMap.get(key);
            jointTypeMap.put(key, NilAnalysisUtil.mergeCanBeNil(myValue, anotherValue));
        }
        return new NilAnalysisComponent(jointTypeMap, this.mySymbolicExpressionProvider);
    }

    public void processNewMergedSymbolicExpressions(@NotNull SymbolicContextComponent left, @NotNull SymbolicContextComponent right, @NotNull Collection<MergedSymbolicExpressionInfo> infoList) {
        if (left == null) {
            NilAnalysisComponent.$$$reportNull$$$0(4);
        }
        if (right == null) {
            NilAnalysisComponent.$$$reportNull$$$0(5);
        }
        if (infoList == null) {
            NilAnalysisComponent.$$$reportNull$$$0(6);
        }
        NilAnalysisComponent leftNil = (NilAnalysisComponent)left;
        NilAnalysisComponent rightNil = (NilAnalysisComponent)right;
        for (MergedSymbolicExpressionInfo info : infoList) {
            ThreeState myValue = leftNil.getCanBeNil(info.getLeft());
            ThreeState anotherValue = rightNil.getCanBeNil(info.getRight());
            SymbolicExpression expression = info.getJoint();
            this.myCanBeNil.put(expression, NilAnalysisUtil.mergeCanBeNil(myValue, anotherValue));
        }
    }

    public void fun(@NotNull SymbolicExecutionContext context, @NotNull SymbolicExpressionProvider symbolicExpressionProvider, @NotNull Instruction instruction) {
        PsiElement psiElement;
        if (context == null) {
            NilAnalysisComponent.$$$reportNull$$$0(7);
        }
        if (symbolicExpressionProvider == null) {
            NilAnalysisComponent.$$$reportNull$$$0(8);
        }
        if (instruction == null) {
            NilAnalysisComponent.$$$reportNull$$$0(9);
        }
        if (instruction instanceof ConditionalInstruction) {
            this.processCondition((ConditionalInstruction)instruction, context);
        }
        if ((psiElement = instruction.getElement()) instanceof RPsiElement) {
            RPsiElement element = (RPsiElement)psiElement;
            SymbolicExpression expression = this.mySymbolicExpressionProvider.getSymbolicExpression(element, context);
            this.processElement(element, expression, context);
        }
    }

    public void updateCanBeNil(@NotNull SymbolicExpression expression, @NotNull ThreeState canBeNil) {
        if (expression == null) {
            NilAnalysisComponent.$$$reportNull$$$0(10);
        }
        if (canBeNil == null) {
            NilAnalysisComponent.$$$reportNull$$$0(11);
        }
        this.myCanBeNil.put(expression, canBeNil);
    }

    @NotNull
    public ThreeState getCanBeNil(SymbolicExpression expression) {
        ThreeState canBeNil = this.myCanBeNil.get(expression);
        if (canBeNil != null) {
            ThreeState threeState = canBeNil;
            if (threeState == null) {
                NilAnalysisComponent.$$$reportNull$$$0(12);
            }
            return threeState;
        }
        canBeNil = (ThreeState)expression.getAttributeValue((AttributeKey)NilAttribute.INSTANCE);
        ThreeState threeState = canBeNil != null ? canBeNil : ThreeState.UNSURE;
        if (threeState == null) {
            NilAnalysisComponent.$$$reportNull$$$0(13);
        }
        return threeState;
    }

    private void processElement(@NotNull RPsiElement element, @NotNull SymbolicExpression expression, @NotNull SymbolicExecutionContext context) {
        if (element == null) {
            NilAnalysisComponent.$$$reportNull$$$0(14);
        }
        if (expression == null) {
            NilAnalysisComponent.$$$reportNull$$$0(15);
        }
        if (context == null) {
            NilAnalysisComponent.$$$reportNull$$$0(16);
        }
        if (element instanceof RReference) {
            this.processRReference((RReference)element, expression, context);
        } else if (element instanceof RCall) {
            RCall call = (RCall)element;
            this.processCall(call, expression, context);
        }
        if (this.myCanBeNil.containsKey(expression)) {
            return;
        }
        if (expression instanceof MergedSymbolicExpression) {
            ThreeState value = ThreeState.NO;
            for (SymbolicExpression component : ((MergedSymbolicExpression)expression).getComponents()) {
                value = NilAnalysisUtil.mergeCanBeNil(value, this.getCanBeNil(component));
            }
            this.myCanBeNil.put(expression, value);
            return;
        }
        ThreeState canBeNil = PsiNilAnalysisVisitor.getCanBeNil((PsiElement)element, elem -> this.getCanBeNil(this.mySymbolicExpressionProvider.getSymbolicExpression(elem, context)));
        this.myCanBeNil.put(expression, canBeNil);
    }

    private void processCondition(@NotNull ConditionalInstruction instruction, @NotNull SymbolicExecutionContext context) {
        if (instruction == null) {
            NilAnalysisComponent.$$$reportNull$$$0(17);
        }
        if (context == null) {
            NilAnalysisComponent.$$$reportNull$$$0(18);
        }
        if (!(instruction.getCondition() instanceof RPsiElement)) {
            return;
        }
        NilAnalysisConditionVisitor.processCondition(instruction, this.mySymbolicExpressionProvider, context, this.myCanBeNil);
    }

    private void processCall(@NotNull RCall call, @NotNull SymbolicExpression expression, @NotNull SymbolicExecutionContext context) {
        RDotReference reference;
        PsiElement command;
        if (call == null) {
            NilAnalysisComponent.$$$reportNull$$$0(19);
        }
        if (expression == null) {
            NilAnalysisComponent.$$$reportNull$$$0(20);
        }
        if (context == null) {
            NilAnalysisComponent.$$$reportNull$$$0(21);
        }
        if (!((command = call.getPsiCommand()) instanceof RDotReference) || !(reference = (RDotReference)command).isSafeNavigation()) {
            return;
        }
        RPsiElement receiver = reference.getReceiver();
        if (receiver == null) {
            return;
        }
        ThreeState canBeNil = this.getCanBeNil(this.mySymbolicExpressionProvider.getSymbolicExpression(receiver, context));
        if (canBeNil != ThreeState.NO) {
            this.myCanBeNil.put(expression, ThreeState.YES);
        }
    }

    private void processRReference(@NotNull RReference element, @NotNull SymbolicExpression expression, @NotNull SymbolicExecutionContext context) {
        RPsiElement receiver;
        if (element == null) {
            NilAnalysisComponent.$$$reportNull$$$0(22);
        }
        if (expression == null) {
            NilAnalysisComponent.$$$reportNull$$$0(23);
        }
        if (context == null) {
            NilAnalysisComponent.$$$reportNull$$$0(24);
        }
        if ((receiver = element.getReceiver()) != null) {
            if (element instanceof RDotReference && ((RDotReference)element).isSafeNavigation()) {
                ThreeState canBeNil = this.getCanBeNil(this.mySymbolicExpressionProvider.getSymbolicExpression(receiver, context));
                if (canBeNil != ThreeState.NO) {
                    this.myCanBeNil.put(expression, ThreeState.YES);
                }
            } else {
                SymbolicExpression prevExpression;
                SymbolicExpression receiverExpression;
                String command = element.getCommand();
                if (!NilAnalysisUtil.isClassMethod(element.getProject(), "NilClass", command) && (receiverExpression = NilAnalysisUtil.assignNewSymbolicExpressionIfNil(this.mySymbolicExpressionProvider, context, receiver, prevExpression = this.mySymbolicExpressionProvider.tryGetSymbolicExpression(receiver))) != null) {
                    this.myCanBeNil.put(receiverExpression, ThreeState.NO);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canBeNil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoList";
                break;
            }
            case 7: 
            case 16: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolicExpressionProvider";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 10: 
            case 15: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/NilAnalysisComponent";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/NilAnalysisComponent";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanBeNil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processNewMergedSymbolicExpressions";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fun";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateCanBeNil";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processCondition";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processCall";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processRReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13 -> new IllegalStateException(string);
        };
    }
}

