/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RubyResolveScopesUtil {
    private static final Key<CachedValue<GlobalSearchScope>> SCOPE_WITH_TESTS_KEY = Key.create((String)"SCOPE_WITH_TESTS");
    private static final Key<CachedValue<GlobalSearchScope>> SCOPE_WITHOUT_TESTS_KEY = Key.create((String)"SCOPE_WITHOUT_TESTS");

    private RubyResolveScopesUtil() {
    }

    @Nullable
    public static GlobalSearchScope getModuleResolveScope(@NotNull VirtualFile file, @NotNull Project project) {
        Module module;
        if (file == null) {
            RubyResolveScopesUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            RubyResolveScopesUtil.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) == null) {
            return null;
        }
        boolean includeTests = TestSourcesFilter.isTestSources((VirtualFile)file, (Project)project);
        return (GlobalSearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, includeTests ? SCOPE_WITH_TESTS_KEY : SCOPE_WITHOUT_TESTS_KEY, () -> CachedValueProvider.Result.create((Object)RubyResolveScopesUtil.getModuleResolveScope(module, includeTests), (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)project)}), false);
    }

    @NotNull
    private static GlobalSearchScope getModuleResolveScope(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            RubyResolveScopesUtil.$$$reportNull$$$0(2);
        }
        GlobalSearchScope moduleAndDependenciesScope = module.getModuleContentWithDependenciesScope();
        if (!includeTests) {
            moduleAndDependenciesScope = moduleAndDependenciesScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)module.getModuleTestSourceScope()));
        }
        GlobalSearchScope globalSearchScope = module.getModuleRuntimeScope(includeTests).union((SearchScope)moduleAndDependenciesScope);
        if (globalSearchScope == null) {
            RubyResolveScopesUtil.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/scopes/RubyResolveScopesUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/scopes/RubyResolveScopesUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleResolveScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleResolveScope";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

