/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.accessmodifier;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.accessmodifier.RemoveExplicitSelfQuickFix;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.accessmodifier.WrapCallWithSendQuickFix;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public enum AccessModifierProblem {
    PRIVATE_WITH_EXPLICIT_RECEIVER{

        @Override
        @NotNull
        public @NotNull List<? extends @NotNull LocalQuickFix> createQuickFixes(@NotNull PsiElement fullyQualifiedCall) {
            if (fullyQualifiedCall == null) {
                1.$$$reportNull$$$0(0);
            }
            if (!(fullyQualifiedCall instanceof RReference)) {
                List list = Collections.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }
            ArrayList<? extends LocalQuickFix> fixes = new ArrayList<LocalQuickFix>(super.createQuickFixes(fullyQualifiedCall));
            RPsiElement receiver = ((RReference)fullyQualifiedCall).getReceiver();
            if (receiver != null && "self".equals(receiver.getText())) {
                fixes.add((LocalQuickFix)new RemoveExplicitSelfQuickFix((RReference)fullyQualifiedCall));
            }
            ArrayList<? extends LocalQuickFix> arrayList = fixes;
            if (arrayList == null) {
                1.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullyQualifiedCall";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/resolve/accessmodifier/AccessModifierProblem$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/resolve/accessmodifier/AccessModifierProblem$1";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createQuickFixes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createQuickFixes";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
    ,
    PROTECTED_WITH_NOT_STRONG_ENOUGH_IMPLICIT_RECEIVER;


    @NotNull
    public @NotNull List<? extends @NotNull LocalQuickFix> createQuickFixes(@NotNull PsiElement fullyQualifiedCall) {
        if (fullyQualifiedCall == null) {
            AccessModifierProblem.$$$reportNull$$$0(0);
        }
        if (!(fullyQualifiedCall instanceof RReference)) {
            List list = Collections.emptyList();
            if (list == null) {
                AccessModifierProblem.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<WrapCallWithSendQuickFix> list = Collections.singletonList(new WrapCallWithSendQuickFix((RReference)fullyQualifiedCall));
        if (list == null) {
            AccessModifierProblem.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public static AccessModifierProblem calculateAccessModifierProblem(@NotNull RMethodSymbol resolvedSymbol, @Nullable RType invocationPointImplicitReceiverType, @Nullable RType invocationPointExplicitReceiverType, @Nullable RPsiElement explicitReceiver) {
        if (resolvedSymbol == null) {
            AccessModifierProblem.$$$reportNull$$$0(3);
        }
        if (explicitReceiver == null) {
            return null;
        }
        Visibility visibility = resolvedSymbol.getVisibility();
        if (visibility == Visibility.PUBLIC) {
            return null;
        }
        if (visibility == Visibility.PROTECTED) {
            if (RTypeUtilCore.isNotEmpty((RType)invocationPointExplicitReceiverType) && RTypeUtilCore.isNotEmpty((RType)invocationPointImplicitReceiverType) && invocationPointExplicitReceiverType.equals((Object)invocationPointImplicitReceiverType)) {
                return null;
            }
            String symbolName = resolvedSymbol.getName();
            if (symbolName == null || RTypeUtilCore.isNullOrEmpty((RType)invocationPointImplicitReceiverType)) {
                return null;
            }
            Symbol implicitReceiverMemberWithSameNameAsResolved = invocationPointImplicitReceiverType.getMemberForName(symbolName, Symbol.Filter.ACCEPT_ALL, (PsiElement)explicitReceiver);
            if (implicitReceiverMemberWithSameNameAsResolved == null) {
                return PROTECTED_WITH_NOT_STRONG_ENOUGH_IMPLICIT_RECEIVER;
            }
            return SymbolUtil.isSuperMethod((Symbol)resolvedSymbol, implicitReceiverMemberWithSameNameAsResolved) == ThreeState.NO ? PROTECTED_WITH_NOT_STRONG_ENOUGH_IMPLICIT_RECEIVER : null;
        }
        if ("self".equals(explicitReceiver.getText()) && ((String)ObjectUtils.chooseNotNull((Object)resolvedSymbol.getName(), (Object)"")).endsWith("=")) {
            return null;
        }
        if ("self".equals(explicitReceiver.getText()) && AccessModifierProblem.languageLevelAtLeast27(explicitReceiver)) {
            return null;
        }
        return PRIVATE_WITH_EXPLICIT_RECEIVER;
    }

    private static boolean languageLevelAtLeast27(@NotNull RPsiElement explicitReceiver) {
        LanguageLevel level;
        if (explicitReceiver == null) {
            AccessModifierProblem.$$$reportNull$$$0(4);
        }
        if ((level = explicitReceiver.getLanguageLevel()) == null) {
            return false;
        }
        return !level.isLessThan(LanguageLevel.RUBY27);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullyQualifiedCall";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/resolve/accessmodifier/AccessModifierProblem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedSymbol";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/resolve/accessmodifier/AccessModifierProblem";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createQuickFixes";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculateAccessModifierProblem";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "languageLevelAtLeast27";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

