/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.resolve;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.ViewSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.SymbolResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.SymbolPsiResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.TextResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubyTextResolveResultsCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.MultiPsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.MultiSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.TypedSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.RubyUsageAnalyzerCore;
import org.jetbrains.plugins.ruby.ruby.lang.findUsages.RubyUsageTypeProvider;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RNameUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.RAliasStatementNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.RConstantImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;

public final class ResolveUtil {
    private static final TypeSet TYPES = Types.MODULE_OR_CLASS_OR_CONSTANT.union(Types.METHODS_LIKE);

    private ResolveUtil() {
    }

    public static void addVariants(@NotNull List<? super SymbolResolveResult> list, @NotNull Symbol symbol, boolean validResult, PsiElement invocationPoint) {
        List declarations;
        if (list == null) {
            ResolveUtil.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            ResolveUtil.$$$reportNull$$$0(1);
        }
        if ((declarations = ContainerUtil.filter(ResolveUtil.getDeclarationsToShow(symbol, invocationPoint), it -> {
            VirtualFile vFile = RubyPsiUtil.getVirtualFileFromElement(it);
            return vFile == null || invocationPoint.getResolveScope().contains(vFile);
        })).isEmpty()) {
            list.add((SymbolResolveResult)new SymbolResolveResult(symbol, symbol.isSynthetic()));
        } else {
            for (PsiElement element : declarations) {
                list.add(new SymbolPsiResolveResult(element, symbol, validResult));
            }
        }
    }

    @NotNull
    public static Collection<? extends PsiElement> getDeclarationsToShow(@NotNull Symbol symbol, PsiElement invocationPoint) {
        if (symbol == null) {
            ResolveUtil.$$$reportNull$$$0(2);
        }
        if (Types.METHODS.contains(symbol.getType()) && !symbol.isSynthetic() && ResolveUtil.hasDeclarationInSameFileAsInvocationPoint(invocationPoint, symbol.getAllDeclarations(invocationPoint))) {
            List<PsiElement> list = Collections.singletonList(symbol.getPsiElement());
            if (list == null) {
                ResolveUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (symbol instanceof PsiElementSymbol || symbol instanceof ClassModuleSymbol || symbol instanceof MultiPsiElementSymbol) {
            Collection collection = symbol.getAllDeclarations(invocationPoint);
            if (collection == null) {
                ResolveUtil.$$$reportNull$$$0(4);
            }
            return collection;
        }
        if (symbol instanceof MultiSymbol) {
            ArrayList<? extends PsiElement> list = new ArrayList<PsiElement>();
            for (Symbol s : ((MultiSymbol)symbol).getSymbols()) {
                list.addAll(ResolveUtil.getDeclarationsToShow(s, invocationPoint));
            }
            ArrayList<? extends PsiElement> arrayList = list;
            if (arrayList == null) {
                ResolveUtil.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        Collection collection = symbol.getAllDeclarations(invocationPoint);
        if (collection == null) {
            ResolveUtil.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public static boolean isReferenceTo(@NotNull PsiReference reference, @Nullable PsiElement element) {
        if (reference == null) {
            ResolveUtil.$$$reportNull$$$0(7);
        }
        return ResolveUtil.isReferenceTo(reference, element, true);
    }

    public static boolean isReferenceTo(@NotNull PsiReference reference, @Nullable PsiElement element, boolean acceptInvalidResults) {
        PsiElement referenceElement;
        if (reference == null) {
            ResolveUtil.$$$reportNull$$$0(8);
        }
        if ((referenceElement = reference.getElement()) == element || element == null) {
            return false;
        }
        if (RailsUtil.isUnderVendor(element) && !RailsUtil.isUnderVendor(referenceElement)) {
            return false;
        }
        PsiManager psiManager = element.getManager();
        if (reference instanceof PsiPolyVariantReference) {
            for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(false)) {
                Symbol symbol;
                SymbolResolveResult symbolResolveResult;
                if (!acceptInvalidResults && result instanceof SymbolResolveResult && !(symbolResolveResult = (SymbolResolveResult)result).isValidResult()) continue;
                PsiElement resultElement = result.getElement();
                if (psiManager.areElementsEquivalent(resultElement, element)) {
                    referenceElement.putUserData(RubyUsageTypeProvider.TEXT_OCCURRENCE_KEY, (Object)(result instanceof TextResolveResult ? Boolean.valueOf(true) : null));
                    return true;
                }
                if (!(element instanceof RField) || !(result instanceof SymbolResolveResult) || !Types.ATTR_METHODS.contains((symbol = ((SymbolResolveResult)result).getSymbol()).getType())) continue;
                if (symbol instanceof TypedSymbol && symbol.getParentSymbol() instanceof ViewSymbol && RTypeUtil.getTypeFromTypedSymbol(null, symbol) == REmptyType.INSTANCE) {
                    return false;
                }
                String symbolName = symbol.getName();
                String name = ((RField)element).getName();
                if ((name == null || !name.equals(symbolName)) && !(name + "=").equals(symbolName)) continue;
                return true;
            }
        } else if (psiManager.areElementsEquivalent(reference.resolve(), element)) {
            return true;
        }
        return false;
    }

    @NotNull
    public static List<PsiElement> multiResolve(@Nullable PsiReference ref, boolean acceptInvalidResults) {
        if (ref instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)ref).multiResolve(false);
            ArrayList<PsiElement> result = new ArrayList<PsiElement>(results.length);
            for (ResolveResult resolveResult : results) {
                if (!acceptInvalidResults && !resolveResult.isValidResult()) continue;
                ContainerUtil.addIfNotNull(result, (Object)resolveResult.getElement());
            }
            ArrayList<PsiElement> arrayList = result;
            if (arrayList == null) {
                ResolveUtil.$$$reportNull$$$0(9);
            }
            return arrayList;
        }
        PsiElement res = ref != null ? ref.resolve() : null;
        List list = ContainerUtil.createMaybeSingletonList((Object)res);
        if (list == null) {
            ResolveUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    public static Symbol resolveToFirstSymbolWithCaching(PsiReference @NotNull [] references) {
        if (references == null) {
            ResolveUtil.$$$reportNull$$$0(11);
        }
        for (PsiReference reference : references) {
            Symbol symbol = ResolveUtil.resolveToSymbolWithCaching(reference, false);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    @Nullable
    public static Symbol resolveToSymbolWithCaching(@Nullable PsiReference psiReference, boolean acceptInvalidResults) {
        if (!(psiReference instanceof RPsiPolyVariantReference)) {
            return null;
        }
        return (Symbol)ContainerUtil.getFirstItem(ResolveUtil.resolveToSymbolsWithCaching((PsiPolyVariantReference)psiReference, acceptInvalidResults));
    }

    @Nullable
    public static Symbol resolveToSymbolWithCaching(@Nullable PsiReference psiReference) {
        return ResolveUtil.resolveToSymbolWithCaching(psiReference, false);
    }

    @NotNull
    public static List<? extends Symbol> resolveToSymbolsWithCaching(@NotNull PsiPolyVariantReference reference, boolean acceptInvalidResults) {
        if (reference == null) {
            ResolveUtil.$$$reportNull$$$0(12);
        }
        List list = Arrays.stream(reference.multiResolve(false)).filter(result -> acceptInvalidResults || result.isValidResult()).filter(result -> result instanceof SymbolResolveResult).map(result -> ((SymbolResolveResult)result).getSymbol()).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            ResolveUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public static List<TextResolveResult> getTextBasedResults(@NotNull PsiElement element, @NotNull String name) {
        if (element == null) {
            ResolveUtil.$$$reportNull$$$0(14);
        }
        if (name == null) {
            ResolveUtil.$$$reportNull$$$0(15);
        }
        if (element instanceof RColonReference) {
            throw new IllegalArgumentException("addQualifiedTextBasedResults should be called for " + String.valueOf(element));
        }
        ArrayList<TextResolveResult> results = new ArrayList<TextResolveResult>();
        for (TextResolveResult result : RubyTextResolveResultsCache.getInstance(element.getProject()).get(name)) {
            if (!ResolveUtil.isValidTextResolveTarget(element, result.getElement())) continue;
            results.add(result);
        }
        ArrayList<TextResolveResult> arrayList = results;
        if (arrayList == null) {
            ResolveUtil.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    public static void addQualifiedTextBasedResults(@NotNull Project project, @NotNull PsiElement element, @NotNull String qualifierText, @NotNull String name, List<? super SymbolResolveResult> validResults, List<? super SymbolResolveResult> invalidResults) {
        if (project == null) {
            ResolveUtil.$$$reportNull$$$0(17);
        }
        if (element == null) {
            ResolveUtil.$$$reportNull$$$0(18);
        }
        if (qualifierText == null) {
            ResolveUtil.$$$reportNull$$$0(19);
        }
        if (name == null) {
            ResolveUtil.$$$reportNull$$$0(20);
        }
        try {
            ProgressManager.checkCanceled();
            String fqn = (qualifierText.endsWith(".new") ? qualifierText.substring(0, qualifierText.length() - 4) : qualifierText) + String.valueOf(RubyTokenTypes.tCOLON2) + name;
            List<RContainer> collection = RubyFQNUtil.findContainersByFQN(project, TYPES, FQN.Builder.create(Collections.singletonList(fqn), (boolean)true), null);
            if (!collection.isEmpty()) {
                for (RContainer container : collection) {
                    validResults.add(new TextResolveResult((PsiElement)container, name));
                }
                return;
            }
            for (TextResolveResult result : RubyTextResolveResultsCache.getInstance(project).get(name)) {
                PsiElement target = result.getElement();
                if (!ResolveUtil.isValidTextResolveTarget(element, target)) continue;
                RContainer parentContainer = RubyPsiUtilCore.getParentContainer((PsiElement)target);
                if (RNameUtilCore.matchesFQN((String)fqn, (String)qualifierText, (RContainer)parentContainer, (String)name)) {
                    if (parentContainer != null && qualifierText.endsWith(parentContainer.getFQN().getShortName())) {
                        validResults.add(0, result);
                        continue;
                    }
                    validResults.add(result);
                    continue;
                }
                invalidResults.add(result);
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    @Nullable
    public static PsiElement resolvePsiMultiReference(PsiReference reference) {
        List<PsiElement> elements = ResolveUtil.multiResolve(reference, true);
        return elements.size() == 1 ? elements.get(0) : null;
    }

    public static boolean canCreateReference(@NotNull RPsiElement element) {
        if (element == null) {
            ResolveUtil.$$$reportNull$$$0(21);
        }
        if (!ResolveUtil.canCreateReferenceCommon(element) || RubyPsiUtil.isClassModuleOrMethodName((PsiElement)element)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof RAssocKey) {
            return false;
        }
        return !RubyUsageAnalyzerCore.isPatternMatchingAssignment((PsiElement)element);
    }

    public static boolean canCreateReference(@NotNull RConstantImpl constant) {
        if (constant == null) {
            ResolveUtil.$$$reportNull$$$0(22);
        }
        return ResolveUtil.canCreateReferenceCommon((RPsiElement)constant) && (!RubyPsiUtil.isClassModuleOrMethodName((PsiElement)constant) || constant.getNextSibling() != null);
    }

    private static boolean canCreateReferenceCommon(@NotNull RPsiElement element) {
        if (element == null) {
            ResolveUtil.$$$reportNull$$$0(23);
        }
        return RReferenceNavigator.getRRefenceOrTopReference((PsiElement)element) == null && RAliasStatementNavigator.getAliasByName((PsiElement)element, (boolean)true) == null && RubyCallTypes.getAliasMethodCallByNewName(element) == null;
    }

    public static boolean canCreateConstantReference(@NotNull PsiElement element) {
        RColonReference reference;
        PsiElement parent;
        if (element == null) {
            ResolveUtil.$$$reportNull$$$0(24);
        }
        if ((parent = element.getParent()) == null || parent instanceof RTopConstReference) {
            return false;
        }
        if (parent instanceof RName) {
            return parent instanceof RSuperClass;
        }
        if (!(parent instanceof RColonReference) || (reference = (RColonReference)parent).isCall()) {
            return true;
        }
        if (reference.getValue() == element) {
            return false;
        }
        PsiElement grandparent = parent.getParent();
        return grandparent instanceof RName && !(grandparent instanceof RSuperClass);
    }

    private static boolean hasDeclarationInSameFileAsInvocationPoint(@Nullable PsiElement invocationPoint, @NotNull Collection<? extends PsiElement> allDeclarations) {
        if (allDeclarations == null) {
            ResolveUtil.$$$reportNull$$$0(25);
        }
        if (invocationPoint == null) {
            return false;
        }
        PsiManager manager = invocationPoint.getManager();
        PsiFile file = invocationPoint.getContainingFile();
        return ContainerUtil.exists(allDeclarations, it -> manager.areElementsEquivalent((PsiElement)file, (PsiElement)it.getContainingFile()));
    }

    private static boolean isValidTextResolveTarget(@NotNull PsiElement element, @NotNull PsiElement target) {
        if (element == null) {
            ResolveUtil.$$$reportNull$$$0(26);
        }
        if (target == null) {
            ResolveUtil.$$$reportNull$$$0(27);
        }
        if (element instanceof RInstanceVariable) {
            return target instanceof RInstanceVariable;
        }
        if (target instanceof RInstanceVariable) {
            return false;
        }
        if (element instanceof RClassVariable) {
            return target instanceof RClassVariable;
        }
        if (target instanceof RClassVariable) {
            return false;
        }
        if (element instanceof RGlobalVariable) {
            return target instanceof RGlobalVariable;
        }
        return !(target instanceof RGlobalVariable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 9, 10, 13, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/resolve/ResolveUtil";
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 14: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierText";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDeclarations";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/resolve/ResolveUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsToShow";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToSymbolsWithCaching";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextBasedResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addVariants";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationsToShow";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveToFirstSymbolWithCaching";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveToSymbolsWithCaching";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTextBasedResults";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addQualifiedTextBasedResults";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "canCreateReference";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "canCreateReferenceCommon";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "canCreateConstantReference";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasDeclarationInSameFileAsInvocationPoint";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isValidTextResolveTarget";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 9, 10, 13, 16 -> new IllegalStateException(string);
        };
    }
}

