/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.references;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.PsiReferenceWithCompletion;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolContainerUtil;

public abstract class RubyPolyVariantReferenceBase
implements PsiPolyVariantReference,
PsiReferenceWithCompletion {
    private static final MyResolver RESOLVER = new MyResolver();

    @NotNull
    protected abstract Project getProject();

    protected abstract ResolveResult @NotNull [] multiResolveInner(boolean var1);

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            RubyPolyVariantReferenceBase.$$$reportNull$$$0(0);
        }
        return ResolveUtil.isReferenceTo(this, element);
    }

    public boolean isSoft() {
        return true;
    }

    public PsiElement resolve() {
        return ResolveUtil.resolvePsiMultiReference(this);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            RubyPolyVariantReferenceBase.$$$reportNull$$$0(1);
        }
        return null;
    }

    public final ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        if (DumbService.isDumb((Project)this.getProject())) {
            ResolveResult[] resolveResultArray = RESOLVER.resolve(this, incompleteCode);
            if (resolveResultArray == null) {
                RubyPolyVariantReferenceBase.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)RESOLVER, false, incompleteCode);
        if (resolveResultArray == null) {
            RubyPolyVariantReferenceBase.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    protected ResolveResult @NotNull [] sortResolveResults(ResolveResult @NotNull [] results) {
        if (results == null) {
            RubyPolyVariantReferenceBase.$$$reportNull$$$0(4);
        }
        if (results.length <= 1) {
            if (results == null) {
                RubyPolyVariantReferenceBase.$$$reportNull$$$0(5);
            }
            return results;
        }
        List<ResolveResult> list = Arrays.asList(results);
        FQN fqn = null;
        for (ResolveResult result : results) {
            PsiElement psiElement = result.getElement();
            if (!(psiElement instanceof RElementWithFQN)) continue;
            RElementWithFQN elementWithFqn = (RElementWithFQN)psiElement;
            fqn = elementWithFqn.getFQNWithNesting();
            break;
        }
        if (fqn != null && StringUtil.isCapitalized((String)fqn.getShortName())) {
            ResolveResult[] resolveResultArray = SymbolContainerUtil.siftUpMainDeclarations(fqn, list, ResolveResult::getElement).toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                RubyPolyVariantReferenceBase.$$$reportNull$$$0(6);
            }
            return resolveResultArray;
        }
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.getProject());
        Object2IntOpenHashMap priorities = new Object2IntOpenHashMap(results.length);
        for (ResolveResult result : results) {
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)result.getElement());
            if (file != null) {
                priorities.put((Object)result, projectScope.contains(file) ? -2 : -1);
                continue;
            }
            priorities.put((Object)result, 0);
        }
        list.sort(Comparator.comparingInt(arg_0 -> RubyPolyVariantReferenceBase.lambda$sortResolveResults$0((Object2IntMap)priorities, arg_0)));
        ResolveResult[] resolveResultArray = list.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            RubyPolyVariantReferenceBase.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    private static /* synthetic */ int lambda$sortResolveResults$0(Object2IntMap priorities, ResolveResult result) {
        return priorities.getOrDefault((Object)result, 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/references/RubyPolyVariantReferenceBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/references/RubyPolyVariantReferenceBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sortResolveResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sortResolveResults";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    private static class MyResolver
    implements ResolveCache.PolyVariantResolver<RubyPolyVariantReferenceBase> {
        private MyResolver() {
        }

        public ResolveResult @NotNull [] resolve(@NotNull RubyPolyVariantReferenceBase ref, boolean incompleteCode) {
            if (ref == null) {
                MyResolver.$$$reportNull$$$0(0);
            }
            ResolveResult[] resolveResultArray = ref.sortResolveResults(ref.multiResolveInner(incompleteCode));
            if (resolveResultArray == null) {
                MyResolver.$$$reportNull$$$0(1);
            }
            return resolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/references/RubyPolyVariantReferenceBase$MyResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/references/RubyPolyVariantReferenceBase$MyResolver";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

