/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.references;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.ReferenceCompletionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProviderUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RubyPolyVariantReferenceBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.SymbolResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.MultiSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RModuleType;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;

public abstract class RQualifiedReferenceBase
extends RubyPolyVariantReferenceBase
implements RPsiPolyVariantReference {
    @NotNull
    protected final String myQualifier;
    @NotNull
    protected final String myName;
    @NotNull
    private final Project myProject;

    public RQualifiedReferenceBase(@NotNull Project project, @NotNull String qualifier, @NotNull String name) {
        if (project == null) {
            RQualifiedReferenceBase.$$$reportNull$$$0(0);
        }
        if (qualifier == null) {
            RQualifiedReferenceBase.$$$reportNull$$$0(1);
        }
        if (name == null) {
            RQualifiedReferenceBase.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myQualifier = qualifier;
        this.myName = name;
    }

    @Override
    protected ResolveResult @NotNull [] multiResolveInner(boolean incompleteCode) {
        ArrayList invalidResults = new ArrayList();
        ArrayList validResults = new ArrayList();
        SymbolResolveResult symbolResolveResult = this.resolveToSymbol();
        Symbol symbol = symbolResolveResult.getSymbol();
        boolean valid = symbolResolveResult.isValidResult();
        if (symbol instanceof MultiSymbol) {
            for (Symbol symbolVariant : ((MultiSymbol)symbol).getSymbols()) {
                boolean validVariant = this.isValidResult(valid, symbolVariant);
                ResolveUtil.addVariants(validVariant ? validResults : invalidResults, symbolVariant, validVariant, this.getElement());
            }
        } else if (symbol != null) {
            ResolveUtil.addVariants(valid ? validResults : invalidResults, symbol, valid, this.getElement());
        }
        if (validResults.isEmpty()) {
            invalidResults.clear();
            ResolveUtil.addQualifiedTextBasedResults(this.myProject, this.getElement(), this.myQualifier, this.myName, validResults, invalidResults);
        }
        if (!validResults.isEmpty()) {
            ResolveResult[] resolveResultArray = validResults.toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                RQualifiedReferenceBase.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        if (!invalidResults.isEmpty()) {
            ResolveResult[] resolveResultArray = invalidResults.toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                RQualifiedReferenceBase.$$$reportNull$$$0(4);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            RQualifiedReferenceBase.$$$reportNull$$$0(5);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    protected boolean isValidResult(boolean valid, Symbol symbolVariant) {
        return true;
    }

    protected void checkName(@NonNls @NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            RQualifiedReferenceBase.$$$reportNull$$$0(6);
        }
        if (!(RubyTextUtil.isCID((String)newName) || RubyTextUtil.isFID((String)newName) || TextUtil.isAID((String)newName) || TextUtil.isField((String)newName))) {
            throw new IncorrectOperationException(RBundle.message((String)"rename.incorrect.name", (Object[])new Object[]{newName}));
        }
    }

    @Override
    @NotNull
    public SymbolResolveResult resolveToSymbol() {
        Symbol symbol;
        ProgressManager.checkCanceled();
        RType refObjectType = this.getRefObjectType();
        Predicate<Symbol> filter = this.createFilter(false);
        if (refObjectType instanceof RModuleType && this.isConstantReference()) {
            refObjectType = ((RModuleType)refObjectType).getGenericType();
        }
        if ((symbol = refObjectType.getMemberForName(this.myName, filter, this.getElement())) != null) {
            SymbolResolveResult symbolResolveResult = SymbolResolveResult.create((Symbol)symbol, (boolean)refObjectType.isTyped());
            if (symbolResolveResult == null) {
                RQualifiedReferenceBase.$$$reportNull$$$0(7);
            }
            return symbolResolveResult;
        }
        SymbolResolveResult symbolResolveResult = SymbolResolveResult.EMPTY_RESULT;
        if (symbolResolveResult == null) {
            RQualifiedReferenceBase.$$$reportNull$$$0(8);
        }
        return symbolResolveResult;
    }

    @Override
    public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            RQualifiedReferenceBase.$$$reportNull$$$0(9);
        }
        if (context == null) {
            RQualifiedReferenceBase.$$$reportNull$$$0(10);
        }
        if (result == null) {
            RQualifiedReferenceBase.$$$reportNull$$$0(11);
        }
        String prefixText = this.myName;
        prefixText = StringUtil.trimEnd((String)prefixText, (String)"IntellijIdeaRulezzz");
        RType type = this.getRefObjectType();
        boolean showModulesFirst = this.getElement() instanceof RColonReference || this.getElement() instanceof RTopConstReference;
        ReferenceCompletionUtil.addLookupItemsByType(type, this.createCompletionFilter().and(RubyCompletionProviderUtil.symbolNamePrefixFilter(result)), prefixText, showModulesFirst, this.getElement(), (Consumer<? super LookupElement>)result);
    }

    @NotNull
    protected abstract Predicate<Symbol> createFilter(boolean var1);

    @NotNull
    protected Predicate<Symbol> createCompletionFilter() {
        Predicate<Symbol> predicate = this.createFilter(true);
        if (predicate == null) {
            RQualifiedReferenceBase.$$$reportNull$$$0(12);
        }
        return predicate;
    }

    @NotNull
    public abstract RType getRefObjectType();

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            RQualifiedReferenceBase.$$$reportNull$$$0(13);
        }
        return project;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RQualifiedReferenceBase base = (RQualifiedReferenceBase)o;
        return Objects.equals(this.myProject, base.myProject) && Objects.equals(this.myQualifier, base.myQualifier) && Objects.equals(this.myName, base.myName);
    }

    public int hashCode() {
        int result = this.myQualifier.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + this.myProject.hashCode();
        return result;
    }

    private boolean isConstantReference() {
        PsiElement element = this.getElement();
        if (element instanceof RReference) {
            return RReferenceBase.doesResolveToConstant((RReference)((RReference)element));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 8, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/references/RQualifiedReferenceBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/references/RQualifiedReferenceBase";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveInner";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToSymbol";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionFilter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 8, 12, 13 -> new IllegalStateException(string);
        };
    }
}

