/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.references;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.ReferenceCompletionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProviderUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RubyPolyVariantReferenceWithPsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.SymbolResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public abstract class RPsiPolyVariantReferenceBase
extends RubyPolyVariantReferenceWithPsiElement
implements RPsiPolyVariantReference {
    @NotNull
    protected final SmartPsiElementPointer<RPsiElement> myRealContextPointer;

    protected RPsiPolyVariantReferenceBase(@NotNull PsiElement element, @NotNull RPsiElement realContext) {
        if (element == null) {
            RPsiPolyVariantReferenceBase.$$$reportNull$$$0(0);
        }
        if (realContext == null) {
            RPsiPolyVariantReferenceBase.$$$reportNull$$$0(1);
        }
        super(element);
        this.myRealContextPointer = SmartPointerManager.createPointer((PsiElement)realContext);
    }

    @Nullable
    protected final RPsiElement getRealContext() {
        return (RPsiElement)this.myRealContextPointer.getElement();
    }

    protected abstract boolean isConstantReference();

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, this.myElement.getTextLength());
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        if (string == null) {
            RPsiPolyVariantReferenceBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected ResolveResult @NotNull [] multiResolveInner(boolean incompleteCode) {
        ArrayList<SymbolResolveResult> list = new ArrayList<SymbolResolveResult>();
        SymbolResolveResult result = this.resolveToSymbol();
        Symbol symbol = result.getSymbol();
        if (symbol != null) {
            ResolveUtil.addVariants(list, symbol, result.isValidResult(), this.getElement());
        }
        if (list.isEmpty()) {
            this.addTextBasedResolveResults(list);
        }
        ResolveResult[] resolveResultArray = list.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            RPsiPolyVariantReferenceBase.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    protected void addTextBasedResolveResults(List<SymbolResolveResult> list) {
        list.addAll(ResolveUtil.getTextBasedResults(this.myElement, this.getName()));
    }

    @Override
    public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        RPsiElement realContext;
        if (parameters == null) {
            RPsiPolyVariantReferenceBase.$$$reportNull$$$0(4);
        }
        if (context == null) {
            RPsiPolyVariantReferenceBase.$$$reportNull$$$0(5);
        }
        if (result == null) {
            RPsiPolyVariantReferenceBase.$$$reportNull$$$0(6);
        }
        if ((realContext = this.getRealContext()) == null) {
            return;
        }
        Runnable runnable = () -> {
            Predicate<Symbol> filter = this.createFilter().and(RubyCompletionProviderUtil.symbolNamePrefixFilter(result));
            ContextImpl typeContext = ContextImpl.getContext((PsiElement)realContext);
            this.addCompletionVariants(filter, typeContext, (Consumer<LookupElement>)result);
        };
        if (realContext instanceof RContainer) {
            runnable.run();
        } else {
            RPsiElement original = (RPsiElement)CompletionUtil.getOriginalElement((PsiElement)realContext);
            ReferenceCompletionUtil.doWithReferenceCompletion((PsiElement)realContext, () -> ReferenceCompletionUtil.doWithReferenceCompletion((PsiElement)original, runnable));
        }
    }

    protected void addCompletionVariants(@NotNull Predicate<Symbol> filter, ContextImpl context, @NotNull Consumer<LookupElement> elementConsumer) {
        RPsiElement realContext;
        if (filter == null) {
            RPsiPolyVariantReferenceBase.$$$reportNull$$$0(7);
        }
        if (elementConsumer == null) {
            RPsiPolyVariantReferenceBase.$$$reportNull$$$0(8);
        }
        if ((realContext = this.getRealContext()) != null) {
            ReferenceCompletionUtil.addLookupItems((PsiElement)realContext, filter, elementConsumer);
        }
    }

    @NotNull
    protected Predicate<Symbol> createFilter() {
        Predicate<Symbol> predicate = RubyCompletionProvider.createCompletionFilter(this.getRealContext());
        if (predicate == null) {
            RPsiPolyVariantReferenceBase.$$$reportNull$$$0(9);
        }
        return predicate;
    }

    @Override
    @NotNull
    public SymbolResolveResult resolveToSymbol() {
        ProgressManager.checkCanceled();
        Symbol symbol = this.resolveToSymbol(this.getName(), Types.EMPTY_CONTEXT_RESOLVE_TYPES);
        SymbolResolveResult symbolResolveResult = symbol != null ? SymbolResolveResult.create((Symbol)symbol) : SymbolResolveResult.EMPTY_RESULT;
        if (symbolResolveResult == null) {
            RPsiPolyVariantReferenceBase.$$$reportNull$$$0(10);
        }
        return symbolResolveResult;
    }

    protected String getName() {
        return this.myElement instanceof PsiNamedElement ? ((PsiNamedElement)this.myElement).getName() : this.myElement.getText();
    }

    @Nullable
    protected final Symbol resolveToSymbol(@Nullable String name, TypeSet acceptableTypes) {
        RPsiElement realContext = this.getRealContext();
        if (name == null || realContext == null) {
            return null;
        }
        FQN fqn = FQN.Builder.fromString((String)name);
        if (this.isConstantReference()) {
            Symbol symbolContext = SymbolUtil.getScopeContextWithCaching((PsiElement)realContext);
            if (symbolContext == null) {
                return null;
            }
            return SymbolUtil.lookupConstant(symbolContext, (PsiElement)realContext, fqn, Types.MODULE_OR_CLASS_OR_CONSTANT.intersect(acceptableTypes), this.myElement);
        }
        RType contextType = RTypeUtil.getTypeForSelf((PsiElement)realContext);
        Symbol contextSymbol = RTypeUtil.extractSymbolOrMultiSymbol(contextType);
        return SymbolUtil.lookupMethod(contextSymbol, contextType, fqn, acceptableTypes.difference(Types.MODULE_OR_CLASS_OR_CONSTANT), this.myElement);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RPsiPolyVariantReferenceBase base = (RPsiPolyVariantReferenceBase)o;
        return this.myRealContextPointer.equals(base.myRealContextPointer);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myRealContextPointer.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realContext";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/references/RPsiPolyVariantReferenceBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/references/RPsiPolyVariantReferenceBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveInner";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionVariants";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 9, 10 -> new IllegalStateException(string);
        };
    }
}

