/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.references;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.IncorrectOperationException;
import icons.RubyIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class RFileReference
implements PsiPolyVariantReference {
    private final RPsiElement myOwner;
    private final TextRange myTextRange;
    private static final int SO_SUFFIX_LENGTH = ".so".length();
    private static final int DLL_SUFFIX_LENGTH = ".dll".length();
    private static final int BUNDLE_SUFFIX_LENGTH = ".bundle".length();
    private static final int RB_SUFFIX_LENGTH = RFileUtilCore.RB_FILE_SUFFIX.length();
    private final boolean isRelativeToDirectory;
    private final RPsiElement myFullReference;
    private final RPsiElement myElement;
    private final String myPathPrefix;
    private final RFileUtil myRFileUtil;

    public RFileReference(@NotNull RPsiElement owner, @NotNull RPsiElement fullReference, @NotNull RPsiElement element, boolean relativeToDirectory, @Nullable String pathPrefix) {
        if (owner == null) {
            RFileReference.$$$reportNull$$$0(0);
        }
        if (fullReference == null) {
            RFileReference.$$$reportNull$$$0(1);
        }
        if (element == null) {
            RFileReference.$$$reportNull$$$0(2);
        }
        this.myRFileUtil = RFileUtil.getInstance();
        this.myOwner = owner;
        this.myFullReference = fullReference;
        this.myElement = element;
        this.myPathPrefix = pathPrefix;
        this.myTextRange = this.computeTextRange(element);
        this.isRelativeToDirectory = relativeToDirectory;
    }

    private TextRange computeTextRange(@NotNull RPsiElement element) {
        List args;
        int relativeStartOffset;
        if (element == null) {
            RFileReference.$$$reportNull$$$0(3);
        }
        int startOffset = relativeStartOffset = element.getTextRange().getStartOffset() - this.myOwner.getTextRange().getStartOffset();
        int endOffset = relativeStartOffset + element.getTextLength();
        if (element instanceof RBaseString) {
            PsiElement stringEnding;
            RBaseString baseString = (RBaseString)element;
            PsiElement stringBeginning = baseString.getStringBeginning();
            if (stringBeginning != null) {
                startOffset += stringBeginning.getTextLength();
            }
            if ((stringEnding = baseString.getStringEnding()) != null) {
                endOffset -= stringEnding.getTextLength();
            }
            return new TextRange(startOffset, endOffset);
        }
        if (element instanceof RCall && !(args = ((RCall)element).getArguments()).isEmpty()) {
            return this.computeTextRange((RPsiElement)args.get(args.size() - 1));
        }
        return new TextRange(relativeStartOffset, relativeStartOffset + element.getTextLength());
    }

    @NotNull
    public PsiElement getElement() {
        RPsiElement rPsiElement = this.myOwner;
        if (rPsiElement == null) {
            RFileReference.$$$reportNull$$$0(4);
        }
        return rPsiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            RFileReference.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeInElement().substring(this.getElement().getText());
        if (string == null) {
            RFileReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            RFileReference.$$$reportNull$$$0(7);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            RFileReference.$$$reportNull$$$0(8);
        }
        return this.resolve() == element;
    }

    public Object @NotNull [] getVariants() {
        if (this.myElement instanceof RBaseString) {
            RFile rFile = RubyPsiUtil.getRFile((PsiElement)this.myOwner);
            assert (rFile != null);
            ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
            HashSet<String> foundNames = new HashSet<String>();
            VirtualFile file = RubyPsiUtil.getVirtualFileFromElement((PsiElement)rFile);
            if (file != null) {
                for (String requireUrl : RFileUtil.getAvailableRequiresUrls(rFile, file, this.isRelativeToDirectory)) {
                    if (requireUrl.endsWith(RFileUtilCore.RB_FILE_SUFFIX)) {
                        requireUrl = requireUrl.substring(0, requireUrl.length() - RB_SUFFIX_LENGTH);
                    } else if (requireUrl.endsWith(".so")) {
                        requireUrl = requireUrl.substring(0, requireUrl.length() - SO_SUFFIX_LENGTH);
                    } else if (requireUrl.endsWith(".dll")) {
                        requireUrl = requireUrl.substring(0, requireUrl.length() - DLL_SUFFIX_LENGTH);
                    } else if (requireUrl.endsWith(".bundle")) {
                        requireUrl = requireUrl.substring(0, requireUrl.length() - BUNDLE_SUFFIX_LENGTH);
                    }
                    if (foundNames.contains(requireUrl)) continue;
                    foundNames.add(requireUrl);
                    variants.add(PrioritizedLookupElement.withPriority((LookupElement)new RubyLookupElement(requireUrl, null, null, false, RubyIcons.Ruby.RubyFile, null), (double)RubyCompletionGrouping.FILE_REF.getValue()));
                }
            }
            Object[] objectArray = variants.toArray();
            if (objectArray == null) {
                RFileReference.$$$reportNull$$$0(9);
            }
            return objectArray;
        }
        if (EMPTY_ARRAY == null) {
            RFileReference.$$$reportNull$$$0(10);
        }
        return EMPTY_ARRAY;
    }

    public boolean isSoft() {
        return true;
    }

    @NotNull
    public PsiElement getRefValue() {
        RPsiElement rPsiElement = this.myFullReference;
        if (rPsiElement == null) {
            RFileReference.$$$reportNull$$$0(11);
        }
        return rPsiElement;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            RFileReference.$$$reportNull$$$0(12);
        }
        return this.myRFileUtil.rename(this.myOwner, this.myTextRange, newElementName);
    }

    @NotNull
    public Symbol resolveToSymbol() {
        throw new UnsupportedOperationException("multiResolveToSymbols is not implemented in org.jetbrains.plugins.ruby.ruby.codeInsight.references.RFileReference");
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ArrayList<PsiElementResolveResult> list = new ArrayList<PsiElementResolveResult>();
        for (VirtualFile virtualFile : this.multiResolveToVirtualFiles()) {
            PsiFile file = this.myOwner.getManager().findFile(virtualFile);
            if (file == null) continue;
            list.add(new PsiElementResolveResult((PsiElement)file));
        }
        ResolveResult[] resolveResultArray = list.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            RFileReference.$$$reportNull$$$0(13);
        }
        return resolveResultArray;
    }

    public Collection<? extends VirtualFile> multiResolveToVirtualFiles() {
        RFile rFile = RubyPsiUtil.getRFile((PsiElement)this.myOwner);
        if (rFile == null) {
            return Collections.emptyList();
        }
        return RFileUtil.getFilesByRPsiElement(rFile, this.isRelativeToDirectory, this.myElement, this.myPathPrefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 9, 10, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullReference";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/references/RFileReference";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/references/RFileReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefValue";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeTextRange";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 9, 10, 11, 13 -> new IllegalStateException(string);
        };
    }
}

