/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.references;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProviderUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.StringOrSymbolReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.TopLevelSymbolImpl;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.presentation.SymbolLookupUtil;

public class MethodReference
extends StringOrSymbolReference {
    public MethodReference(@NotNull RPsiElement wholeReference, @NotNull PsiElement element) {
        if (wholeReference == null) {
            MethodReference.$$$reportNull$$$0(0);
        }
        if (element == null) {
            MethodReference.$$$reportNull$$$0(1);
        }
        super((PsiElement)wholeReference, element);
    }

    @Override
    public ResolveResult @NotNull [] multiResolveInner(boolean incompleteCode) {
        Symbol context = this.getScopeSymbol();
        if (context == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                MethodReference.$$$reportNull$$$0(2);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        Symbol method = SymbolUtil.findMethod(context, this.getName(), Types.METHODS_LIKE, (PsiElement)this.getElement());
        PsiElement targetElement = method == null ? null : method.getPsiElement();
        ResolveResult[] resolveResultArray = targetElement == null ? ResolveResult.EMPTY_ARRAY : PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{targetElement});
        if (resolveResultArray == null) {
            MethodReference.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    @NotNull
    protected String getName() {
        String string = StringUtil.notNullize((String)RubyPsiUtilCore.getElementText((PsiElement)this.getStringOrSymbol()));
        if (string == null) {
            MethodReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getName();
        if (string == null) {
            MethodReference.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public PsiElement handleElementRename(@NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            MethodReference.$$$reportNull$$$0(6);
        }
        if (!TextUtil.isMethodName((String)newName)) {
            throw new IncorrectOperationException(RBundle.message((String)"rename.incorrect.name", (Object[])new Object[]{newName}));
        }
        return MethodReference.rename(this.getStringOrSymbol(), newName);
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            MethodReference.$$$reportNull$$$0(7);
        }
        return PsiManager.getInstance((Project)this.getProject()).areElementsEquivalent(element, this.resolve());
    }

    @Override
    public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        Symbol scopeContext;
        if (parameters == null) {
            MethodReference.$$$reportNull$$$0(8);
        }
        if (context == null) {
            MethodReference.$$$reportNull$$$0(9);
        }
        if (result == null) {
            MethodReference.$$$reportNull$$$0(10);
        }
        if ((scopeContext = this.getScopeSymbol()) == null) {
            return;
        }
        Predicate filter = Symbol.Filter.byTypes((TypeSet)Types.METHODS_LIKE).and(RubyCompletionProviderUtil.symbolNamePrefixFilter(result));
        SymbolUtil.processMembers(scopeContext, filter, (PsiElement)this.getElement(), (Processor<? super Symbol>)((Processor)method -> {
            LookupElement lookupElement;
            String name = method.getName();
            if (name != null && (lookupElement = SymbolLookupUtil.createLookupItemBySymbol(method, null, null, name, true, false, false)) != null) {
                result.addElement(lookupElement);
            }
            return true;
        }));
    }

    @Nullable
    private Symbol getScopeSymbol() {
        Symbol scopeContext = SymbolUtil.getScopeContextWithCaching((PsiElement)this.getElement());
        if (scopeContext instanceof TopLevelSymbolImpl) {
            scopeContext = SymbolUtil.findConstantByFQN(this.getProject(), FQN.of((String)"Object"), this.myElement);
        }
        return scopeContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wholeReference";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/references/MethodReference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/references/MethodReference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveInner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

