/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.references;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.ReferenceCompletionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProviderUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.qualifiedName.RubyCompletableQualifiedNameWrapper;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RQualifiedReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.SymbolResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.TopLevelSymbolImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RSymbolTypeImpl;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

public final class Colon3Reference
extends RQualifiedReference {
    private static final Predicate<Symbol> FILTER = Symbol.Filter.byTypes((TypeSet)Types.MODULE_OR_CLASS_OR_CONSTANT);

    public Colon3Reference(@NotNull RPsiElement wholeReference, @NotNull PsiElement refValue) {
        if (wholeReference == null) {
            Colon3Reference.$$$reportNull$$$0(0);
        }
        if (refValue == null) {
            Colon3Reference.$$$reportNull$$$0(1);
        }
        super(wholeReference, null, refValue);
    }

    @Override
    public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            Colon3Reference.$$$reportNull$$$0(2);
        }
        if (context == null) {
            Colon3Reference.$$$reportNull$$$0(3);
        }
        if (result == null) {
            Colon3Reference.$$$reportNull$$$0(4);
        }
        if (Registry.is((String)"ruby.completion.classes.constants.modules.v2", (boolean)true)) {
            this.addCompletionsImplV2(parameters, context, result);
        } else {
            this.addCompletionsImpl(result);
        }
    }

    @Override
    @NotNull
    public SymbolResolveResult resolveToSymbol() {
        ProgressManager.checkCanceled();
        RFile file = RubyPsiUtil.getRFile(this.getRefValue());
        if (file == null) {
            SymbolResolveResult symbolResolveResult = SymbolResolveResult.EMPTY_RESULT;
            if (symbolResolveResult == null) {
                Colon3Reference.$$$reportNull$$$0(5);
            }
            return symbolResolveResult;
        }
        TopLevelSymbolImpl rootSymbol = SymbolUtil.getRootSymbol((RTopLevelContainer)file);
        Symbol symbol = new RSymbolTypeImpl((Symbol)rootSymbol).getMemberForName(this.getRefValue().getText(), FILTER, this.getElement());
        SymbolResolveResult symbolResolveResult = symbol != null ? SymbolResolveResult.create((Symbol)symbol) : SymbolResolveResult.EMPTY_RESULT;
        if (symbolResolveResult == null) {
            Colon3Reference.$$$reportNull$$$0(6);
        }
        return symbolResolveResult;
    }

    @Override
    protected void checkName(@NonNls @NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            Colon3Reference.$$$reportNull$$$0(7);
        }
        if (Objects.equals(this.myName, newName)) {
            throw new IncorrectOperationException(RBundle.message((String)"rename.same.name"));
        }
        if (!RubyTextUtil.isCID((String)newName) && !RubyTextUtil.isFID((String)newName)) {
            throw new IncorrectOperationException(RBundle.message((String)"rename.incorrect.name", (Object[])new Object[]{newName}));
        }
    }

    private void addCompletionsImpl(@NotNull CompletionResultSet result) {
        if (result == null) {
            Colon3Reference.$$$reportNull$$$0(8);
        }
        PsiElement refValue = this.getRefValue();
        ReferenceCompletionUtil.doWithReferenceCompletion(refValue, () -> {
            RFile file = RubyPsiUtil.getRFile(refValue);
            if (file == null) {
                return;
            }
            ReferenceCompletionUtil.addLookupItemsByType((RType)new RSymbolTypeImpl((Symbol)SymbolUtil.getRootSymbol((RTopLevelContainer)file)), FILTER.and(RubyCompletionProviderUtil.symbolNamePrefixFilter(result)), null, true, this.getElement(), (Consumer<? super LookupElement>)result);
        });
    }

    private void addCompletionsImplV2(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            Colon3Reference.$$$reportNull$$$0(9);
        }
        if (context == null) {
            Colon3Reference.$$$reportNull$$$0(10);
        }
        if (result == null) {
            Colon3Reference.$$$reportNull$$$0(11);
        }
        Project project = this.getProject();
        GlobalSearchScope searchScope = this.getRefValue().getResolveScope();
        PsiElement psiElement = this.getRefValue();
        if (!(psiElement instanceof RConstant)) {
            return;
        }
        RConstant element = (RConstant)psiElement;
        PsiElement reference = this.getElement();
        RubyCompletableQualifiedNameWrapper wrapper = ReferenceCompletionUtil.getContextCompletionWrapper(project, (SearchScope)searchScope, reference, (PsiElement)element);
        wrapper.addCompletionVariants(parameters, context, result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wholeReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refValue";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/references/Colon3Reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/references/Colon3Reference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionsImpl";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionsImplV2";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

