/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefImplUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefManager;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.MatchContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.MatchResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.ParamDefExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.RConstantImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class ParamDefMatcher {
    private ParamDefMatcher() {
    }

    @Nullable
    public static MatchResult match(@NotNull PsiElement element) {
        if (element == null) {
            ParamDefMatcher.$$$reportNull$$$0(0);
        }
        return ParamDefMatcher.match(element, false);
    }

    @Nullable
    public static MatchResult match(@NotNull PsiElement element, boolean allowFqn) {
        String shortCallName;
        if (element == null) {
            ParamDefMatcher.$$$reportNull$$$0(1);
        }
        PsiUtilCore.ensureValid((PsiElement)element);
        if (DumbService.isDumb((Project)element.getProject())) {
            return null;
        }
        RCall call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)element, RCall.class, (boolean)false, (Class[])new Class[]{RBinaryExpression.class});
        if (call == null || call instanceof RArrayIndexing) {
            return null;
        }
        PsiElement psiCommand = call.getPsiCommand();
        if (RConstantImpl.isDummyIdentifier((PsiElement)psiCommand)) {
            call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.prevLeaf((PsiElement)psiCommand), RCall.class);
            if (call == null) {
                return null;
            }
            psiCommand = call.getPsiCommand();
        }
        if (psiCommand instanceof RPossibleCall && (shortCallName = ((RPossibleCall)psiCommand).getCommand()) != null && !ParamDefManager.getInstance().getMethodNames().contains(shortCallName) && TextUtil.isMethodName((String)shortCallName)) {
            return null;
        }
        FQN fqn = null;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String text = psiCommand.getText();
            if (allowFqn || text.startsWith("TestParamdef")) {
                fqn = ParamDefImplUtil.fromLegacyString(text);
            }
        }
        if ((fqn = (FQN)ObjectUtils.chooseNotNull((Object)fqn, (Object)((FQN)ObjectUtils.doIfNotNull((Object)ResolveUtil.resolveToSymbolWithCaching(psiCommand.getReference(), true), Symbol::getFQNWithNesting)))) == null) {
            return null;
        }
        ParamDefExpression expr = ParamDefManager.getInstance().getParamDefExpression(fqn);
        return expr == null ? null : expr.match(new MatchContext(element, call, (PsiElement)call.getCallArguments().getFirstElement()));
    }

    @Nullable
    public static MatchResult match(@NotNull RPsiElement element, @NotNull ParamDefExpression expr) {
        RCall call;
        if (element == null) {
            ParamDefMatcher.$$$reportNull$$$0(2);
        }
        if (expr == null) {
            ParamDefMatcher.$$$reportNull$$$0(3);
        }
        if ((call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)element, RCall.class, (boolean)false, (Class[])new Class[]{RBinaryExpression.class})) == null || call instanceof RArrayIndexing) {
            return null;
        }
        MatchContext context = new MatchContext((PsiElement)element, call, PsiTreeUtil.findPrevParent((PsiElement)call.getCallArguments(), (PsiElement)element));
        context.pushLeaf(element);
        return expr.match(context);
    }

    public static PsiReference @NotNull [] createComplexStringParamDefReferences(@NotNull RPsiElement element) {
        MatchResult result;
        if (element == null) {
            ParamDefMatcher.$$$reportNull$$$0(4);
        }
        if ((result = ParamDefMatcher.match((PsiElement)element)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ParamDefMatcher.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList refs = new SmartList();
        for (ParamDefExpression expression : result.getParamDef().getChildrenParamDefExpressions()) {
            refs.add(new StringParamDefReference((PsiElement)element, expression, () -> ParamDefMatcher.match(element, expression)));
        }
        PsiReference[] psiReferenceArray = refs.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            ParamDefMatcher.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/matcher/ParamDefMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/matcher/ParamDefMatcher";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createComplexStringParamDefReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createComplexStringParamDefReferences";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }

    private static class StringParamDefReference
    extends ParamDefReference {
        private StringParamDefReference(@NotNull PsiElement element, @NotNull Object equality, @NotNull Supplier<? extends MatchResult> matcher) {
            if (element == null) {
                StringParamDefReference.$$$reportNull$$$0(0);
            }
            if (equality == null) {
                StringParamDefReference.$$$reportNull$$$0(1);
            }
            if (matcher == null) {
                StringParamDefReference.$$$reportNull$$$0(2);
            }
            super(element, equality, matcher, new PsiReference[0]);
        }

        @Override
        @NotNull
        public TextRange getRangeInElement() {
            MatchResult matchResult = (MatchResult)this.myMatcher.getValue();
            if (matchResult == null) {
                TextRange textRange = TextRange.EMPTY_RANGE;
                if (textRange == null) {
                    StringParamDefReference.$$$reportNull$$$0(3);
                }
                return textRange;
            }
            TextRange range = matchResult.getParamDef().getRange(matchResult.getContext());
            TextRange textRange = !range.isEmpty() ? range : super.getRangeInElement();
            if (textRange == null) {
                StringParamDefReference.$$$reportNull$$$0(4);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "equality";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/matcher/ParamDefMatcher$StringParamDefReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/matcher/ParamDefMatcher$StringParamDefReference";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

