/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ArrayArgumentOutOfBounds;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.MatchContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.MatchResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.ParamDefExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.ParamDefSeq;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;

public class ParamDefArray
extends ParamDefExpression {
    private static final Set<@NlsSafe String> EXPECTED_TYPES = Set.of("array");
    private final ParamDefExpression myElement;

    public ParamDefArray(ParamDefExpression element) {
        this.myElement = element;
    }

    @Override
    public MatchResult match(MatchContext context) {
        if (context.atTarget()) {
            PsiElement currentElement = context.current();
            if (!(currentElement instanceof RArray)) {
                return null;
            }
            List arrayElements = ((RArray)currentElement).getElements();
            if (arrayElements.isEmpty()) {
                return null;
            }
            int arrayElementsSize = arrayElements.size();
            for (int i = 0; i < arrayElementsSize; ++i) {
                ParamDefSeq paramDefSeq;
                int seqSize;
                RPsiElement arrayElement = (RPsiElement)arrayElements.get(i);
                if (!PsiTreeUtil.isAncestor((PsiElement)arrayElement, (PsiElement)context.getTarget(), (boolean)false)) continue;
                context.push(arrayElement);
                ParamDefExpression paramDefExpression = this.myElement;
                if (paramDefExpression instanceof ParamDefSeq && (seqSize = (paramDefSeq = (ParamDefSeq)paramDefExpression).size()) > 1) {
                    if (i >= seqSize) {
                        return new MatchResult(new ArrayArgumentOutOfBounds(seqSize), context.paramContext());
                    }
                    return paramDefSeq.get(i).match(context);
                }
                return this.myElement.match(context);
            }
        }
        return null;
    }

    @Override
    public boolean canMatch(MatchContext context, boolean strong) {
        return context.current() instanceof RArray;
    }

    @Override
    public @NotNull Set<@NlsSafe String> getArgumentExpectedTypes() {
        Set<String> set = EXPECTED_TYPES;
        if (set == null) {
            ParamDefArray.$$$reportNull$$$0(0);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/matcher/ParamDefArray", "getArgumentExpectedTypes"));
    }
}

