/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefExpressionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefProviderBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.accessmodifier.ReplaceWithQuickFix;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.CoreFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;

public final class RubyParamDefProvider
extends ParamDefProviderBase {
    @Override
    protected void registerParamDefs() {
        this.register(CoreFqns.BASIC_OBJECT, registrar -> registrar.define("instance_eval", ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string((Language)RubyLanguage.INSTANCE))));
        this.register(CoreFqns.KERNEL, registrar -> {
            registrar.define("eval", ParamDefExpressionUtil.string((Language)RubyLanguage.INSTANCE));
            registrar.define("method", ParamDefExpressionUtil.methodRef());
            registrar.define("public_method", ParamDefExpressionUtil.methodRef().withVisibility(Visibility.PUBLIC, arg -> RubyParamDefProvider.createReplaceQuickFixByArgument(arg, CoreFqns.KERNEL_METHOD)));
            registrar.define("public_send", ParamDefExpressionUtil.methodRef().withVisibility(Visibility.PUBLIC, arg -> RubyParamDefProvider.createReplaceQuickFixByArgument(arg, CoreFqns.KERNEL_SEND)));
            registrar.define("send", ParamDefExpressionUtil.methodRef());
        });
        this.register(CoreFqns.KERNEL_SINGLETON, registrar -> registrar.alias("eval", FQN.Builder.concat((FQN)CoreFqns.KERNEL, (String)"eval")));
        this.register(CoreFqns.MODULE, registrar -> {
            registrar.define("module_eval", ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string((Language)RubyLanguage.INSTANCE)));
            registrar.define("module_function", ParamDefExpressionUtil.array(ParamDefExpressionUtil.instanceMethodRef()));
        });
    }

    @Nullable
    private static LocalQuickFix createReplaceQuickFixByArgument(@NotNull PsiElement argument, @NotNull FQN replaceWith) {
        RCall call;
        if (argument == null) {
            RubyParamDefProvider.$$$reportNull$$$0(0);
        }
        if (replaceWith == null) {
            RubyParamDefProvider.$$$reportNull$$$0(1);
        }
        if ((call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)argument, RCall.class)) == null) {
            return null;
        }
        PsiElement command = call.getPsiCommand();
        while (command instanceof RReference) {
            command = ((RReference)command).getValue();
        }
        if (command == null) {
            return null;
        }
        return new ReplaceWithQuickFix(command, replaceWith.getShortName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "argument";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "replaceWith";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/RubyParamDefProvider";
        objectArray[2] = "createReplaceQuickFixByArgument";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

