/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.VisibilityInspectionResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefExpressionConvertable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefImplUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDependency;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.ParamDefExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.inspections.resolve.CreateRubyMethodFix;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

final class RubyMethodRefParam
extends ParamDef {
    private static final ParamDependency<Symbol> DEFAULT_CONTEXT_DEPENDENCY = context -> RTypeUtilCore.getBirthTypeSymbol((RType)RTypeUtil.getTypeForReceiver((RPossibleCall)context.getCall()));
    private static final ParamDependency<Symbol> INSTANCE_CONTEXT_DEPENDENCY = context -> {
        Symbol contextSymbol = DEFAULT_CONTEXT_DEPENDENCY.getValue(context);
        return contextSymbol instanceof SingletonClassSymbol ? ((SingletonClassSymbol)contextSymbol).getOriginSymbol() : contextSymbol;
    };
    @NotNull
    private final ParamDependency<? extends Symbol> myContextDependency;
    @NotNull
    private final Visibility myMinAllowedVisibility;
    @NotNull
    private final List<Function<PsiElement, LocalQuickFix>> myVisibilityFixGenerators;

    private RubyMethodRefParam(@NotNull ParamDependency<? extends Symbol> contextDependency, @NotNull Visibility minAllowedVisibility, @NotNull List<Function<PsiElement, LocalQuickFix>> visibilityFixGenerators) {
        if (contextDependency == null) {
            RubyMethodRefParam.$$$reportNull$$$0(0);
        }
        if (minAllowedVisibility == null) {
            RubyMethodRefParam.$$$reportNull$$$0(1);
        }
        if (visibilityFixGenerators == null) {
            RubyMethodRefParam.$$$reportNull$$$0(2);
        }
        this.myContextDependency = contextDependency;
        this.myMinAllowedVisibility = minAllowedVisibility;
        this.myVisibilityFixGenerators = visibilityFixGenerators;
    }

    @Override
    @NotNull
    public InspectionResult inspectReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RubyMethodRefParam.$$$reportNull$$$0(3);
        }
        RPsiElement argument = context.getArgumentElement();
        if (this.multiResolve(context).isEmpty()) {
            String name = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)argument);
            Symbol contextSymbol = this.myContextDependency.getValue(context);
            if (TextUtil.isAnyID((String)name) && contextSymbol != null) {
                LocalQuickFix[] localQuickFixArray;
                LocalQuickFix fix = this.getMethodMissingQuickFix(name, contextSymbol);
                if (fix != null) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = fix;
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                RType type = RTypeFactory.createTypeBySymbol(contextSymbol);
                String message = RBundle.message((String)"inspection.paramdef.method.ref.warning", (Object[])new Object[]{ObjectUtils.coalesce((Object)type.getPresentableName(), (Object)RBundle.message((String)"ruby.presentation.unknown"))});
                InspectionResult inspectionResult = InspectionResult.createWarningResultWithFixes((PsiElement)argument, message, fixes);
                if (inspectionResult == null) {
                    RubyMethodRefParam.$$$reportNull$$$0(4);
                }
                return inspectionResult;
            }
            InspectionResult inspectionResult = InspectionResult.createProbablyAcceptibleResult((PsiElement)argument);
            if (inspectionResult == null) {
                RubyMethodRefParam.$$$reportNull$$$0(5);
            }
            return inspectionResult;
        }
        InspectionResult inspectionResult = InspectionResult.createOkResult((PsiElement)argument);
        if (inspectionResult == null) {
            RubyMethodRefParam.$$$reportNull$$$0(6);
        }
        return inspectionResult;
    }

    @NotNull
    public List<PsiElement> multiResolve(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RubyMethodRefParam.$$$reportNull$$$0(7);
        }
        RPsiElement argument = context.getArgumentElement();
        Symbol method = this.resolveMethodReferenceToSymbol(context);
        ArrayList arrayList = method != null ? new ArrayList(method.getAllDeclarations((PsiElement)argument)) : Collections.emptyList();
        if (arrayList == null) {
            RubyMethodRefParam.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> consumer, @NotNull Predicate<String> lookupStringFilter) {
        Symbol contextSymbol;
        if (context == null) {
            RubyMethodRefParam.$$$reportNull$$$0(9);
        }
        if (consumer == null) {
            RubyMethodRefParam.$$$reportNull$$$0(10);
        }
        if (lookupStringFilter == null) {
            RubyMethodRefParam.$$$reportNull$$$0(11);
        }
        if ((contextSymbol = this.myContextDependency.getValue(context)) == null) {
            return;
        }
        Predicate filter = Symbol.Filter.byTypes((TypeSet)Types.METHODS_LIKE).and(this.getVisibilityPredicate());
        RPsiElement argument = context.getArgumentElement();
        SymbolUtil.processMembers(contextSymbol, filter, (PsiElement)argument, (Processor<? super Symbol>)((Processor)symbol -> {
            String name = symbol.getName();
            if (StringUtil.isEmpty((String)name) || !lookupStringFilter.test(name)) {
                return true;
            }
            consumer.consume((Object)ParamDefImplUtil.createSimpleLookupItem(name, LookupItemType.Symbol, argument, AllIcons.Nodes.Method));
            return true;
        }));
    }

    @Override
    @NotNull
    public VisibilityInspectionResult inspectVisibility(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RubyMethodRefParam.$$$reportNull$$$0(12);
        }
        RPsiElement argument = context.getArgumentElement();
        RMethodSymbol resolvedSymbol = (RMethodSymbol)ObjectUtils.tryCast((Object)this.resolveMethodReferenceToSymbol(context), RMethodSymbol.class);
        if (resolvedSymbol == null) {
            VisibilityInspectionResult visibilityInspectionResult = VisibilityInspectionResult.createOk((PsiElement)argument);
            if (visibilityInspectionResult == null) {
                RubyMethodRefParam.$$$reportNull$$$0(13);
            }
            return visibilityInspectionResult;
        }
        Visibility actualVisibility = resolvedSymbol.getVisibility();
        LocalQuickFix[] fixes = ContainerUtil.map(this.myVisibilityFixGenerators, it -> (LocalQuickFix)it.apply(argument)).toArray(LocalQuickFix.EMPTY_ARRAY);
        VisibilityInspectionResult visibilityInspectionResult = this.myMinAllowedVisibility.accepts(actualVisibility) ? VisibilityInspectionResult.createOk((PsiElement)argument) : VisibilityInspectionResult.createProblem((PsiElement)argument, this.myMinAllowedVisibility, actualVisibility, fixes);
        if (visibilityInspectionResult == null) {
            RubyMethodRefParam.$$$reportNull$$$0(14);
        }
        return visibilityInspectionResult;
    }

    @Nullable
    private LocalQuickFix getMethodMissingQuickFix(@NotNull String name, @NotNull Symbol contextSymbol) {
        RContainer container;
        if (name == null) {
            RubyMethodRefParam.$$$reportNull$$$0(15);
        }
        if (contextSymbol == null) {
            RubyMethodRefParam.$$$reportNull$$$0(16);
        }
        if ((container = (RContainer)ObjectUtils.doIfNotNull((Object)contextSymbol.getPsiElement(), RubyPsiUtilCore::getContainingRClassOrModule)) == null) {
            return null;
        }
        ContextImpl context = contextSymbol instanceof SingletonClassSymbol ? ContextImpl.CLASS : ContextImpl.INSTANCE;
        Visibility visibility = (Visibility)ObjectUtils.coalesce((Object)this.myMinAllowedVisibility, (Object)Visibility.PRIVATE);
        Project project = contextSymbol.getProject();
        return new CreateRubyMethodFix(project, null, container, name, context, visibility);
    }

    @NotNull
    private Predicate<? super Symbol> getVisibilityPredicate() {
        Predicate<Symbol> predicate = symbol -> !(symbol instanceof RMethodSymbol) || this.myMinAllowedVisibility.accepts(((RMethodSymbol)symbol).getVisibility());
        if (predicate == null) {
            RubyMethodRefParam.$$$reportNull$$$0(17);
        }
        return predicate;
    }

    @Nullable
    private Symbol resolveMethodReferenceToSymbol(@NotNull RubyCallArgumentContext context) {
        Symbol contextSymbol;
        if (context == null) {
            RubyMethodRefParam.$$$reportNull$$$0(18);
        }
        if ((contextSymbol = this.myContextDependency.getValue(context)) == null) {
            return null;
        }
        RPsiElement argument = context.getArgumentElement();
        String name = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)argument);
        return SymbolUtil.lookupMethod(contextSymbol, FQN.ofNullable((String)name), Types.METHODS_LIKE, (PsiElement)argument);
    }

    @NotNull
    public static Mutable mutable() {
        return new Mutable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 13, 14, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextDependency";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minAllowedVisibility";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibilityFixGenerators";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/RubyMethodRefParam";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/RubyMethodRefParam";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectReference";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectVisibility";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibilityPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inspectReference";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 17: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processAllVariants";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "inspectVisibility";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getMethodMissingQuickFix";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveMethodReferenceToSymbol";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8, 13, 14, 17 -> new IllegalStateException(string);
        };
    }

    public static final class Mutable
    implements ParamDefExpressionConvertable {
        @NotNull
        private ParamDependency<? extends Symbol> myContextDependency = DEFAULT_CONTEXT_DEPENDENCY;
        @NotNull
        private Visibility myMinAllowedVisibility = Visibility.PRIVATE;
        @NotNull
        private List<Function<PsiElement, LocalQuickFix>> myVisibilityFixGenerators = Collections.emptyList();

        private Mutable() {
        }

        @Override
        @NotNull
        public ParamDefExpression toExpr() {
            ParamDefExpression paramDefExpression = new RubyMethodRefParam(this.myContextDependency, this.myMinAllowedVisibility, this.myVisibilityFixGenerators).toExpr();
            if (paramDefExpression == null) {
                Mutable.$$$reportNull$$$0(0);
            }
            return paramDefExpression;
        }

        @NotNull
        public Mutable withInstanceContext() {
            this.myContextDependency = INSTANCE_CONTEXT_DEPENDENCY;
            Mutable mutable = this;
            if (mutable == null) {
                Mutable.$$$reportNull$$$0(1);
            }
            return mutable;
        }

        @NotNull
        public Mutable withVisibility(@NotNull Visibility minAllowedVisibility, Function<PsiElement, LocalQuickFix> ... fixes) {
            if (minAllowedVisibility == null) {
                Mutable.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                Mutable.$$$reportNull$$$0(3);
            }
            this.myMinAllowedVisibility = minAllowedVisibility;
            this.myVisibilityFixGenerators = ContainerUtil.filter((Object[])fixes, Objects::nonNull);
            Mutable mutable = this;
            if (mutable == null) {
                Mutable.$$$reportNull$$$0(4);
            }
            return mutable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/RubyMethodRefParam$Mutable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "minAllowedVisibility";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toExpr";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withInstanceContext";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/RubyMethodRefParam$Mutable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withVisibility";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "withVisibility";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

