/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefImplUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;

public class RubyConstantRefParam
extends ParamDef {
    static final ParamDef INSTANCE = new RubyConstantRefParam();

    private RubyConstantRefParam() {
    }

    @Override
    @NotNull
    public InspectionResult inspectReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RubyConstantRefParam.$$$reportNull$$$0(0);
        }
        RPsiElement element = context.getArgumentElement();
        if (this.multiResolve(context).isEmpty()) {
            if (RubyPsiUtil.isSimpleStringOrSymbol((PsiElement)element)) {
                InspectionResult inspectionResult = InspectionResult.createWarningResult((PsiElement)element, RBundle.message((String)"inspection.paramdef.constant.ref.warning"));
                if (inspectionResult == null) {
                    RubyConstantRefParam.$$$reportNull$$$0(1);
                }
                return inspectionResult;
            }
            InspectionResult inspectionResult = InspectionResult.createProbablyAcceptibleResult((PsiElement)element);
            if (inspectionResult == null) {
                RubyConstantRefParam.$$$reportNull$$$0(2);
            }
            return inspectionResult;
        }
        InspectionResult inspectionResult = InspectionResult.createOkResult((PsiElement)element);
        if (inspectionResult == null) {
            RubyConstantRefParam.$$$reportNull$$$0(3);
        }
        return inspectionResult;
    }

    @Override
    @NotNull
    public List<? extends PsiElement> multiResolve(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RubyConstantRefParam.$$$reportNull$$$0(4);
        }
        RPsiElement element = context.getArgumentElement();
        String name = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)element);
        Symbol symbolContext = SymbolUtil.getScopeContextWithCaching((PsiElement)element);
        if (symbolContext == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RubyConstantRefParam.$$$reportNull$$$0(5);
            }
            return list;
        }
        Symbol symbol = SymbolUtil.lookupConstant(symbolContext, (PsiElement)element, FQN.ofNullable((String)name), new TypeSet(new Type[]{Type.CONSTANT}), (PsiElement)element);
        if (symbol == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RubyConstantRefParam.$$$reportNull$$$0(6);
            }
            return list;
        }
        return new ArrayList(symbol.getAllDeclarations((PsiElement)element));
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RubyConstantRefParam.$$$reportNull$$$0(7);
        }
        return (PsiElement)ContainerUtil.getOnlyItem(this.multiResolve(context));
    }

    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> consumer, @NotNull Predicate<String> lookupStringFilter) {
        RPsiElement element;
        Symbol contextSymbol;
        if (context == null) {
            RubyConstantRefParam.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            RubyConstantRefParam.$$$reportNull$$$0(9);
        }
        if (lookupStringFilter == null) {
            RubyConstantRefParam.$$$reportNull$$$0(10);
        }
        if ((contextSymbol = SymbolUtil.getScopeContextWithCaching((PsiElement)(element = context.getArgumentElement()))) == null) {
            return;
        }
        Symbol.Filter filter = Symbol.Filter.byType((Type)Type.CONSTANT);
        SymbolUtil.processMembers(contextSymbol, (Predicate<? super Symbol>)filter, (PsiElement)element, (Processor<? super Symbol>)((Processor)symbol -> {
            String name = symbol.getName();
            if (!StringUtil.isEmpty((String)name) && lookupStringFilter.test(name)) {
                consumer.consume((Object)ParamDefImplUtil.createSimpleLookupItem(name, LookupItemType.Symbol, element, AllIcons.Nodes.Constant));
            }
            return true;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/RubyConstantRefParam";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/RubyConstantRefParam";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inspectReference";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAllVariants";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

