/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs;

import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

final class RubyClassifiableRefParam
extends ParamDef {
    static final ParamDef INSTANCE = new RubyClassifiableRefParam();

    private RubyClassifiableRefParam() {
    }

    @Override
    @NotNull
    public String handleRename(@NotNull RubyCallArgumentContext context, @NotNull String newName) {
        if (context == null) {
            RubyClassifiableRefParam.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            RubyClassifiableRefParam.$$$reportNull$$$0(1);
        }
        String string = NamingConventions.toUnderscoreCase((String)newName);
        if (string == null) {
            RubyClassifiableRefParam.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public InspectionResult inspectReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RubyClassifiableRefParam.$$$reportNull$$$0(3);
        }
        RPsiElement element = context.getArgumentElement();
        if (this.multiResolve(context).isEmpty()) {
            if (RubyPsiUtil.isSimpleStringOrSymbol((PsiElement)element)) {
                InspectionResult inspectionResult = InspectionResult.createWarningResult((PsiElement)element, RBundle.message((String)"inspection.paramdef.classifiable.ref.warning"));
                if (inspectionResult == null) {
                    RubyClassifiableRefParam.$$$reportNull$$$0(4);
                }
                return inspectionResult;
            }
            InspectionResult inspectionResult = InspectionResult.createProbablyAcceptibleResult((PsiElement)element);
            if (inspectionResult == null) {
                RubyClassifiableRefParam.$$$reportNull$$$0(5);
            }
            return inspectionResult;
        }
        InspectionResult inspectionResult = InspectionResult.createOkResult((PsiElement)element);
        if (inspectionResult == null) {
            RubyClassifiableRefParam.$$$reportNull$$$0(6);
        }
        return inspectionResult;
    }

    @NotNull
    public List<PsiElement> multiResolve(@NotNull RubyCallArgumentContext context) {
        InflectorService service;
        if (context == null) {
            RubyClassifiableRefParam.$$$reportNull$$$0(7);
        }
        if ((service = (InflectorService)ObjectUtils.doIfNotNull((Object)context.getModule(), InflectorService::getInstance)) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RubyClassifiableRefParam.$$$reportNull$$$0(8);
            }
            return list;
        }
        RPsiElement element = context.getArgumentElement();
        String name = service.classify(RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)element));
        Symbol symbol = SymbolUtil.findConstantByFQN(context.getProject(), Type.CLASS, FQN.ofNullable((String)name), (PsiElement)element);
        if (symbol == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RubyClassifiableRefParam.$$$reportNull$$$0(9);
            }
            return list;
        }
        return new ArrayList<PsiElement>(symbol.getAllDeclarations((PsiElement)element));
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RubyClassifiableRefParam.$$$reportNull$$$0(10);
        }
        return (PsiElement)ContainerUtil.getOnlyItem(this.multiResolve(context));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/RubyClassifiableRefParam";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/RubyClassifiableRefParam";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "handleRename";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectReference";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleRename";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inspectReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 8, 9 -> new IllegalStateException(string);
        };
    }
}

