/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.ParamDefExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.ParamDefOr;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;

@Service
public final class ParamDefManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ParamDefManager.class);
    private static final Set<FQN> KNOWN_DUPLICATES = Set.of(FQN.of((String)"ActiveModel::Validations::ClassMethods.validates"));
    private final Map<FQN, ParamDefExpression> myFullPath2ParamDefExprTable = new HashMap<FQN, ParamDefExpression>();
    private final Set<String> myMethodNames = new HashSet<String>();
    private final Set<FQN> myHighlightedFQNs = new HashSet<FQN>();

    public ParamDefManager() {
        this.collectParamDefsFromExtensions();
        ParamDefProvider.EP_NAME.addChangeListener(this::collectParamDefsFromExtensions, (Disposable)this);
    }

    public void dispose() {
    }

    @NotNull
    public Set<String> getMethodNames() {
        Set<String> set = this.myMethodNames;
        if (set == null) {
            ParamDefManager.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public Set<FQN> getHighlightedFQNs() {
        Set<FQN> set = this.myHighlightedFQNs;
        if (set == null) {
            ParamDefManager.$$$reportNull$$$0(1);
        }
        return set;
    }

    public void registerParamDefExpression(@NotNull FQN methodFqn, @NotNull ParamDefExpression expression) {
        if (methodFqn == null) {
            ParamDefManager.$$$reportNull$$$0(2);
        }
        if (expression == null) {
            ParamDefManager.$$$reportNull$$$0(3);
        }
        this.registerParamDefExpression(methodFqn, expression, true);
    }

    public void registerParamDefExpression(@NotNull FQN methodFqn, @NotNull ParamDefExpression expression, boolean highlight) {
        if (methodFqn == null) {
            ParamDefManager.$$$reportNull$$$0(4);
        }
        if (expression == null) {
            ParamDefManager.$$$reportNull$$$0(5);
        }
        if (this.myFullPath2ParamDefExprTable.containsKey(methodFqn) && !KNOWN_DUPLICATES.contains(methodFqn)) {
            LOG.error("%s is already a registered parameter definition".formatted(methodFqn));
            return;
        }
        this.myMethodNames.add(methodFqn.getShortName());
        if (highlight) {
            this.myHighlightedFQNs.add(methodFqn);
        }
        this.myFullPath2ParamDefExprTable.merge(methodFqn, expression, (existing, it) -> new ParamDefOr((ParamDefExpression)existing, (ParamDefExpression)it));
    }

    public void registerParamDefCopy(@NotNull FQN originalMethodFqn, @NotNull FQN methodFqn) {
        if (originalMethodFqn == null) {
            ParamDefManager.$$$reportNull$$$0(6);
        }
        if (methodFqn == null) {
            ParamDefManager.$$$reportNull$$$0(7);
        }
        if (!this.myFullPath2ParamDefExprTable.containsKey(originalMethodFqn)) {
            LOG.error("%s is not a registered parameter definition".formatted(methodFqn));
            return;
        }
        ParamDefExpression expression = this.myFullPath2ParamDefExprTable.get(originalMethodFqn);
        boolean highlight = this.myHighlightedFQNs.contains(originalMethodFqn);
        this.registerParamDefExpression(methodFqn, expression, highlight);
    }

    public void registerParamDefHighlight(@NotNull FQN methodFqn) {
        if (methodFqn == null) {
            ParamDefManager.$$$reportNull$$$0(8);
        }
        this.myHighlightedFQNs.add(methodFqn);
    }

    @Nullable
    public ParamDefExpression getParamDefExpression(@NotNull FQN methodFqn) {
        if (methodFqn == null) {
            ParamDefManager.$$$reportNull$$$0(9);
        }
        return this.myFullPath2ParamDefExprTable.get(RObjectClass.makeNonSingletonClassFqn((FQN)methodFqn));
    }

    @TestOnly
    public void unregisterParamDef(@NotNull FQN fqn) {
        if (fqn == null) {
            ParamDefManager.$$$reportNull$$$0(10);
        }
        this.myFullPath2ParamDefExprTable.remove(fqn);
        this.myMethodNames.remove(fqn.getShortName());
        this.myHighlightedFQNs.remove(fqn);
    }

    private void collectParamDefsFromExtensions() {
        this.myFullPath2ParamDefExprTable.clear();
        this.myMethodNames.clear();
        this.myHighlightedFQNs.clear();
        for (ParamDefProvider provider : ParamDefProvider.EP_NAME.getExtensionList()) {
            provider.registerParamDefs(this);
        }
    }

    @NotNull
    public static ParamDefManager getInstance() {
        ParamDefManager paramDefManager = (ParamDefManager)ApplicationManager.getApplication().getService(ParamDefManager.class);
        if (paramDefManager == null) {
            ParamDefManager.$$$reportNull$$$0(11);
        }
        return paramDefManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/ParamDefManager";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodFqn";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalMethodFqn";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightedFQNs";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/ParamDefManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerParamDefExpression";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerParamDefCopy";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerParamDefHighlight";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParamDefExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unregisterParamDef";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

