/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import icons.RubyIcons;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefImplUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.ParamDefHash;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class HashKeyParamDef
extends ParamDef {
    private final ParamDefHash myHash;

    public HashKeyParamDef(ParamDefHash hash) {
        this.myHash = hash;
    }

    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementsConsumer, @NotNull Predicate<String> lookupStringFilter) {
        if (context == null) {
            HashKeyParamDef.$$$reportNull$$$0(0);
        }
        if (elementsConsumer == null) {
            HashKeyParamDef.$$$reportNull$$$0(1);
        }
        if (lookupStringFilter == null) {
            HashKeyParamDef.$$$reportNull$$$0(2);
        }
        RPsiElement value = context.getArgumentElement();
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)value);
        String prefix = value instanceof RSymbol ? "" : ":";
        boolean mayHave19 = !(value instanceof RSymbol) && languageLevel != LanguageLevel.RUBY18;
        Set<String> usedKeys = HashKeyParamDef.collectUsedKeys(value);
        for (String key : this.myHash.getKeys(context)) {
            if (this.myHash.isSymbolKey(key) && value instanceof RBaseString || usedKeys.contains(key)) continue;
            if (mayHave19 && lookupStringFilter.test(key + prefix)) {
                elementsConsumer.consume((Object)HashKeyParamDef.createHashKeyCompletionVariant(key + prefix, value, true));
            }
            if (this.myHash.acceptsOnly19() || value instanceof RAssocKey || !lookupStringFilter.test(prefix + key)) continue;
            elementsConsumer.consume((Object)HashKeyParamDef.createHashKeyCompletionVariant(prefix + key, value, false));
        }
    }

    private static Set<String> collectUsedKeys(RPsiElement value) {
        PsiElement psiElement = value.getParent();
        if (psiElement instanceof RAssoc) {
            RAssoc theAssoc = (RAssoc)psiElement;
            PsiElement psiElement2 = theAssoc.getParent();
            if (psiElement2 instanceof RAssocList) {
                RAssocList assocList = (RAssocList)psiElement2;
                return HashKeyParamDef.collectUsedKeys(assocList.getElements(), theAssoc);
            }
            psiElement2 = theAssoc.getParent();
            if (psiElement2 instanceof RListOfExpressions) {
                RListOfExpressions listOfExpressions = (RListOfExpressions)psiElement2;
                return HashKeyParamDef.collectUsedKeys(listOfExpressions.getElements(), theAssoc);
            }
        }
        return Collections.emptySet();
    }

    private static Set<String> collectUsedKeys(List<RPsiElement> elements, RAssoc theAssoc) {
        HashSet<String> result = new HashSet<String>();
        for (RPsiElement element : elements) {
            if (element == theAssoc) continue;
            if (element.getTextRange().getStartOffset() > theAssoc.getTextRange().getEndOffset()) break;
            if (!(element instanceof RAssoc)) continue;
            result.add(((RAssoc)element).getKeyText());
        }
        return result;
    }

    @Override
    @NotNull
    public InspectionResult inspectReference(@NotNull RubyCallArgumentContext context) {
        RPsiElement value;
        if (context == null) {
            HashKeyParamDef.$$$reportNull$$$0(3);
        }
        if (!((value = context.getArgumentElement()).getParent() instanceof RAssoc)) {
            InspectionResult inspectionResult = InspectionResult.createNotApplicableResult((PsiElement)value, "Hash");
            if (inspectionResult == null) {
                HashKeyParamDef.$$$reportNull$$$0(4);
            }
            return inspectionResult;
        }
        if (!this.myHash.areKeysOptional() && (value instanceof RSymbol || value instanceof RStringLiteral)) {
            String key = RubyPsiUtilCore.getElementText((PsiElement)value);
            if (!this.myHash.hasKey(context, key)) {
                InspectionResult inspectionResult = InspectionResult.createWarningResult((PsiElement)value, RBundle.message((String)"inspection.paramdef.hash.unexpected.key", (Object[])new Object[]{value.getText()}));
                if (inspectionResult == null) {
                    HashKeyParamDef.$$$reportNull$$$0(5);
                }
                return inspectionResult;
            }
            if (this.myHash.isSymbolKey(key) && value instanceof RStringLiteral) {
                InspectionResult inspectionResult = InspectionResult.createWarningResult((PsiElement)value, RBundle.message((String)"inspection.paramdef.hash.unexpected.key.type", (Object[])new Object[]{((RStringLiteral)value).getContent()}));
                if (inspectionResult == null) {
                    HashKeyParamDef.$$$reportNull$$$0(6);
                }
                return inspectionResult;
            }
        }
        InspectionResult inspectionResult = InspectionResult.createOkResult((PsiElement)value);
        if (inspectionResult == null) {
            HashKeyParamDef.$$$reportNull$$$0(7);
        }
        return inspectionResult;
    }

    public static LookupElement createHashKeyCompletionVariant(String keyTextPresentation, final RPsiElement child, final boolean is19) {
        InsertHandler<LookupElement> insertHandler = new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                int offset;
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                Editor editor = context.getEditor();
                int tailOffset = context.getTailOffset();
                PsiElement parent = child.getParent();
                if (parent instanceof RAssoc) {
                    RAssoc assoc = (RAssoc)parent;
                    RPsiElement key = assoc.getKey();
                    assert (key != null);
                    PsiElement value = assoc.getLastChild();
                    assert (value != null);
                    int identifierEnd = context.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET);
                    int adjust = 0;
                    if (key instanceof RAssocKey) {
                        char nextChar = editor.getDocument().getCharsSequence().charAt(identifierEnd - 1);
                        char currentChar = editor.getDocument().getCharsSequence().charAt(identifierEnd);
                        if (nextChar == ':' && currentChar == ':') {
                            editor.getDocument().deleteString(identifierEnd - 1, identifierEnd);
                            adjust = -1;
                        }
                    }
                    offset = identifierEnd + value.getTextRange().getStartOffset() - key.getTextRange().getEndOffset() + adjust;
                } else if (!is19) {
                    offset = tailOffset + 4;
                    editor.getDocument().insertString(tailOffset, (CharSequence)" => ");
                } else {
                    offset = tailOffset + 1;
                    editor.getDocument().insertString(tailOffset, (CharSequence)" ");
                }
                editor.getCaretModel().moveToOffset(offset);
                assert (!PsiDocumentManager.getInstance((Project)context.getProject()).isDocumentBlockedByPsi(editor.getDocument())) : "InsertHandler has left document locked by PSI operations: " + String.valueOf(this);
                char completionChar = context.getCompletionChar();
                TailType tailType = LookupItem.getDefaultTailType((char)completionChar);
                if (tailType != null) {
                    tailType.processTail(editor, tailOffset);
                }
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().removeSelection();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/HashKeyParamDef$1";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        return ParamDefImplUtil.createLookupElement(keyTextPresentation, null, child, RubyIcons.Ruby.HashKey, insertHandler, RubyCompletionGrouping.PARAMDEF_HASH_KEY);
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            HashKeyParamDef.$$$reportNull$$$0(8);
        }
        return this.myHash.resolveKey(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/HashKeyParamDef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/HashKeyParamDef";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processAllVariants";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inspectReference";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

