/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.ParamDefResolveVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefImplUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubySymbolParamDef;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.RConstantImpl;

public class EnumParam
extends ParamDef {
    private final Collection<?> myVariants;
    private final boolean myAllowBothStrAndSymb;

    protected EnumParam(Collection<?> variants, boolean allowBothStrAndSymb, boolean optional) {
        super(optional);
        this.myVariants = variants;
        this.myAllowBothStrAndSymb = allowBothStrAndSymb;
    }

    public static EnumParam createOneOf(Collection<?> variants) {
        return new EnumParam(variants, false, false);
    }

    public static EnumParam createOneOfAllowingStrAndSymb(Collection<?> variants) {
        return new EnumParam(variants, true, false);
    }

    public static EnumParam createMaybeOneOf(Collection<?> variants) {
        return new EnumParam(variants, false, true);
    }

    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementsConsumer, @NotNull Predicate<String> lookupStringFilter) {
        RPsiElement element;
        if (context == null) {
            EnumParam.$$$reportNull$$$0(0);
        }
        if (elementsConsumer == null) {
            EnumParam.$$$reportNull$$$0(1);
        }
        if (lookupStringFilter == null) {
            EnumParam.$$$reportNull$$$0(2);
        }
        if (!(ParamDefResolveVisitor.isSimple((PsiElement)(element = context.getArgumentElement())) && !ParamDefResolveVisitor.isProbablyAcceptable((PsiElement)element) || RConstantImpl.isDummyIdentifier((PsiElement)element))) {
            return;
        }
        for (Object variant : this.myVariants) {
            LookupItemType lookupItemType;
            if (EnumParam.isRubySymbol(variant)) {
                if (element instanceof RStringLiteral) continue;
                lookupItemType = LookupItemType.Symbol;
            } else {
                if (element instanceof RSymbol) continue;
                lookupItemType = LookupItemType.String;
            }
            if (!lookupStringFilter.test(variant.toString())) continue;
            elementsConsumer.consume((Object)ParamDefImplUtil.createSimpleLookupItem(variant.toString(), lookupItemType, context.getArgumentElement(), null));
        }
    }

    @Override
    @NotNull
    public InspectionResult inspectReference(@NotNull RubyCallArgumentContext context) {
        RPsiElement element;
        if (context == null) {
            EnumParam.$$$reportNull$$$0(3);
        }
        if (!ParamDefResolveVisitor.isSimple((PsiElement)(element = context.getArgumentElement()))) {
            if (ParamDefResolveVisitor.isProbablyAcceptable((PsiElement)element)) {
                InspectionResult inspectionResult = InspectionResult.createProbablyAcceptibleResult((PsiElement)element);
                if (inspectionResult == null) {
                    EnumParam.$$$reportNull$$$0(4);
                }
                return inspectionResult;
            }
            InspectionResult inspectionResult = InspectionResult.createNotApplicableResult((PsiElement)element, "String", "Symbol");
            if (inspectionResult == null) {
                EnumParam.$$$reportNull$$$0(5);
            }
            return inspectionResult;
        }
        String elementText = EnumParam.getTextPresentationForPsiElement(element);
        for (Object variant : this.myVariants) {
            String variantText = EnumParam.getTextPresentation(variant);
            if (!EnumParam.isRubySymbol(variant) ? element instanceof RSymbol && !this.myAllowBothStrAndSymb : element instanceof RStringLiteral && !this.myAllowBothStrAndSymb) continue;
            if (variantText.equals(elementText)) {
                InspectionResult inspectionResult = InspectionResult.createOkResult((PsiElement)element);
                if (inspectionResult == null) {
                    EnumParam.$$$reportNull$$$0(6);
                }
                return inspectionResult;
            }
            if (!this.myAllowBothStrAndSymb || !StringUtil.trimStart((String)variantText, (String)":").equals(StringUtil.trimStart((String)elementText, (String)":"))) continue;
            InspectionResult inspectionResult = InspectionResult.createOkResult((PsiElement)element);
            if (inspectionResult == null) {
                EnumParam.$$$reportNull$$$0(7);
            }
            return inspectionResult;
        }
        if (this.isOptional()) {
            InspectionResult inspectionResult = InspectionResult.createProbablyAcceptibleResult((PsiElement)element);
            if (inspectionResult == null) {
                EnumParam.$$$reportNull$$$0(8);
            }
            return inspectionResult;
        }
        InspectionResult inspectionResult = InspectionResult.createNotApplicableResult((PsiElement)element, (String[])ContainerUtil.map2Array(this.myVariants, String.class, o -> "'" + EnumParam.getTextPresentation(o) + "'"));
        if (inspectionResult == null) {
            EnumParam.$$$reportNull$$$0(9);
        }
        return inspectionResult;
    }

    public static boolean isRubySymbol(Object variant) {
        return variant instanceof RubySymbolParamDef;
    }

    @NotNull
    private static String getTextPresentation(@NotNull Object symbolOrString) {
        if (symbolOrString == null) {
            EnumParam.$$$reportNull$$$0(10);
        }
        String string = (EnumParam.isRubySymbol(symbolOrString) ? ":" : "") + String.valueOf(symbolOrString);
        if (string == null) {
            EnumParam.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/EnumParam";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolOrString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/EnumParam";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectReference";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processAllVariants";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inspectReference";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTextPresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 11 -> new IllegalStateException(string);
        };
    }
}

