/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.nativerb;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyScriptExecutionContext;

public final class StubsGenRunner {
    public static final String STUB_GEN_DIRECTORY = "rb/stubsgen/";
    public static final String STUB_GEN_SCRIPT = "gen_stubs.rb";
    public static final String VERSION = "1";
    private static final Logger LOG = Logger.getInstance(StubsGenRunner.class);

    private StubsGenRunner() {
    }

    public static ThreeState generateStubs(@NotNull Module module, GemInfo gem, File outputFolder) {
        VirtualFile dir;
        if (module == null) {
            StubsGenRunner.$$$reportNull$$$0(0);
        }
        if ((dir = gem.getFile()) == null || !dir.isValid()) {
            return ThreeState.UNSURE;
        }
        Ref hasCFiles = Ref.create((Object)false);
        ContentIterator iterator = fileOrDir -> {
            String extension = StubsGenRunner.isRegularFile(fileOrDir) ? fileOrDir.getExtension() : null;
            hasCFiles.set((Object)"c".equals(extension));
            return (Boolean)hasCFiles.get() == false;
        };
        Optional ext = StreamEx.of((Object[])dir.getChildren()).findFirst(it -> it.isValid() && it.isDirectory() && "ext".equals(it.getName()));
        if (ext.isEmpty()) {
            return ThreeState.NO;
        }
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)((VirtualFile)ext.get()), (VirtualFileFilter)VirtualFileFilter.ALL, (ContentIterator)iterator);
        if (!((Boolean)hasCFiles.get()).booleanValue()) {
            return ThreeState.NO;
        }
        try {
            String workingDir = RubyUtil.getScriptFullPath(STUB_GEN_DIRECTORY);
            String stubsGenPath = RubyUtil.getScriptFullPath("rb/stubsgen/gen_stubs.rb");
            LOG.assertTrue(stubsGenPath != null);
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            if (sdk == null) {
                LOG.warn("No sdk for module - " + String.valueOf(module));
                return ThreeState.UNSURE;
            }
            RubyRunner runner = RunnerUtil.getRunner(sdk, module);
            if (!(runner instanceof RubyLocalRunner) || runner.getClass().getSimpleName().contains("WSL")) {
                LOG.warn("Unable to build stubs for remote sdk: " + String.valueOf(sdk));
                return ThreeState.UNSURE;
            }
            ProcessOutput output2 = ((RubyScriptExecutionContext)((RubyScriptExecutionContext)((RubyScriptExecutionContext)((RubyScriptExecutionContext)RubyScriptExecutionContext.create(stubsGenPath, sdk).withModule(module)).withWorkingDirPath(workingDir)).inSameThread()).withArguments("-d", dir.getPath(), "-s", StubsGenRunner.getStubName(gem), "-o", outputFolder.getAbsolutePath())).executeScript();
            if (output2 != null && !output2.getStderr().isEmpty()) {
                LOG.warn("Error running stubs generator for " + gem.getName() + ": " + output2.getStderr());
            }
            return ThreeState.YES;
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            return ThreeState.UNSURE;
        }
    }

    private static boolean isRegularFile(VirtualFile fileOrDir) {
        return fileOrDir.exists() && !fileOrDir.isDirectory() && !fileOrDir.is(VFileProperty.SPECIAL);
    }

    private static String getStubName(GemInfo gem) {
        return "gem " + gem.getName() + ", v. " + gem.getVersion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/ruby/ruby/codeInsight/nativerb/StubsGenRunner", "generateStubs"));
    }
}

