/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyLineMarkerTooltipUtil;

public final class RubyPartialDeclarationsTooltipSupplier
implements Supplier<String> {
    private final Map<PsiElement, String> myDeclarationRelativePaths;

    public RubyPartialDeclarationsTooltipSupplier(@NotNull Map<? extends PsiElement, String> declarationRelativePaths) {
        if (declarationRelativePaths == null) {
            RubyPartialDeclarationsTooltipSupplier.$$$reportNull$$$0(0);
        }
        this.myDeclarationRelativePaths = declarationRelativePaths.size() <= 5 ? Map.copyOf(declarationRelativePaths) : Collections.emptyMap();
    }

    @Override
    @NotNull
    public String get() {
        HtmlBuilder builder2 = new HtmlBuilder();
        List presentableDeclarations = ContainerUtil.filter(this.myDeclarationRelativePaths.keySet(), PsiElement::isValid);
        int count = presentableDeclarations.size();
        if (count == 1) {
            PsiElement declaration = (PsiElement)presentableDeclarations.get(0);
            String relativePath = this.myDeclarationRelativePaths.get(declaration);
            builder2.append((HtmlChunk)HtmlChunk.div().style("padding-top: 2px;").addText(RBundle.message((String)"line.marker.partial.declarations.tooltip.one") + " ").child(RubyLineMarkerTooltipUtil.fileSpan(declaration, relativePath)));
        } else if (0 < count && count <= 5) {
            builder2.append((HtmlChunk)HtmlChunk.p().style("padding-top: 2px;").addText(RBundle.message((String)"line.marker.partial.declarations.tooltip.few")));
            for (PsiElement declaration : presentableDeclarations) {
                builder2.append((HtmlChunk)RubyLineMarkerTooltipUtil.row().child(RubyLineMarkerTooltipUtil.fileSpan(declaration, this.myDeclarationRelativePaths.get(declaration))));
            }
        } else if (this.myDeclarationRelativePaths.isEmpty()) {
            builder2.append((HtmlChunk)HtmlChunk.div().style("padding-top: 2px;").addText(RBundle.message((String)"line.marker.partial.declarations.tooltip.many")));
        }
        String string = builder2.wrapWithHtmlBody().toString();
        if (string == null) {
            RubyPartialDeclarationsTooltipSupplier.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static Map<PsiElement, String> getDeclarationRelativePaths(@NotNull Project project, @NotNull List<? extends PsiElement> declarations) {
        if (project == null) {
            RubyPartialDeclarationsTooltipSupplier.$$$reportNull$$$0(2);
        }
        if (declarations == null) {
            RubyPartialDeclarationsTooltipSupplier.$$$reportNull$$$0(3);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        LinkedHashMap<PsiElement, String> declarationRelativePaths = new LinkedHashMap<PsiElement, String>();
        for (PsiElement psiElement : declarations) {
            String relativePath;
            VirtualFile contentRoot;
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
            if (file == null || (contentRoot = (VirtualFile)ObjectUtils.coalesce((Object)fileIndex.getContentRootForFile(file), (Object)fileIndex.getClassRootForFile(file))) == null || (relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot, (char)File.separatorChar)) == null) continue;
            declarationRelativePaths.put(psiElement, relativePath);
        }
        Map<PsiElement, String> map = Collections.unmodifiableMap(declarationRelativePaths);
        if (map == null) {
            RubyPartialDeclarationsTooltipSupplier.$$$reportNull$$$0(4);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationRelativePaths";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/lineMarkers/RubyPartialDeclarationsTooltipSupplier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/lineMarkers/RubyPartialDeclarationsTooltipSupplier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationRelativePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationRelativePaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

