/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.navigation.PsiElementNavigationTarget;
import org.jetbrains.plugins.ruby.model.navigation.TargetPresentationUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyFileTargetLineMarkerTooltipSupplier;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyGutterIconNavigationHandler;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyLineMarkerProvider;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public final class RubyPartialDeclarationsLineMarkerProvider
extends LineMarkerProviderDescriptor {
    private static final List<IElementType> LEAF_ELEMENT_TYPES = List.of(RubyTokenTypes.tCONSTANT, RubyTokenTypes.tCOLON2);

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            RubyPartialDeclarationsLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            RubyPartialDeclarationsLineMarkerProvider.$$$reportNull$$$0(1);
        }
        for (PsiElement element2 : ContainerUtil.filter(elements, element -> LEAF_ELEMENT_TYPES.contains(PsiUtilCore.getElementType((PsiElement)element)))) {
            RContainer container;
            PsiElement parent = element2.getParent();
            if (parent == null || !RubyLineMarkerProvider.isNameElement(parent.getParent()) || !((container = (RContainer)ObjectUtils.tryCast((Object)parent.getParent().getParent(), RContainer.class)) instanceof RClass) && !(container instanceof RModule)) continue;
            RubyPartialDeclarationsLineMarkerProvider.addPartialElementMarker(element2, container, result);
        }
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = RubyIcons.Ruby.PartialClass_14x14;
        if (icon == null) {
            RubyPartialDeclarationsLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            RubyPartialDeclarationsLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return null;
    }

    @NotNull
    public String getName() {
        String string = RBundle.message((String)"line.marker.partial.declarations");
        if (string == null) {
            RubyPartialDeclarationsLineMarkerProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static void addPartialElementMarker(PsiElement element, RContainer container, Collection<? super LineMarkerInfo<?>> result) {
        List<PsiElementNavigationTarget> targets = RubyFQNUtil.getFQNBasedPartialDeclarations(container, false, (PsiElement)container).stream().map(it -> new PsiElementNavigationTarget<RContainer>((RContainer)it, TargetPresentationUtil.createTargetPresentation((NavigatablePsiElement)it))).sorted().toList();
        if (targets.isEmpty()) {
            return;
        }
        Icon icon = container instanceof RClass ? RubyIcons.Ruby.PartialClass_14x14 : RubyIcons.Ruby.PartialModule_14x14;
        MyNavigationHandler navigationHandler = new MyNavigationHandler(targets);
        MyTooltipSupplier tooltipSupplier = new MyTooltipSupplier(targets);
        result.add(new LineMarkerInfo(element, element.getTextRange(), icon, arg_0 -> RubyPartialDeclarationsLineMarkerProvider.lambda$addPartialElementMarker$2((Supplier)tooltipSupplier, arg_0), (GutterIconNavigationHandler)navigationHandler, GutterIconRenderer.Alignment.RIGHT));
    }

    private static /* synthetic */ String lambda$addPartialElementMarker$2(Supplier tooltipSupplier, PsiElement __) {
        return (String)tooltipSupplier.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/lineMarkers/RubyPartialDeclarationsLineMarkerProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/lineMarkers/RubyPartialDeclarationsLineMarkerProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    private static final class MyNavigationHandler
    extends RubyGutterIconNavigationHandler {
        private MyNavigationHandler(@NotNull List<? extends NavigationTarget> targets) {
            if (targets == null) {
                MyNavigationHandler.$$$reportNull$$$0(0);
            }
            super(targets);
        }

        @Override
        @Nls
        @NotNull
        protected String getPopupTitle() {
            String string = RBundle.message((String)"line.marker.partial.declarations.title");
            if (string == null) {
                MyNavigationHandler.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/lineMarkers/RubyPartialDeclarationsLineMarkerProvider$MyNavigationHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/lineMarkers/RubyPartialDeclarationsLineMarkerProvider$MyNavigationHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPopupTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyTooltipSupplier
    extends RubyFileTargetLineMarkerTooltipSupplier {
        MyTooltipSupplier(@NotNull List<? extends NavigationTarget> targets) {
            if (targets == null) {
                MyTooltipSupplier.$$$reportNull$$$0(0);
            }
            super(targets);
        }

        @Override
        @Nls
        @NotNull
        protected String getFewTooltip() {
            String string = RBundle.message((String)"line.marker.partial.declarations.tooltip.few");
            if (string == null) {
                MyTooltipSupplier.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        protected String getManyTooltip() {
            String string = RBundle.message((String)"line.marker.partial.declarations.tooltip.many");
            if (string == null) {
                MyTooltipSupplier.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        protected String getOneTooltip() {
            String string = RBundle.message((String)"line.marker.partial.declarations.tooltip.one");
            if (string == null) {
                MyTooltipSupplier.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/lineMarkers/RubyPartialDeclarationsLineMarkerProvider$MyTooltipSupplier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/lineMarkers/RubyPartialDeclarationsLineMarkerProvider$MyTooltipSupplier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFewTooltip";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getManyTooltip";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOneTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

