/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers;

import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.navigation.NavigationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import java.io.File;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.LinkableNavigationTarget;

public final class RubyLineMarkerTooltipUtil {
    private static final TextAttributes EMPTY_TEXT_ATTRIBUTES = new TextAttributes();
    private static final JBColor INFO_FOREGROUND = JBColor.namedColor((String)"GutterTooltip.infoForeground", (Color)new JBColor(0x787878, 0x878787));
    @NlsSafe
    private static final String FILE_SEPARATOR = File.separator;
    @NlsSafe
    private static final String PARENTHESISED_FORMAT = "(%s)";

    private RubyLineMarkerTooltipUtil() {
    }

    @NotNull
    public static HtmlChunk fileSpan(@NotNull NavigationTarget target, @NlsSafe @NotNull String filepath) {
        if (target == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(0);
        }
        if (filepath == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(1);
        }
        String filename = (String)ObjectUtils.coalesce((Object)StringUtil.substringAfterLast((String)filepath, (String)FILE_SEPARATOR), (Object)filepath);
        String directory = filepath.contains(FILE_SEPARATOR) ? StringUtil.substringBeforeLast((String)filepath, (String)FILE_SEPARATOR) : null;
        return RubyLineMarkerTooltipUtil.fileSpan(target, filename, directory);
    }

    @NotNull
    public static HtmlChunk fileSpan(@NotNull NavigationTarget target, @NotNull TargetPresentation presentation) {
        if (target == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(2);
        }
        if (presentation == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(3);
        }
        return RubyLineMarkerTooltipUtil.fileSpan(target, presentation.getPresentableText(), presentation.getContainerText());
    }

    @NotNull
    public static HtmlChunk fileSpan(@NotNull NavigationTarget target, @NlsSafe @NotNull String name, @NlsSafe @Nullable String filepath) {
        if (target == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(4);
        }
        if (name == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(5);
        }
        if (filepath == null) {
            HtmlChunk.Element element = HtmlChunk.span().child((HtmlChunk)RubyLineMarkerTooltipUtil.link(target, name).code());
            if (element == null) {
                RubyLineMarkerTooltipUtil.$$$reportNull$$$0(6);
            }
            return element;
        }
        HtmlChunk.Element element = HtmlChunk.span().child((HtmlChunk)RubyLineMarkerTooltipUtil.link(target, name).code()).addText(" ").child((HtmlChunk)HtmlChunk.font((String)("#" + ColorUtil.toHex((Color)INFO_FOREGROUND))).addText(PARENTHESISED_FORMAT.formatted(filepath)).code());
        if (element == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(7);
        }
        return element;
    }

    @NotNull
    public static HtmlChunk fileSpan(@NotNull PsiElement target, @NlsSafe @NotNull String filepath) {
        if (target == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(8);
        }
        if (filepath == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(9);
        }
        String filename = (String)ObjectUtils.coalesce((Object)StringUtil.substringAfterLast((String)filepath, (String)FILE_SEPARATOR), (Object)filepath);
        String directory = filepath.contains(FILE_SEPARATOR) ? StringUtil.substringBeforeLast((String)filepath, (String)FILE_SEPARATOR) : null;
        HtmlChunk.Element chunk = HtmlChunk.span().child((HtmlChunk)RubyLineMarkerTooltipUtil.link(target, filename).code());
        if (directory != null) {
            chunk = chunk.addText(" ");
            chunk = chunk.child((HtmlChunk)HtmlChunk.font((String)("#" + ColorUtil.toHex((Color)INFO_FOREGROUND))).addText(PARENTHESISED_FORMAT.formatted(directory)).code());
        }
        HtmlChunk.Element element = chunk;
        if (element == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(10);
        }
        return element;
    }

    @NotNull
    public static HtmlChunk link(@NotNull NavigationTarget target, @Nls @NotNull String text) {
        if (target == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(11);
        }
        if (text == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(12);
        }
        if (!(target instanceof LinkableNavigationTarget)) {
            HtmlChunk htmlChunk = HtmlChunk.text((String)text);
            if (htmlChunk == null) {
                RubyLineMarkerTooltipUtil.$$$reportNull$$$0(13);
            }
            return htmlChunk;
        }
        LinkableNavigationTarget linkableTarget = (LinkableNavigationTarget)target;
        TextAttributes attributes = (TextAttributes)ObjectUtils.coalesce((Object)linkableTarget.getLinkTextAttributes(), (Object)EMPTY_TEXT_ATTRIBUTES);
        @NlsSafe String span = QuickDocHighlightingHelper.getStyledFragment((String)HtmlChunk.link((String)linkableTarget.getLink(), (String)text).toString(), (TextAttributes)attributes);
        HtmlChunk htmlChunk = HtmlChunk.raw((String)span);
        if (htmlChunk == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(14);
        }
        return htmlChunk;
    }

    @NotNull
    public static HtmlChunk link(@NotNull PsiElement target, @Nls @NotNull String text) {
        if (target == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(15);
        }
        if (text == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(16);
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)target);
        int offset = target.getTextOffset();
        Object object = file != null ? HtmlChunk.link((String)String.format("#navigation/%s:%d", file.getPath(), offset), (String)text) : HtmlChunk.text((String)text);
        if (object == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(17);
        }
        return object;
    }

    @NotNull
    public static HtmlChunk.Element row() {
        HtmlChunk.Element element = HtmlChunk.div().style("margin-top: 2pt; margin-left: 20pt;");
        if (element == null) {
            RubyLineMarkerTooltipUtil.$$$reportNull$$$0(18);
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 10, 13, 14, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filepath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/lineMarkers/RubyLineMarkerTooltipUtil";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/lineMarkers/RubyLineMarkerTooltipUtil";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fileSpan";
                break;
            }
            case 13: 
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "link";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "row";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fileSpan";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "link";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 10, 13, 14, 17, 18 -> new IllegalStateException(string);
        };
    }
}

