/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyLineSeparatorProvider;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;

public final class RubyLineMarkerProvider
implements LineMarkerProvider,
RubyLineSeparatorProvider {
    public static final List<IElementType> LEAF_ELEMENT_TYPES = List.of(RubyTokenTypes.tIDENTIFIER, RubyTokenTypes.tFID, RubyTokenTypes.tCONSTANT, RubyTokenTypes.tCOLON2);

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            RubyLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (!(element instanceof RPsiElement)) {
            return null;
        }
        if (DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS) {
            return RubyLineMarkerProvider.getLineSeparator(this, element);
        }
        return null;
    }

    public static boolean isNameElement(PsiElement element) {
        PsiElement parent = element == null ? null : element.getParent();
        return parent instanceof RMethod && element == ((RMethod)parent).getMethodName() || parent instanceof RClass && element == ((RClass)parent).getClassName() || parent instanceof RModule && element == ((RModule)parent).getModuleName();
    }

    @Override
    public boolean isSeparatorAllowed(PsiElement element) {
        return element instanceof RMethod || element instanceof RClass || element instanceof RModule;
    }

    @Nullable
    public static LineMarkerInfo<?> getLineSeparator(RubyLineSeparatorProvider provider, PsiElement element) {
        Ref info = new Ref(null);
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!provider.isSeparatorAllowed(element)) {
                return;
            }
            boolean hasSeparableBefore = false;
            PsiElement parent = element.getParent();
            if (parent == null) {
                return;
            }
            for (PsiElement child : parent.getChildren()) {
                if (child == element) break;
                if (!(child instanceof RPsiElement) || !provider.isSeparatorAllowed(child)) continue;
                hasSeparableBefore = true;
                break;
            }
            if (!hasSeparableBefore) {
                return;
            }
            info.set(RubyLineMarkerProvider.createLineSeparatorByElement(element));
        });
        return (LineMarkerInfo)info.get();
    }

    private static LineMarkerInfo<PsiElement> createLineSeparatorByElement(PsiElement element) {
        List comments = RubyCommentsUtilCore.getPsiComments((PsiElement)element);
        PsiElement anchor = comments.isEmpty() ? element : (PsiElement)comments.get(0);
        PsiElement leaf = PsiTreeUtil.getDeepestFirst((PsiElement)anchor);
        LineMarkerInfo info = new LineMarkerInfo(leaf, leaf.getTextRange(), null, null, null, GutterIconRenderer.Alignment.RIGHT);
        info.separatorColor = EditorColorsManager.getInstance().getGlobalScheme().getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info.separatorPlacement = SeparatorPlacement.TOP;
        return info;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/ruby/ruby/codeInsight/lineMarkers/RubyLineMarkerProvider", "getLineMarkerInfo"));
    }
}

