/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion.qualifiedName;

import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.FList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.qualifiedName.RubyCompletionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;

public final class RubyQualifiedNamePrefixMatcher
extends PrefixMatcher {
    private final FQN myContainerFqn;
    private final String myQualifier;
    private final PrefixMatcher myQualifierMatcher;
    private final CamelHumpMatcher myLastComponentMatcher;
    private final boolean myIsFuzzySearch;

    public RubyQualifiedNamePrefixMatcher(@NotNull FQN containerFqn, @NotNull String prefix, boolean isFuzzySearch) {
        if (containerFqn == null) {
            RubyQualifiedNamePrefixMatcher.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            RubyQualifiedNamePrefixMatcher.$$$reportNull$$$0(1);
        }
        super(prefix);
        Pair<String, String> qualifierAndName = RubyQualifiedNamePrefixMatcher.getQualifierAndName(prefix);
        this.myContainerFqn = containerFqn;
        this.myQualifier = (String)qualifierAndName.first;
        this.myQualifierMatcher = new PlainPrefixMatcher(this.myQualifier, true);
        this.myLastComponentMatcher = new CamelHumpMatcher((String)qualifierAndName.second);
        this.myIsFuzzySearch = isFuzzySearch;
    }

    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        if (prefix == null) {
            RubyQualifiedNamePrefixMatcher.$$$reportNull$$$0(2);
        }
        return new RubyQualifiedNamePrefixMatcher(this.myContainerFqn, prefix, this.myIsFuzzySearch);
    }

    public boolean prefixMatches(@NotNull LookupElement element) {
        if (element == null) {
            RubyQualifiedNamePrefixMatcher.$$$reportNull$$$0(3);
        }
        return this.prefixMatches(element.getLookupString());
    }

    public boolean prefixMatches(@NotNull String name) {
        if (name == null) {
            RubyQualifiedNamePrefixMatcher.$$$reportNull$$$0(4);
        }
        if (!this.qualifierMatches(name)) {
            return false;
        }
        return this.myLastComponentMatcher.prefixMatches(StringUtil.strip((String)name, c -> c != ':'));
    }

    private boolean qualifierMatches(@NotNull String name) {
        if (name == null) {
            RubyQualifiedNamePrefixMatcher.$$$reportNull$$$0(5);
        }
        if (this.myQualifier.isEmpty() || this.myQualifier.equals("::")) {
            return this.myIsFuzzySearch || name.lastIndexOf("::") <= 0;
        }
        for (String candidate : RubyCompletionUtil.getCandidateRelativeQualifiedNames(this.myContainerFqn, StringUtil.trimStart((String)name, (String)"::"))) {
            String qualifier = candidate.contains("::") ? StringUtil.substringBeforeLast((String)candidate, (String)"::") + "::" : null;
            if (qualifier == null || !this.myQualifierMatcher.prefixMatches(qualifier)) continue;
            return this.myIsFuzzySearch || !StringUtil.trimStart((String)candidate, (String)this.myQualifier).contains("::");
        }
        return false;
    }

    public int matchingDegree(@NotNull String name) {
        FList fragments;
        String string;
        int degree;
        if (name == null) {
            RubyQualifiedNamePrefixMatcher.$$$reportNull$$$0(6);
        }
        if ((degree = this.myLastComponentMatcher.matchingDegree(string = StringUtil.trimStart((String)name, (String)"::"), fragments = this.myLastComponentMatcher.matchingFragments(string))) <= 0 || fragments == null) {
            return degree;
        }
        int index = string.lastIndexOf("::");
        if (index < 0) {
            return degree + 100;
        }
        for (TextRange fragment : fragments) {
            if (fragment.getStartOffset() <= index) continue;
            ++degree;
        }
        return degree;
    }

    @NotNull
    private static Pair<String, String> getQualifierAndName(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            RubyQualifiedNamePrefixMatcher.$$$reportNull$$$0(7);
        }
        if (qualifiedName.contains("::")) {
            Pair pair = Pair.pair((Object)(StringUtil.substringBeforeLast((String)qualifiedName, (String)"::") + "::"), (Object)StringUtil.substringAfterLast((String)qualifiedName, (String)"::"));
            if (pair == null) {
                RubyQualifiedNamePrefixMatcher.$$$reportNull$$$0(8);
            }
            return pair;
        }
        Pair pair = Pair.pair((Object)"", (Object)qualifiedName);
        if (pair == null) {
            RubyQualifiedNamePrefixMatcher.$$$reportNull$$$0(9);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerFqn";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/qualifiedName/RubyQualifiedNamePrefixMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/qualifiedName/RubyQualifiedNamePrefixMatcher";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAndName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithPrefix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prefixMatches";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "qualifierMatches";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "matchingDegree";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierAndName";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9 -> new IllegalStateException(string);
        };
    }
}

