/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion.qualifiedName;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.SequencedCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.qualifiedName.RubyCompletionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbol;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyQualifiedNameSymbol;
import org.jetbrains.plugins.ruby.ruby.model.psi.RubyResolveUtil;
import org.jetbrains.plugins.ruby.ruby.model.psi.reference.RubyQualifiedNameSymbolReference;
import org.jetbrains.plugins.ruby.ruby.model.util.AssertionsKt;
import org.jetbrains.plugins.ruby.ruby.model.util.UtilKt;

public final class RubyQualifiedNameInsertHandler
implements InsertHandler<LookupElement> {
    public static final InsertHandler<LookupElement> INSTANCE = new RubyQualifiedNameInsertHandler();

    private RubyQualifiedNameInsertHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        int tailOffset;
        int startOffset;
        String candidate;
        if (context == null) {
            RubyQualifiedNameInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            RubyQualifiedNameInsertHandler.$$$reportNull$$$0(1);
        }
        if (!UtilKt.isRubyModellingV2()) {
            RubyQualifiedNameInsertHandler.handleInsertV1(context, item);
            return;
        }
        PsiElement element = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)Math.max(0, context.getTailOffset() - 1));
        RubyQualifiedNameSymbolReference reference = (RubyQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.findSymbolReferencesInElement((PsiElement)element, RubyQualifiedNameSymbolReference.class));
        if (reference == null) {
            return;
        }
        Project project = context.getProject();
        GlobalSearchScope searchScope = element.getResolveScope();
        RubyContainerSymbol container = reference.getContainer();
        FQN containerFqn = reference.getContainerFqn();
        FQN fqn = FQN.of((String)Strings.trimStart((String)item.getLookupString(), (String)"::"));
        Iterator iterator = RubyCompletionUtil.getCandidateRelativeQualifiedNames(containerFqn, fqn.getFullPath()).iterator();
        while (iterator.hasNext() && !(candidate = (String)iterator.next()).equals(item.getLookupString())) {
            Collection result = AssertionsKt.withBackgroundThreadAssertionDisabled(() -> RubyQualifiedNameInsertHandler.lambda$handleInsert$0(project, (SearchScope)searchScope, container, containerFqn, candidate));
            if (result.isEmpty() || !ContainerUtil.and((Iterable)result, it -> {
                RubyQualifiedNameSymbol target;
                return it instanceof RubyQualifiedNameSymbol && (target = (RubyQualifiedNameSymbol)it).getFqn().equals((Object)fqn);
            })) continue;
            int tailOffset2 = context.getCompletionChar() == '\t' ? reference.getElement().getTextRange().getEndOffset() : context.getTailOffset();
            context.getDocument().replaceString(context.getStartOffset(), tailOffset2, (CharSequence)candidate);
            context.commitDocument();
            return;
        }
        if (context.getCompletionChar() == '\t' && (startOffset = context.getTailOffset()) != (tailOffset = reference.getElement().getTextRange().getEndOffset())) {
            context.getDocument().deleteString(startOffset, tailOffset);
        }
    }

    @NotNull
    private static FQN getContainerFqn(@NotNull PsiElement element) {
        if (element == null) {
            RubyQualifiedNameInsertHandler.$$$reportNull$$$0(2);
        }
        FQN fQN = (FQN)ObjectUtils.coalesce((Object)((FQN)ObjectUtils.doIfNotNull((Object)RubyPsiUtil.getContainingRClassOrRModuleOrRFile(element), RElementWithFQN::getFQNWithNesting)), (Object)FQN.INVALID);
        if (fQN == null) {
            RubyQualifiedNameInsertHandler.$$$reportNull$$$0(3);
        }
        return fQN;
    }

    private static void handleInsertV1(@NotNull InsertionContext context, @NotNull LookupElement item) {
        String candidate;
        PsiElement element;
        Symbol contextSymbol;
        if (context == null) {
            RubyQualifiedNameInsertHandler.$$$reportNull$$$0(4);
        }
        if (item == null) {
            RubyQualifiedNameInsertHandler.$$$reportNull$$$0(5);
        }
        if ((contextSymbol = SymbolUtil.getScopeContextWithCaching(element = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)Math.max(0, context.getTailOffset() - 1)))) == null) {
            return;
        }
        FQN containerFqn = RubyQualifiedNameInsertHandler.getContainerFqn(element);
        FQN fqn = FQN.of((String)Strings.trimStart((String)item.getLookupString(), (String)"::"));
        Iterator iterator = RubyCompletionUtil.getCandidateRelativeQualifiedNames(containerFqn, fqn.getFullPath()).iterator();
        while (iterator.hasNext() && !(candidate = (String)iterator.next()).equals(item.getLookupString())) {
            Symbol symbol = SymbolUtil.lookupConstant(contextSymbol, element, FQN.of((String)candidate), Types.MODULE_OR_CLASS_OR_CONSTANT, element);
            if (symbol == null || !symbol.getFQNWithNesting().normalize().equals((Object)fqn)) continue;
            context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)candidate);
            context.commitDocument();
            break;
        }
    }

    private static /* synthetic */ SequencedCollection lambda$handleInsert$0(Project project, SearchScope searchScope, RubyContainerSymbol container, FQN containerFqn, String candidate) throws Exception {
        return RubyResolveUtil.resolveQualifiedName(project, searchScope, container, containerFqn, candidate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/qualifiedName/RubyQualifiedNameInsertHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/qualifiedName/RubyQualifiedNameInsertHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContainerFqn";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleInsertV1";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

