/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion.qualifiedName;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.CompletionResolveContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.ReferenceCompletionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyTrackedCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.exception.RubyExceptionCompletionFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.qualifiedName.RubyCompletableExceptionWrapper;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.qualifiedName.RubyCompletableQualifiedNameWrapper;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.model.psi.reference.RubyQualifiedNameSymbolReference;
import org.jetbrains.plugins.ruby.ruby.model.util.UtilKt;

public final class RubyQualifiedNameCompletionProvider
extends RubyTrackedCompletionProvider {
    public static final RubyQualifiedNameCompletionProvider INSTANCE = new RubyQualifiedNameCompletionProvider();

    private RubyQualifiedNameCompletionProvider() {
        super((Language)RubyLanguage.INSTANCE);
    }

    @Override
    protected void addCompletionsTracked(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            RubyQualifiedNameCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RubyQualifiedNameCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            RubyQualifiedNameCompletionProvider.$$$reportNull$$$0(2);
        }
        if (!UtilKt.isRubyModellingV2()) {
            return;
        }
        PsiElement element = parameters.getPosition();
        if (RubyPsiUtil.isPsiAfterNumberLiteral(element)) {
            return;
        }
        if (RubyPsiUtil.isInArgumentDeclaration(element)) {
            return;
        }
        Collection references = ExtensionsKt.findSymbolReferencesInElement((PsiElement)element);
        for (RubyQualifiedNameSymbolReference reference : ContainerUtil.filterIsInstance((Collection)references, RubyQualifiedNameSymbolReference.class)) {
            ProgressManager.checkCanceled();
            CompletionResolveContext type = (CompletionResolveContext)((Object)ObjectUtils.doIfNotNull((Object)RubyPsiUtilCore.getRealContext(reference.getElement()), ReferenceCompletionUtil::getContextType));
            if (type == CompletionResolveContext.EXCEPTION_REQUIRED) {
                new RubyCompletableExceptionWrapper(reference).addCompletionVariants(parameters, context, result);
                continue;
            }
            if (RubyExceptionCompletionFilter.isInRescue(element) && !RubyExceptionCompletionFilter.isInRescueBody(element)) continue;
            new RubyCompletableQualifiedNameWrapper(reference).addCompletionVariants(parameters, context, result);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/qualifiedName/RubyQualifiedNameCompletionProvider";
        objectArray[2] = "addCompletionsTracked";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

