/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion.qualifiedName;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SequencedCollection;
import java.util.SequencedSet;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;

public final class RubyCompletionUtil {
    private RubyCompletionUtil() {
    }

    @NotNull
    public static SequencedCollection<String> getCandidateRelativeQualifiedNames(@NotNull FQN containerFqn, @NotNull String name) {
        if (containerFqn == null) {
            RubyCompletionUtil.$$$reportNull$$$0(0);
        }
        if (name == null) {
            RubyCompletionUtil.$$$reportNull$$$0(1);
        }
        if (containerFqn == FQN.INVALID || !name.contains("::") || !name.startsWith((String)containerFqn.asList().get(0) + "::")) {
            List<CallSite> list = List.of(name, "::" + name);
            if (list == null) {
                RubyCompletionUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        TreeSet<String> candidates = new TreeSet<String>(Comparator.comparingInt(String::length).thenComparing(Comparator.naturalOrder()));
        candidates.addAll(Set.of(name, "::" + name));
        List namePath = StringUtil.split((String)name, (String)"::");
        containerFqn.processNestingResolution(nesting -> {
            if (nesting == FQN.INVALID) {
                return false;
            }
            List nestingPath = nesting.asList();
            return !ContainerUtil.startsWith((List)namePath, (List)nestingPath) || candidates.add(StringUtil.join(namePath.subList(nestingPath.size(), namePath.size()), (String)"::"));
        });
        SequencedSet<String> sequencedSet = Collections.unmodifiableSequencedSet(candidates);
        if (sequencedSet == null) {
            RubyCompletionUtil.$$$reportNull$$$0(3);
        }
        return sequencedSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerFqn";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/qualifiedName/RubyCompletionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/qualifiedName/RubyCompletionUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidateRelativeQualifiedNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCandidateRelativeQualifiedNames";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

